{                                6/11/1995
			       "Bezier Draw"
				   from
			     Component Paradise
		    http://acsusun.acsu.unsw.edu.au/~s9200168

The "Bezier Draw" is a sample Delphi program to demonstrate the use of "Bezier"
unit.
			       IMPORTANT

You can use this code as is and you are free to copy/distribute provided that
this "readme.txt" is not modified and included in the distrubution pack. Source
code for the Bezier is NOT available but you could register for Bezier.DCU ($25).

I'll be more than happy to hear from you for your comments, applications etc.

   Due to enermous email traffic I have, please send your comments to
   "Ali@CCLRU.UNSW.EDU.AU" with subject field starting with
   the words 'Component Paradise'.

   Example:
      To      : Ali@CCLRU.UNSW.EDU.AU
      Subject : Component Paradise ...
		^^^^^^^^^^^^^^^^^^^
		This help me to filter your comments.

   All the best...

   Ali H. GOKTOGAN

   --------------------------------------------------------------
   "Bilgi paylasildiginda degerlidir.."
   "Knowledge has a value when you share it with others."
					    A Turkish proverb

   "You never lose when you give...
    You never lose when you share..."
			A Turkish proverb
   --------------------------------------------------------------


  This Bezier drawing demo program use BezierCurve function from Bezier unit.
  Function definition as follows;

  function BezierCurve(const ControlPoints         : array of RPoint2D;
		       const NumberOfControlPoints : integer;
		       const NumberOfCurvePoints   : integer;
			 var CurvePoints           : array of RPoint2D) : Boolean;
  where
    RPoint2D = record
		 x, y : real;  X and Y Coordinates
	       end;
  function returns FALSE either if
     o Number of control points < 3
     o Number of control points > 30

}

unit Main;

interface

uses
  SysUtils, WinTypes, WinProcs, Messages, Classes, Graphics, Controls,
  Forms, Dialogs, Buttons, Menus, ExtCtrls, StdCtrls, Rot3DLbl, Mvball,
  Scrlimg, BouncImg;

type
  TForm1 = class(TForm)
    Panel1: TPanel;
    Panel2: TPanel;
    Panel3: TPanel;
    spdBtnStart: TSpeedButton;
    spdBtnClear: TSpeedButton;
    spdBtnExit: TSpeedButton;
    Panel4: TPanel;
    Panel5: TPanel;
    PaintBox1: TPaintBox;
    MovingBall1: TMovingBall;
    Rotateable3DLabel1: TRotateable3DLabel;
    Timer1: TTimer;
    Label1: TLabel;
    lblNumOfPnts: TLabel;
    spdBtnCtrlPnts: TSpeedButton;
    spdBtnCtrlLine: TSpeedButton;
    spdBtnRedraw: TSpeedButton;
    spdBtnDrag: TSpeedButton;
    ScrollBar1: TScrollBar;
    Label2: TLabel;
    Label3: TLabel;
    Rotateable3DLabel3: TRotateable3DLabel;
    BouncingImage1: TBouncingImage;
    BouncingImage2: TBouncingImage;
    procedure Exit1Click(Sender: TObject);
    procedure Timer1Timer(Sender: TObject);
    procedure PaintBox1MouseUp(Sender: TObject; Button: TMouseButton;
      Shift: TShiftState; X, Y: Integer);
    procedure spdBtnClearClick(Sender: TObject);
    procedure DrawBezier;
    procedure spdBtnRedrawClick(Sender: TObject);
    procedure PaintBox1MouseMove(Sender: TObject; Shift: TShiftState; X,
      Y: Integer);
    procedure spdBtnDragClick(Sender: TObject);
    procedure PaintBox1MouseDown(Sender: TObject; Button: TMouseButton;
      Shift: TShiftState; X, Y: Integer);
    procedure ScrollBar1Change(Sender: TObject);
  private
    { Private declarations }
  public
    { Public declarations }
  end;


var
  Form1: TForm1;


implementation

{$R *.DFM}
Uses Bezier;

const
  MaxNumOfCtrlPnts = 30; {Max 30 points } 
var
  {RPoint2D = Point of real valued coordinates}
  CtrlPnts  : array [0..MaxNumOfCtrlPnts] of RPoint2D; { Control points }
  CurvePnts : array [0..300] of RPoint2D;              { Curve points   }
  PointNo   : integer;                                 { Number of control points}
  PointNoToDrag : integer;


procedure TForm1.PaintBox1MouseUp(Sender: TObject; Button: TMouseButton;
  Shift: TShiftState; X, Y: Integer);
begin
  if spdBtnStart.Down and (Button = mbLeft) and (not spdBtnDrag.Down) then begin
     if PointNo=MaxNumOfCtrlPnts then begin
	DrawBezier;
	MessageDlg('This demo program allows max '+ intToStr(MaxNumOfCtrlPnts)+
		   ' control points.',
		    mtWarning, [mbOk], 0);
	exit;
     end;
     CtrlPnts[PointNo].X := x;
     CtrlPnts[PointNo].Y := y;
     with PaintBox1.Canvas do begin
       if spdBtnCtrlLine.Down then
	  if PointNo = 0 then MoveTo(trunc(CtrlPnts[PointNo].X),trunc(CtrlPnts[PointNo].Y))
	     else begin
	       Pen.Color := clYellow;
	       LineTo(trunc(CtrlPnts[PointNo].X),trunc(CtrlPnts[PointNo].Y));
	  end;

       if spdBtnCtrlPnts.Down then begin
	  Pen.Color := clRed;
	  Ellipse(trunc(CtrlPnts[PointNo].X)-2,trunc(CtrlPnts[PointNo].Y)-2,
		  trunc(CtrlPnts[PointNo].X)+2,trunc(CtrlPnts[PointNo].Y)+2);
       end;
     end;{with ...}
     inc(PointNo);
     lblNumOfPnts.caption := IntToStr(PointNo);

     { Bezier curve for less than three point is meaningless }
     if PointNo > 2 then DrawBezier;
  end;
  PointNoToDrag := -1; { Don't drag the control points }
end;

procedure TForm1.DrawBezier;
var i,
    NumOfCurvePnts : integer;
begin
  { Bezier curve for less than three point is meaningless }
  if PointNo < 3 then exit;
  PaintBox1.Refresh; { Clear the drawing area }

  NumOfCurvePnts := ScrollBar1.Position;

  BezierCurve(CtrlPnts, PointNo, NumOfCurvePnts, CurvePnts);

  with PaintBox1.Canvas do begin
    for i:= 0 to PointNo-1 do begin
      if spdBtnCtrlLine.Down then
	 if i = 0 then MoveTo(trunc(CtrlPnts[i].X),trunc(CtrlPnts[i].Y))
	    else begin
	      Pen.Color := clYellow;
	      LineTo(trunc(CtrlPnts[i].X),trunc(CtrlPnts[i].Y));
	    end;

      if spdBtnCtrlPnts.Down then begin
	 Pen.Color := clRed;
	 Ellipse(trunc(CtrlPnts[i].X)-2,trunc(CtrlPnts[i].Y)-2,
		    trunc(CtrlPnts[i].X)+2,trunc(CtrlPnts[i].Y)+2);
      end;
    end;{for i:= 0...}

    Pen.Color := clRed;
    MoveTo(trunc(CurvePnts[0].X),trunc(CurvePnts[0].Y));
    Pen.Color := clNavy;
    for i := 1 to NumOfCurvePnts-1 do begin
      PaintBox1.Canvas.LineTo(trunc(CurvePnts[i].X),trunc(CurvePnts[i].Y));
    end;
  end;
end;

procedure TForm1.spdBtnClearClick(Sender: TObject);
begin
  spdBtnDrag.Down := False;
  PaintBox1.Refresh;
  PointNo := 0;
  lblNumOfPnts.caption := IntToStr(PointNo);
end;

procedure TForm1.Exit1Click(Sender: TObject);
begin
  Close;
end;

procedure TForm1.Timer1Timer(Sender: TObject);
begin
  Rotateable3DLabel1.Angle := (Rotateable3DLabel1.Angle + 15) mod 360;
end;



procedure TForm1.spdBtnRedrawClick(Sender: TObject);
begin
  DrawBezier;
end;

procedure TForm1.PaintBox1MouseMove(Sender: TObject; Shift: TShiftState; X,
  Y: Integer);
begin
  if spdBtnDrag.Down and (PointNoToDrag >=0) then begin
     CtrlPnts[PointNoToDrag].X := x;
     CtrlPnts[PointNoToDrag].Y := y;
     DrawBezier;
  end;{}
end;

procedure TForm1.spdBtnDragClick(Sender: TObject);
begin
  PointNoToDrag := -1;
end;

procedure TForm1.PaintBox1MouseDown(Sender: TObject; Button: TMouseButton;
  Shift: TShiftState; X, Y: Integer);
var i : integer;
begin
  if (Button = mbLeft) and spdBtnDrag.Down then begin
    i := 0;
    PointNoToDrag := -1;
    while (i<= MaxNumOfCtrlPnts) and (PointNoToDrag<0) do begin
      if (abs(CtrlPnts[i].X-x)<5) and (abs(CtrlPnts[i].Y-y)<5) then
	 PointNoToDrag := i;
      inc(i);
    end;
  end;{if ...}
end;

procedure TForm1.ScrollBar1Change(Sender: TObject);
begin
  DrawBezier;
  Label3.Caption := IntToStr(ScrollBar1.Position);
end;

end.
