{ ****************************************************************
  * CopyRight (c) 1996 Valentn Snchez Izquierdo                *
  * FECHA: 11/02/96                                              *
  * DESCRIPCION:                                                 *
  * Manejo de ALIAS durante programa construido como             *
  * un VCL, se esperimenta                                       *
  * CIS: 100763,1776                                             *
  * Email: 100763,1776@Compuserve.com                            *
  ****************************************************************}
{ Historia 
 1.0 - Capacidad de crear un Alias
 1.0a- Se aade el poder borrar alias
 1.1- Eliminacion del copyright en el editor
 1.2- Verificacion de un alias
}

unit Dbialias;

interface

uses
  DsgnIntf,SysUtils, WinTypes, Classes,WinProcs, 
  Dialogs,DbiTypes, DbiProcs,DbiErrs,DB;


type
  { Creamos nul-terminate string, compatible con llamadas C}
  zstring = array[0..255] of char;
  drives = ( PARADOX, DBASE,ASCIIDRV,NOSUPORTED ); {Solo se soportan estos dos tipos} 
  TSymbolStr = string[DBIMAXNAMELEN];
  versions = ( V102 );
  
  {Componente....}
  TAliasMan = class(TComponent)
  private
         sPath: string;              {Path del Alias}
         sALias: string;             {string del alias}
         snDrive: drives;            {drive}
         AliasList: TStringList;     {Lista de Alias}
         PathList: TStringList;      {Lista de Path}
         sVer: versions;               {version}
    { Private declarations }
  protected
    { Protected declarations }
   procedure GetAliasList;
   function RetCfgFile(CfgPath: pCHAR): string;
  public
    { Public declarations }
    constructor Create( aOwner: TComponent ); override;
    Destructor Destroy; override;

    function Add: DBIresult;          {Lo hace....???}
    function Delete: DBIresult;
    function GetPath: string;
    procedure SetPath( sNewPath: string );
    function GetAlias: string;
    procedure SetAlias( sNewAlias: string);
    function GetDriver: string;
    procedure SetDriver( sNewDriver: string );
    function IsAlias( zsName: string):Boolean;
    procedure GetAliasLst( sList: TStringList );

  published
    { Published declarations }
    Property Alias : string Read sAlias Write sAlias;
    Property Path : string Read sPath Write sPath;
    Property Drive: drives Read snDrive Write snDrive default PARADOX;
    Property Version: versions Read sVer Write sver; 
    
  end;

procedure Register;

{Declaracion de la funcion que llama al IDAPI version 2.51 del BDE}
function DeleteAlias( hCfg: hDbiCfg; pszAliasName: PChar ): DBIResult; 

implementation
{CONSTRUCTOR, curiosamente si no se redefine el constructor no deja}
{editar las propiedades en el O.Browser}
constructor TAliasMan.Create;
begin
     inherited Create( aOwner );
     snDrive := PARADOX;
     sVer := V102;

     {Memoria para las Listas}
     AliasList:=TStringList.Create;
     PathList:=TStringList.Create; 
end;

destructor TAliasMan.Destroy;
begin
     {Liberamos memoria de las stringlist}
     AliasList.Free;
     PathList.Free; 
     inherited Destroy;                   {llamada al destructor padre}
end;

{Implementacion de llamada al IDAPI, o una DLL cualquiera  }
function DeleteAlias( hCfg: hDbiCfg; pszAliasName: PChar ): DBIResult; 
                    external 'IDAPI01' index 1130;


{ Aqui empieza el codigo**************************************************}
{Registro del VCL }
procedure Register;
begin
  RegisterComponents('Kernel', [TAliasMan]);
end;

{Realiza la llamada al IDAPI}
function TAliasMan.Delete: DBIResult;
var
   szAlias : zstring;
begin
   try
         {Traspaso de variables}
         StrPCopy( szAlias, sAlias );
         Result := DeleteAlias( nil, @szAlias );
   except
        raise exception.create('ERROR: AliasMan: 001');
   end;
         
end;   

function TAliasMan.Add: DBIResult;
var
   szAlias, szPath, szDriver : zstring;
   
begin
   {Capura de errores tipo pilsen}
   try
         {Traspaso de variables}
         StrPCopy( szAlias, sAlias );
         StrPCopy( szPath, 'PATH:' + sPath );
         case snDrive of
              PARADOX:  StrPCopy( szDriver, 'PARADOX');
              DBASE:    StrPCopy( szDriver, 'DBASE');
              ASCIIDRV: StrPCopy( szDriver, 'ASCIIDRV');
         end;
         {NOTA: Esta visto que el sistema no necesita inicializar el IDAPI
                para aadir un alias, o el sistema lo inicializa por
                defecto....mistery
         }
         {Llamada al IDAPI }
         Result := DbiAddAlias( nil, @szAlias, @szDriver, @szPath, true);
   except
        raise exception.create('ERROR AlisMan: 002');
   end;
end;

{ Get/Set para las propiedades del VCL }
function TAliasMan.GetPath : string;
begin
     GetPath := sPath;
end;
procedure TAliasMan.SetPath( sNewPath: string );
begin
     sPath := sNewPath;       
end;

function TAliasMan.GetAlias: string;
begin
     GetAlias := sAlias;
end;
procedure TAliasMan.SetAlias( sNewAlias: string);
begin
     sAlias := sNewAlias;
end;
function TAliasMan.GetDriver: string;
var sRet: string;
begin
     case snDrive of
          PARADOX: sRet := 'PARADOX';
          DBASE:   sRet := 'DBASE';
          ASCIIDRV:sRet := 'ASCIIDRV'; 
          NOSUPORTED: sRet := 'NOSUPORTED';
     end;
     GetDriver := sRet;
end;

procedure TAliasMan.SetDriver( sNewDriver: string );
begin
     snDrive := NOSUPORTED;
     if sNewDriver = 'PARADOX'  then snDrive := PARADOX;
     if sNewDriver = 'DBASE'  then snDrive := DBASE;
     if sNewDriver = 'ASCIIDRV'  then snDrive := ASCIIDRV;
end; 


{Recobra del IDAPI la lista de Alias}
procedure  TALiasMan.GetAliasList;
var
  Cursor: HDBICur;
  Name: TSymbolStr;
  Desc: DBDesc;
begin
  AliasList.BeginUpdate;
  PathList.BeginUpdate;
  try
    AliasList.Clear;
    PathList.Clear;
    Check(DbiOpenDatabaseList(Cursor));  {Utilizamos el control de errores del DB} 
    try
      while DbiGetNextRecord(Cursor, dbiNOLOCK, @Desc, nil) = 0 do
      begin
        OemToAnsi(Desc.szName, Desc.szName);
        AliasList.Add(StrPas(Desc.szName));            {Captura de alias}

        OemToAnsi(Desc.szPhyName, Desc.szPhyName);
        PathList.Add(StrPas(Desc.szPhyName));          {Captura de Patch}

      end;
    finally
      DbiCloseCursor(Cursor);
    end;
  finally
    AliasList.EndUpdate;
    PathList.EndUpdate;
  end;
end;

{----------Comprueba la existencia de un alias------------------}
function TAliasMan.IsAlias( zsName: string):Boolean;
var
   n, nMax: Integer;
   zsCfg: string;
   psCfg: zstring;
begin
     Result := False;
     GetAliasList;
     nMax := AliasList.Count -1;
     {Reseteamos valores}
     sPath:='';
     sALias:='';
     snDrive:=NOSUPORTED;
     

     for n:=0 to nMax do
     begin
          if AliasList.Strings[n] = zsName then 
          begin
               sAlias := AliasList.Strings[n];
               sPath  := PathList.Strings[n];
               zsCfg := '\DATABASES\' + AliasList.Strings[n] + '\DB INFO\';
               strPCopy( psCfg, zsCfg );
               SetDriver( RetCfgFile( psCfg ) );
               Result := true;
               Exit;
          end;
     end;

end;
procedure TAliasMan.GetAliasLst( sList: TStringList );
var
   n, nMax: Integer;
begin
     GetAliasList;
     sList.Clear;
     sList.BeginUpdate;
     nMax := AliasList.Count - 1;
     for n:=0 to nMax do
         sList.Add( AliasList.strings[n] );
     sList.EndUpdate;
end;
{-------------------------------- Dirver -------------}

function TAliasMan.RetCfgFile(CfgPath: pCHAR): string;


var
    rslt: DBIResult;        { Valor de retorno funciones IDAPI}
    hList: hDBICur;         { Handle del  Cursor }
    szNode: pCHAR;          { string con nombre del nodo }
    pCfgDes: pCFGDesc;      { Descriptor de configuracion}
    n: integer;           { variable para loop }
    BaseSize: integer;        { longitud del nodo actual }

begin
  
  rslt := DbiOpenCfgInfoList(nil, dbiREADONLY, cfgPersistent,
                                       CfgPath, hList);
                                       
  
    if (rslt = DBIERR_NONE) then
    begin
        { pillamos memoria }
        GetMem(szNode, 512);
        GetMem(pCfgDes, sizeof(CFGDesc));

        { Inicializamos descriptor con ceros}
        FillChar(pCfgDes^, sizeof(CFGDesc), #0);

        { Pillamos el tercer valor que es el que nos interesa }
        for n := 1 to 3 do
                DbiGetNextRecord(hList, dbiNOLOCK, pCfgDes, nil);

            { Limpiamos variable szNode}
            FillChar(szNode^, 512, #0);
             { Tamao del nodo }
            BaseSize := StrLen(szNode);

            StrPCopy(@szNode[BaseSize], pCfgDes^.szValue+' ');
            Result := (StrPas(szNode));

        { liberar memoria }
        FreeMem(szNode, 512);
        FreeMem(pCfgDes, sizeof(CFGDesc));

        if (hList <> nil) then
        begin
            DbiCloseCursor(hList)
        end;
    end;
end;








end.
