unit Lastpos1;

interface

uses
  Windows, Messages, SysUtils, Classes, Graphics, Controls, Forms, Dialogs;

type
  Lastpos = class(TComponent)
 private
 fFileName:string;
 fform:TForm;
    { Private declarations }
  protected
    { Protected declarations }
  public
    { Public declarations }
  constructor Create(AOwner : TComponent); override;
  published
    { Published declarations }
    procedure SavePos;
    procedure LoadPos;
    property FileName : string  read fFileName write fFileName;
    property Form  :TForm read fform write fform;
  end;

procedure Register;

implementation
procedure Register;
begin
  RegisterComponents('Custom', [Lastpos]);
end;
constructor lastpos.Create(AOwner : TComponent);
begin
inherited Create(AOwner);
Filename:='C:\';
end;

procedure lastpos.loadpos;
var
s:tstringlist;
begin
s:=tstringlist.Create;
try
s.LoadFromFile(filename);
form.left:=strtoint(s.strings[0]);
form.Top:=strtoint(s.strings[1]);
form.Width:=strtoint(s.strings[2]);
form.Height:=strtoint(s.strings[3]);
if s.strings[4]='wsNormal' then form.WindowState:=wsNormal;
if s.strings[4]='wsMaximized' then form.WindowState:=wsMaximized;
if s.strings[4]='wsMinimized' then form.WindowState:=wsMinimized;
s.free;
except
on E : Exception do begin
case MessageDlg('Damaged Program File Attempt To Repair?', mtWarning,
[mbYes, mbNo, mbCancel], 0)of
id_yes:savepos;
id_no:application.Terminate;
end;
end;
end;
end;

procedure lastpos.savepos;
var
s:tstringlist;
begin
s:=tstringlist.Create;
s.Add(inttostr(form.Left));
s.add(inttostr(form.Top));
s.add(inttostr(form.Width));
s.add(inttostr(form.Height));
if form.WindowState=wsNormal then s.add('wsNormal')  ;
if form.WindowState=wsMaximized then s.add('wsMaximized');
if form.WindowState=wsMinimized  then s.add('wsMinimized');
s.savetoFile(filename);
s.free;
end;
end.
