unit Unit1;

interface

uses
  Windows, Messages, SysUtils, Classes, Graphics, Controls, Forms, Dialogs,
  StdCtrls, ExtCtrls;

type
  TForm1 = class(TForm)
    Image1: TImage;
    Timer1: TTimer;
    FontDialog1: TFontDialog;
    ListBox1: TListBox;
    Label2: TLabel;
    Label3: TLabel;
    Image2: TImage;
    Label1: TLabel;
    procedure Button1Click(Sender: TObject);
    procedure Timer1Timer(Sender: TObject);
    procedure FormCreate(Sender: TObject);
    procedure Button2Click(Sender: TObject);
    procedure ListBox1DblClick(Sender: TObject);
  private
    { Private declarations }
  public
    { Public declarations }
    Procedure AngleTextOut(CV: TCanvas; const sText: String; x,y, angle,size:integer);
    Procedure ClearImage(CV:TCanvas;x,y:Integer;Col: TColor);
    Procedure CreateSinTab2(S:String);
    Procedure CopyBes(Var s:String;buf:String;num,siz:Integer);
  end;

var
  Form1: TForm1;
  opcija: Integer;
  cnt,xi,yi,xt,yt,xa,ya,xc,yc,xb,yb,xo,yo,xd,yd:Integer;
  Beseda:String;//Besed:Array[1..10] Of String[50];BesedCnt:Integer;
//  Besedal:String;
  SinTable:Array[0..720] of integer;
  SinTab  :Array[0..1080] Of integer;
implementation

{$R *.DFM}
//***************************************************************************************
procedure TForm1.AngleTextOut(CV: TCanvas; const sText: String; x,y, angle,size:integer);
var
   LogFont: TLogFont;
   SaveFont: TFont;
begin
  SetGraphicsMode(CV.Handle, GM_ADVANCED);//for NT
  CV.Font.Size:=size;
//  CV.Font.Color:=Col;
  SaveFont := TFont.Create;
  SaveFont.Assign(CV.Font);
  GetObject(SaveFont.Handle, sizeof(TLogFont), @LogFont);
  with LogFont do
  begin
    lfEscapement := angle *10;
    lfOrientation:= angle *10;
    lfPitchAndFamily := FIXED_PITCH or FF_DONTCARE;
  end;
  CV.Font.Handle := CreateFontIndirect(LogFont);
  SetBkMode(CV.Handle, TRANSPARENT);
  CV.TextOut(x, y, sText);
  CV.Font.Assign(SaveFont);
  SaveFont.Free;
end;
//*************************************************************************************
Procedure TForm1.ClearImage(CV:TCanvas;x,y:Integer;Col: TColor);
Var i:Integer;
begin
  CV.Pen.Color:=Col;
  For i:=0 To y Do
  Begin
    CV.MoveTo(0,i);
    CV.LineTo(x,i);
  End;
End;
Procedure TForm1.CreateSinTab2(S:String);
Var i:Integer;r,o:Integer;
Begin
  o:=Image1.Canvas.TextWidth(s);
  r:=Round(o/(2*Pi))*3;xc:=r;yc:=360 div xc;
  For i:=0 To 1080 Do
  Begin
    SinTab[i]:=Round(Sin(i/57.29577951)*r);
  End;
End;
Procedure TForm1.CopyBes(Var s:String;buf:String;num,siz:Integer);
Var i,c:Integer;
Begin
  s:='';
  if (num+siz)<length(buf)Then
  Begin
    for i:=num to num+siz do s:=s+buf[i];
  End Else
  Begin
    c:=num;
    for i:=num to num+siz do
    Begin
      Inc(c);
      if c>Length(buf) Then c:=1;
      s:=s+buf[c];
    End;
  End;
End;
procedure TForm1.Button1Click(Sender: TObject);
Var x,y:Integer;
Begin
  x:=round(arctan(11/8)*57.295);
  label1.Caption:=inttostr(x);
end;

procedure TForm1.Timer1Timer(Sender: TObject);
Var i,l,sl,bfr,fi:Integer;r:real;
begin
  Timer1.Enabled:=False;
  If opcija=1 Then
  Begin
    cnt:=cnt+10;
    Image1.Canvas.Font.Color:=Rgb(170,100,50);
    AngleTextOut(Image1.Canvas,'Gepard!',xi div 2, yi div 2,xa,12);
    Image1.Canvas.Font.Color:=Rgb(0,0,200);
    AngleTextOut(Image1.Canvas,'Gepard!',xi div 2, yi div 2,cnt,12);
    xa:=Cnt;
    if cnt>360 Then cnt:=0;
    Image1.Update;
  End;
  If opcija=4 Then
  Begin
    Image2.Canvas.Font.Size:=8;
    l:=Length(Beseda);cnt:=0;
    sl:=Image2.Canvas.TextWidth(Beseda);
    Image2.Canvas.Font.Color:=Rgb(170,100,50);
    for i:=1 To l Do
    Begin
      AngleTextOut(Image2.Canvas,Beseda[i],10+i*(sl div l)*3, yi div 2+SinTable[i],SinTable[i+88],8);
    End;
    bfr:=SinTable[0];For i:=1 To 720 Do SinTable[i-1]:=SinTable[i];
    SinTable[720]:=bfr;
    Image2.Canvas.Font.Color:=Rgb(0,0,200);
    for i:=1 To l Do
    Begin
      AngleTextOut(Image2.Canvas,Beseda[i],10+i*(sl div l)*3, yi div 2+SinTable[i],SinTable[i+88],8);
    End;
    Image1.Canvas.Draw(0,0,Image2.Picture.Bitmap);
    Image1.Update;
  End;
  If opcija=3 Then
  Begin
    ya:=ya+5;
    ClearImage(Image2.Canvas,Image2.Width,Image2.Height,Rgb(170,100,50));
    Image2.Canvas.Font.Color:=Rgb(0,0,200);
    l:=Length(Beseda);
    //sl:=Image2.Canvas.TextWidth(Beseda);
    For i:=1 To l Do
    Begin
      AngleTextOut(Image2.Canvas,Beseda[i],xi div 2-SinTab[i*(360 div l)+ya], yi div 2-SinTab[i*(360 div l)+90+ya],{SinTab[i*5+ya]*yc}(i*360 div l)+180+ya,8);
    End;
    Image1.Canvas.Draw(0,0,Image2.Picture.Bitmap);
    Image1.Update;
    If ya>360 then ya:=0;
  End;
  If Opcija=2 Then
  Begin
    Image2.Canvas.Font.Color:=Rgb(170,100,50);
    AngleTextOut(Image2.Canvas,beseda,xo+xd-xb, yo-yd+yb,ya,11);
    ya:=ya+10;
    l:=Length(Beseda);
    Image2.Canvas.Font.Size:=11;
    xd:=Image2.Canvas.TextWidth(beseda) div 2;
    yd:=-Image2.Canvas.TextHeight(beseda) div 2;
    xo:=xi div 3;
    yo:=xi div 3;

    Image2.Canvas.Font.Color:=Rgb(0,0,200);
    r:=sqrt(sqr(xd)+sqr(yd));
    fi:=round(arctan(yd/xd)*57.29577951)+ya;
    xb:=round(r*cos(fi/57.29577951));
    yb:=round(r*sin(fi/57.29577951));
    AngleTextOut(Image2.Canvas,beseda,xo+xd-xb, yo-yd+yb,ya,11);
    Image1.Canvas.Draw(0,0,Image2.Picture.Bitmap);
    Image1.Update;
    If ya>360 then ya:=0;
  End;
  Timer1.Enabled:=True;
end;

procedure TForm1.FormCreate(Sender: TObject);
Var i:Integer;
begin
  for i:=0 to 720 do
  Begin
    SinTable[i]:=Round(Sin(i/5)*30);
  End;
  opcija:=0;
  xi:=Image1.Width;
  yi:=Image1.Height;
  Image1.Canvas.Font.Name:='Arial';
  cnt:=60;
  CreateSinTab2('Examples by ToMaS!  ');
end;

procedure TForm1.Button2Click(Sender: TObject);
begin
  If FontDialog1.Execute Then
  Begin
    Image1.Canvas.Font:=FontDialog1.Font;
  End;
end;

procedure TForm1.ListBox1DblClick(Sender: TObject);
Var s:String;x,y:Integer;
begin
  s:=ListBox1.Items[ListBox1.ItemIndex];
  If s<>'' Then
  Begin
    Opcija:=Ord(s[1])-48;
    x:=Image1.Width;
    y:=Image1.Height;
    ClearImage(Image1.Canvas,x,y,Rgb(170,100,50));
    ClearImage(Image2.Canvas,x,y,Rgb(170,100,50));
    Timer1.Enabled:=True;
    If Opcija=3 Then beseda:='Examples by ToMaS!  ';
    If Opcija=2 Then Begin Beseda:='tzveglic@hotmail.com';CreateSinTab2(Beseda);End;
    If Opcija=4 Then Begin beseda:='Hello from gepard studio!';End;
  End;
end;

end.
