unit Ampuleta;

interface

{*******************************************************************************
Ampuleta animada. TAmpuletaAnimada

Autor: Reinaldo M.R. Alves
Data: 04/04/97

Propriedades e eventos:

    Interval => Velocidade da animao.
    Enabled  => True opera a animao e False restaura o cursor
                para crDefault.
    OnTimer  => Semelhante ao OnTimer do TTimer.
*******************************************************************************}

(*******************************************************************************
Ampuleta. TAmpuleta

Autor: Reinaldo M.R. Alves
Data: 05/04/97

Propriedades:
        TipoAmpuleta: TTipoAmpuleta => Informe o tipo de ampuleta desejada
                      para indicar espera. taNormal ou taAnimada.

Mtodos:
        SetaCursor( const lStatus: Boolean) => Altera o cursor do mouse.
                    lStatus = True coloca em estado de espera
                    lStatus = False coloca no estado padro.
                    Cada informao  armazenado na pilha para posterior
                    restaurao.
        RestauraCursor => Restaura o ltimo estado da ampuleta.

        LimpaPilha => Limpa a pilha que armazena a sequencia de alterao
                      do cursor.

Indicao de uso:
      Instancie este componente apenas uma nica vez na execuo do
programa, como objetos Application e Printer.


Exemplo:

try
   FAmpuleta.SetaCursor( True);
   .
   . {Processamento}
   .
finally
       FAmpuleta.RestauraCursor;
end;
*******************************************************************************)

{*******************************************************************************
Agradecimentos:
A Doug Colman que disponibilizou um fonte com os desenhos de cursor's,
fundamentais para a criao deste componente.

Este componente  de domnio pblico. Sendo proibido a venda do mesmo
sem a autorizao de seu autor.
O autor no se responsabiliza por qualquer dano causado pelo uso do
mesmo.
Qualquer bug apresentado, crtica ou necessidade de melhorias, por favor
fale-me.
Qualquer melhoria feita por voce peo que me envie uma cpia.

Reinaldo
alfa@stinet.com.br
Belo Horizonte - MG
Brasil
*******************************************************************************}

{*******************************************************************************
Aleluia! Bem-aventurado o homem que teme ao SENHOR, e se compraz nos seus
mandamentos. Sl 112:1
*******************************************************************************}

uses
  SysUtils, WinTypes, WinProcs, Messages, Classes, Graphics, Controls,
  Forms, Dialogs, ExtCtrls;

type
  TAmpuletaAnimada = class(TTimer)
  private
    { Private declarations }
    FCont: Byte;
    procedure GambiTimer( Sender: TObject);
    procedure SetEnabled( Value: Boolean);
    function GetEnabled: Boolean;
  protected
    { Protected declarations }
    procedure Timer; override;
  public
    { Public declarations }
    constructor Create( AOwner: TComponent); override;
  published
    { Published declarations }
    property Enabled: Boolean read GetEnabled write SetEnabled;
  end;

  TTipoAmpuleta = (taAnimada, taNormal);

  TAmpuleta = class( TComponent)
  private
         FAmpAni: TAmpuletaAnimada;
         FTipoAmpuleta: TTipoAmpuleta;
         Flifo: LongInt;
         procedure SetTipoAmpuleta( Value: TTipoAmpuleta);
         procedure SetaCursorAux( const lStatus: Boolean);
  public
        constructor Create( AOwner: TComponent); override;
        procedure SetaCursor( const lStatus: Boolean);
        procedure RestauraCursor;
        procedure TAmpuleta.LimpaPilha;
        property TipoAmpuleta: TTipoAmpuleta read FTipoAmpuleta write SetTipoAmpuleta default taAnimada;
  end;

procedure Register;

implementation

{$R hourgzpd.res}

procedure Register;
begin
  RegisterComponents('XT', [TAmpuleta]);
end;

{*******************************************************************************
TAmpuletaAnimada
*******************************************************************************}
constructor TAmpuletaAnimada.Create( AOwner: TComponent);
begin
inherited Create( AOwner);
screen.cursors[1] := LoadCursor(hInstance, pChar('CURSOR_1'));
screen.cursors[2] := LoadCursor(hInstance, pChar('CURSOR_2'));
screen.cursors[3] := LoadCursor(hInstance, pChar('CURSOR_3'));
screen.cursors[4] := LoadCursor(hInstance, pChar('CURSOR_4'));
screen.cursors[5] := LoadCursor(hInstance, pChar('CURSOR_5'));
screen.cursors[6] := LoadCursor(hInstance, pChar('CURSOR_6'));
screen.cursors[7] := LoadCursor(hInstance, pChar('CURSOR_7'));
screen.cursors[8] := LoadCursor(hInstance, pChar('CURSOR_8'));
screen.cursors[9] := LoadCursor(hInstance, pChar('CURSOR_9'));
screen.cursors[10]:= LoadCursor(hInstance, pChar('CURSOR_10'));

OnTimer  := GambiTimer;
Enabled  := False;
FCont    := 1;
Interval := 200;
end;

{-------------------------------------------------------------------------------
override na propriedade enabled
-------------------------------------------------------------------------------}
function TAmpuletaAnimada.GetEnabled: Boolean;
begin
Result := inherited Enabled;
end;

procedure TAmpuletaAnimada.SetEnabled( Value: Boolean);
begin
inherited Enabled := Value;
if Not Value then screen.cursor := crDefault;
end;

{-------------------------------------------------------------------------------
Eventos
-------------------------------------------------------------------------------}
procedure TAmpuletaAnimada.Timer;
begin
inherited Timer;
Inc(FCont);
if FCont>10 then FCont:=1;
screen.cursor:=FCont;
end;

procedure TAmpuletaAnimada.GambiTimer( Sender: TObject);
begin
{A procedure Timer somente  executada se OnTimer<>nil}

{No transferi o fonte da procedure Timer para GambiTimer,
visto que isto impossibilitaria a utilizao do evento
OnTimer por rotinas externas.}
end;

{*******************************************************************************
TAmpuleta
*******************************************************************************}
constructor TAmpuleta.Create( AOwner: TComponent);
begin
inherited Create(AOwner);
SetTipoAmpuleta(taAnimada);
Flifo := 0;
end;

procedure TAmpuleta.SetTipoAmpuleta( Value: TTipoAmpuleta);
begin
FTipoAmpuleta := Value;
case Value of
     taAnimada: FAmpAni := TAmpuletaAnimada.Create(Self);
     taNormal: FAmpAni.Free;
     end;
end;

procedure TAmpuleta.SetaCursorAux( const lStatus: Boolean);
begin
case FTipoAmpuleta of
     taAnimada: FAmpAni.Enabled := lStatus;
     taNormal: if lStatus then screen.cursor := crHourGlass
               else screen.cursor := crDefault;
     end;
end;

procedure TAmpuleta.SetaCursor( const lStatus: Boolean);
begin
SetaCursorAux( lStatus);
Flifo := (Flifo shl 1) + LongInt(lStatus);
end;

procedure TAmpuleta.RestauraCursor;
begin
Flifo := Flifo shr 1;
SetaCursorAux( (Flifo And 1)=1);
end;

procedure TAmpuleta.LimpaPilha;
begin
Flifo := 0;
end;

end.
