unit Alarm;

interface

uses
  SysUtils, WinTypes, WinProcs, Messages, Classes, Graphics, Controls,
  Forms, Dialogs;

type
  TAlarm = class(TComponent)
  private
    { Private declarations }
    FHour,FMin,FSec : word;
    FAlarmEnabled: Boolean;
    FReserved: Byte;
    FWindowHandle: HWND;
    FOnAlarm: TNotifyEvent;
    procedure UpdateTimer;
    procedure SetEnabled(Value: Boolean);
    procedure SetSecond(Value: word);
    procedure SetOnAlarm(Value: TNotifyEvent);
    procedure WndProc(var Msg: TMessage);
  protected
    { Protected declarations }
    procedure RunAlarm; dynamic;
  public
    { Public declarations }
    constructor Create(AOwner: TComponent); override;
    destructor Destroy; override;
  published
    { Published declarations }
    property AlarmEnabled: Boolean read FAlarmEnabled write SetEnabled default False;
    property Hour : word read FHour write FHour;
    property Minute : word read FMin write FMin;
    property Second : word read FSec write SetSecond;
    property OnAlarm: tNotifyEvent read FOnAlarm write SetOnAlarm;
  end;

procedure Register;

implementation

{ TAlarm }

constructor TAlarm.Create(AOwner: TComponent);
begin
  inherited Create(AOwner);
  FAlarmEnabled := False;
  FWindowHandle := AllocateHWnd(WndProc);
end;

destructor TAlarm.Destroy;
begin
  FAlarmEnabled := False;
  UpdateTimer;
  DeallocateHWnd(FWindowHandle);
  inherited Destroy;
end;

procedure TAlarm.WndProc(var Msg: TMessage);
begin
  with Msg do
    if Msg = WM_TIMER then begin
      if FSec > 0 then FSec := FSec-1
      else begin
        FSec := 59;
        if FMin > 0 then FMin := FMin-1
        else begin
          FMin := 59;
          if FHour > 0 then FHour := FHour-1;
        end;
      end;
      if (FHour = 0) and (FMin = 0) and (FSec = 0) then
        try
          RunAlarm;
        except
          Application.HandleException(Self);
        end;
    end
    else
      Result := DefWindowProc(FWindowHandle, Msg, wParam, lParam);
end;

procedure TAlarm.UpdateTimer;
begin
  KillTimer(FWindowHandle, 1);
  if FAlarmEnabled and Assigned(FOnAlarm) then
    if SetTimer(FWindowHandle, 1, 1000, nil) = 0 then begin
      {raise EOutOfResources.Create(LoadStr(SNoTimers));}
    end;
end;

procedure TAlarm.SetEnabled(Value: Boolean);
begin
  FAlarmEnabled := Value;
  UpdateTimer;
end;

procedure TAlarm.SetSecond(Value: word);
begin
  FSec := Value;
  FAlarmEnabled := True;
  UpdateTimer;
end;

procedure TAlarm.SetOnAlarm(Value: TNotifyEvent);
begin
  FOnAlarm := Value;
end;

procedure TAlarm.RunAlarm;
begin
  KillTimer(FWindowHandle, 1);
  if Assigned(FOnAlarm) then FOnAlarm(Self);
end;

procedure Register;
begin
  RegisterComponents('Philips', [TAlarm]);
end;

end.
