{
  TAFQuickMail   v1.02
  Copyright (C) 2002  Accalai Ferruccio - AfSoftware

  mailto:faccalai@tiscalinet.it - info@afsoftware.it

  webpage:www.afsoftware.it;

  Last Changed 23 september 2002:

                 removed property ToName.
                 
                 Added property ToCCEmail, TOBCCEmail.

                 Property Filename, ToEmail modified  to
                 TStrings for multiFile attachments and multiAddresses sending.

                 
     
  Free for non-commercial use.
  For commercial use an acknowledgment 
  in your product documentation would be 
  appreciated but is not required.
                           
}
unit AFQuickMail;

interface

uses Windows, Messages, SysUtils, Classes,Mapi, Forms, Dialogs, Controls,
  CommDlg;

type
  TAFQuickMail = class(TComponent)
  private
          { Private declarations }
    FTextToSend: TStrings;
    fToEmail: TStrings;
    fToCCEmail: TStrings;
    fToBCCEmail: TStrings;
    fSubject: String;
    fErrorMessage: String;
    fFileName: TStrings;
    Procedure SetToEmail(value: TStrings);
    Procedure SetToCCEmail(value: TStrings);
    Procedure SetToBCCEmail(value: TStrings);
    Procedure SetFileNAme(value: TStrings);
    procedure SetErrorMessage(value: String);
    procedure SetTextToSend(Value: TStrings);
  protected
    function SendMail(const Subject, Body,SenderName, SenderEMail: string;
      BCCEmail,CCEmail, RecipientEMail,Filenamelist: TStrings): Integer;
         { Protected declarations }
  public
          { Public declarations }
    constructor Create(AOwner: TComponent); override;
    destructor Destroy; override;
    function Execute: Boolean; published
    procedure ResetAll;
          { Published declarations }
    property TextToSend: TStrings read fTextToSend write SetTextToSend;
    property ToEmail: TStrings read fToEmail write SetToEmail;
    property Subject: String read fSubject write fSubject;
    property ToCCEmail: tStrings read fToCCEmail write SetToCCEmail;
    property ToBCCEmail: tStrings read fToBCCEmail write SetToBCCEmail;
    property ErrorMessage: String read fErrorMessage write setErrorMessage;
    property FileNames: tstrings read fFileName write setFileName;
  end;

procedure Register;

implementation

procedure Register;
begin
  RegisterComponents('AF', [TAFQuickMail]);
end;
constructor TAFQuickMail.Create(AOwner: TComponent);
begin
  inherited Create(AOwner);
  fTextToSend := TStringList.Create;
  fFileName := TStringList.Create;
  fToEmail := TSTringList.Create;
  fToCCEmail := TSTringList.Create;
  fToBCCEmail := TSTringList.Create;
  errormessage := '';
end;
destructor TAfQuickMail.Destroy;
begin
  fTextToSend.Free;
  ffilename.Free;
  fToEmail.Free;
  fToCCEmail.Free;
  fToBCCEmail.Free;
  inherited Destroy;
end;
function TAFQuickMail.SendMail(const Subject, Body, SenderName, SenderEMail:
  string; BCCEmail,CCEmail, RecipientEMail,FileNamelist:Tstrings): Integer;
TYPE
  TAttachAccessArray = ARRAY [0..0] OF TMapiFileDesc;
  PAttachAccessArray = ^TAttachAccessArray;
var
  MailMessage: TMapiMessage;
  lpSender: TMapiRecipDesc;
  lpRecipient,pRecips: PMapiRecipDesc;
  SM: TFNMapiSendMail;
  MAPIModule: HModule;
  Attachments : PAttachAccessArray;
  iCount,rcount,i : INTEGER;
  FileName : STRING;
begin
  FillChar(mailMessage, SizeOf(mailMessage), 0);
  Mailmessage.NRecipCount := bccEmail.Count+ccemail.Count+RecipientEmail.Count;
  getmem(lprecipient, Mailmessage.nrecipcount*sizeof(TMapiRecipDesc));
  try
    with MailMessage do
    begin
      if (Subject <> '') then lpszSubject := PChar(Subject);
      if (Body <> '') then lpszNoteText := PChar(Body);
      if (SenderEmail <> '') then
      begin
        lpSender.ulRecipClass := MAPI_ORIG;
        if (SenderName = '') then lpSender.lpszName := PChar(SenderEMail)
        else lpSender.lpszName := PChar(SenderName);
        lpSender.lpszAddress := PChar('SMTP:' +SenderEmail);
        lpSender.ulReserved := 0;
        lpSender.ulEIDSize := 0;
        lpSender.lpEntryID := nil;
        lpOriginator := @lpSender;
      end;
      pRecips := lpRecipient;
      if nrecipcount > 0 then
      begin
        for i := 0 to RecipientEmail.Count-1 do
        begin
          pRecips^.ulRecipClass := MAPI_TO;
          pRecips^.lpszName := PChar(RecipientEMail.Strings[i]);
          pRecips^.lpszAddress := StrNew(PChar('SMTP:' + RecipientEmail.Strings[i]));
          pRecips^.ulReserved := 0;
          pRecips^.ulEIDSize := 0;
          pRecips^.lpEntryID := nil;
          Inc(pRecips);
        end;
        for i := 0 to CCEmail.Count-1 do
        begin
          pRecips^.ulRecipClass := MAPI_CC;
          pRecips^.lpszName := PChar(ccEMail.Strings[i]);
          pRecips^.lpszAddress := StrNew(PChar('SMTP:' + ccEmail.Strings[i]));
          pRecips^.ulReserved := 0;
          pRecips^.ulEIDSize := 0;
          pRecips^.lpEntryID := nil;
          Inc(pRecips);
        end ;
        for i := 0 to BCCEmail.Count-1 do
        begin
          pRecips^.ulRecipClass := MAPI_BCC;
          pRecips^.lpszName := PChar(bccEMail.Strings[i]);
          pRecips^.lpszAddress := StrNew(PChar('SMTP:' + bccEmail.Strings[i]));
          pRecips^.ulReserved := 0;
          pRecips^.ulEIDSize := 0;
          pRecips^.lpEntryID := nil;
          Inc(pRecips);
        end ;
      end;
      lpRecips := lpRecipient;
      GetMem(Attachments,SizeOf(TMapiFileDesc) * filenamelist.Count);
      nFileCount := filenamelist.Count;
      if filenamelist.Count > 0 then
      begin
        FOR iCount := 0 TO (filenamelist.Count - 1) do
        begin
          FileName := filenamelist[iCount];
          Attachments[iCount].ulReserved := 0;
          Attachments[iCount].flFlags := 0;
          Attachments[iCount].nPosition := ULONG($FFFFFFFF);
          Attachments[iCount].lpszPathName := StrNew(PChar(FileName));
          Attachments[iCount].lpszFileName := StrNew(PChar(ExtractFileName(FileName)));
          Attachments[iCount].lpFileType := NIL;
        END;
        lpFiles := @Attachments^;
      end
      else
      begin
        nFileCount := 0;
        lpFiles := nil;
      end;
    end;
    MAPIModule := LoadLibrary(PChar(MAPIDLL));
    if MAPIModule = 0 then Result := -1
    else
    try
      @SM := GetProcAddress(MAPIModule, 'MAPISendMail');
      if @SM <> nil then
      begin
        Result := SM(0, Application.Handle, MailMessage,0
          {MAPI_DIALOG or MAPI_LOGON_UI}, 0);
      end
      else Result := 1;
    finally
      FreeLibrary(MAPIModule);
    end;
  finally
    PRecips := lpRecipient;
    for i := 1 to MailMessage.nRecipCount do
    begin
      StrDispose(PRecips^.lpszAddress);
      Inc(PRecips)
    end;
    FreeMem(lpRecipient, MailMessage.nRecipCount * sizeof(TMapiRecipDesc));
  end;
end;
procedure TAFQuickMail.SetErrorMessage(value: String);
const
  BaseError = 'Error sending mail';
begin
  if value = '' then value := BaseError;
  if fErrorMessage <> value then FErrorMessage := value;
end;
Function TAFQuickMail.Execute: Boolean;
var
  OutResult: Integer;
begin
  result := False;
  OutResult := SendMail(FSubject,fTextToSend.Text,'','',fTOBCCEmail,
    fTOCCEmail, fToEmail,FFileName);
  if OutResult <> 0 then
  begin
    result := False;
    MessageDlg(fErrorMessage+' (' + IntToStr(OutResult) + ').', mtError,[mbOK
      ], 0);
  end
  else result := True;
end;
procedure TAFQuickMail.SetTextToSend(Value: TStrings);
begin
  fTextToSend.Assign(value);
end;

procedure TAFQuickMail.SetFileNAme(Value: tStrings);
begin
  if fFileName <> value then FFileName := Value;
end;
procedure TAFQuickMail.SetToEmail(Value: tStrings);
begin
  if fToEmail <> value then FToEmail := Value;
end;
procedure TAFQuickMail.SetToCCEmail(Value: tStrings);
begin
  if fToCCEmail <> value then FToCCEmail := Value;
end;
procedure TAFQuickMail.SetToBCCEmail(Value: tStrings);
begin
  if fToBCCEmail <> value then FToBCCEmail := Value;
end;
procedure TAFQuickMail.ResetAll;
begin
  FToBCCEmail.Clear;
  FToCCEmail.Clear;
  FToEmail.Clear;
  FFilename.Clear;
  fTextToSend.Clear;
  FSubject := '';
end;

end.
