unit fSobre;

interface

uses
  Windows, Messages, SysUtils, Classes, Graphics, Controls, Forms, Dialogs,
  StdCtrls, ExtCtrls, Buttons, ShellAPI;

type
  TF_Sobre = class(TForm)
    Panel1: TPanel;
    Label1: TLabel;
    Label2: TLabel;
    Label3: TLabel;
    GroupBox1: TGroupBox;
    Label6: TLabel;
    Label7: TLabel;
    Label8: TLabel;
    Label9: TLabel;
    Label10: TLabel;
    WinVersion: TLabel;
    DOSVersion: TLabel;
    CPU: TLabel;
    FreeMemory: TLabel;
    FreeDisk: TLabel;
    FreeReSources: TLabel;
    BitBtn1: TBitBtn;
    Label4: TLabel;
    Label5: TLabel;
    procedure EnderNetClick(Sender: TObject);
    procedure EMailClick(Sender: TObject);
    procedure FormShow(Sender: TObject);
  private
    { Private declarations }
  public
    { Public declarations }
  end;

const
  PROCESSOR_INTEL_860 = 860;
  PROCESSOR_INTEL_386 = 386;
  PROCESSOR_INTEL_486 = 486;
  PROCESSOR_INTEL_PENTIUM = 586;
  PROCESSOR_MIPS_R2000 = 2000;
  PROCESSOR_MIPS_R3000 = 3000;
  PROCESSOR_MIPS_R4000 = 4000;
  PROCESSOR_ALPHA_21064 = 21064;
  PROCESSOR_PPC_601 = 601;
  PROCESSOR_PPC_603 = 603;
  PROCESSOR_PPC_604 = 604;
  PROCESSOR_PPC_620 = 620;

var
  F_Sobre: TF_Sobre;

implementation

{$R *.DFM}

procedure TF_Sobre.EnderNetClick(Sender: TObject);
const
  pEnderNet = 'http://www.geocities.com/mpgo_2000';
begin
  {$ifdef win32}
  ShellExecute(Handle, 'open', pEnderNET, nil, nil, SW_SHOW);
  {$endif}

end;

procedure TF_Sobre.EMailClick(Sender: TObject);
const
    pEMail = 'mailto:marcos_paulo@bigfoot.com';
begin
  {$ifdef win32}
  ShellExecute(Handle, 'open', pEMail, nil, nil, SW_SHOW);
  {$endif}
end;
procedure TF_Sobre.FormShow(Sender: TObject);
var
    OsInfo: TOSVERSIONINFO;
    SysInfo: TSYSTEMINFO;
    MemStat: TMEMORYSTATUS;
    DiskNo: Integer;
begin
    OsInfo.dwOSVersionInfoSize := sizeof(TOSVERSIONINFO);
    GetVersionEx(OsInfo);
    // Verso do Windows
    case OsInfo.dwPlatformId of
        VER_PLATFORM_WIN32s : WinVersion.Caption := 'Windows 3.1';
        VER_PLATFORM_WIN32_WINDOWS : WinVersion.Caption := 'Windows 95';
        VER_PLATFORM_WIN32_NT : WinVersion.Caption := 'Windows NT';
    end;
    // Verso do DOS
     DosVersion.Caption := format('%d.%d   Ver : %d',
                 [OsInfo.dwMajorVersion,OsInfo.dwMinorVersion,LOWORD(OsInfo.dwBuildNumber)]);
    // Pega o processador
    GetSystemInfo(SysInfo);
    case SysInfo.dwProcessorType of
        PROCESSOR_INTEL_860 : CPU.Caption :=  format('%d %s',[SysInfo.dwNumberOfProcessors, 'Intel 8086']);
        PROCESSOR_INTEL_386 : CPU.Caption :=  format('%d %s',[SysInfo.dwNumberOfProcessors, 'Intel 80386']);
        PROCESSOR_INTEL_486 : CPU.Caption :=  format('%d %s',[SysInfo.dwNumberOfProcessors, 'Intel 80486']);
        PROCESSOR_INTEL_PENTIUM : CPU.Caption :=  format('%d %s',[SysInfo.dwNumberOfProcessors, 'Intel Pentium']);
        PROCESSOR_MIPS_R2000 : CPU.Caption := format('%d %s',[SysInfo.dwNumberOfProcessors, 'MIPS R2000']);
        PROCESSOR_MIPS_R3000 : CPU.Caption := format('%d %s',[SysInfo.dwNumberOfProcessors, 'MIPS R3000']);
        PROCESSOR_MIPS_R4000 : CPU.Caption := format('%d %s',[SysInfo.dwNumberOfProcessors, 'MIPS R4000']);
        PROCESSOR_ALPHA_21064 : CPU.Caption := format('%d %s',[SysInfo.dwNumberOfProcessors, 'ALPHA 21064']);
        PROCESSOR_PPC_601 : CPU.Caption := format('%d %s',[SysInfo.dwNumberOfProcessors, 'Power PC 601']);
        PROCESSOR_PPC_603 : CPU.Caption := format('%d %s',[SysInfo.dwNumberOfProcessors, 'Power PC 603']);
        PROCESSOR_PPC_604 : CPU.Caption := format('%d %s',[SysInfo.dwNumberOfProcessors, 'Power PC 604']);
        PROCESSOR_PPC_620 : CPU.Caption := format('%d %s',[SysInfo.dwNumberOfProcessors, 'Power PC 620']);
    end;
    MemStat.dwLength := sizeof(TMEMORYSTATUS);
    GlobalMemoryStatus(MemStat);
    // Memria Livre
    FreeMemory.Caption := format('Tot: %d KB     Disp: %d KB',
              [Trunc(MemStat.dwAvailPhys/1024),Trunc(MemStat.dwTotalPhys/1024)]);
//    ShowMessage(d)
    // Recursos livres
    DiskNo := 3;
    FreeDisk.Caption := '';
    FreeResources.Caption := '';
    repeat
       if DiskNo < 7 then
             FreeDisk.Caption := FreeDisk.Caption + format('%s: %d MB  ',
                     [Chr(DiskNo + Ord('A')- 1),Trunc(DiskFree(DiskNo)/1024/1024)])
       else
             FreeResources.Caption := FreeResources.Caption + format('%s: %d MB  ',
                     [Chr(DiskNo + Ord('A')- 1),Trunc(DiskFree(DiskNo)/1024/1024)]);
       inc(DiskNo);
    until DiskFree(DiskNo)=-1;
end;


end.
