unit AboutUser;

{*******************************************************}
{                                                       }
{       Delphi Visual Component Library                 }
{                                                       }
{       Copyright  1996-97 Vitaly Zayko                }
{                                                       }
{                  TAboutUser                           }
{                                                       }
{*******************************************************}

interface

uses
  Windows, SysUtils, Classes, Registry;

type
  TAboutUser = class(TComponent)
  private
    SysReg:TRegIniFile;
    UN:String;
    CN:String;
    HN:String;
    DN:String;
    function FUserName:String;
    function FHostName:String;
    function FDomainName:String;
    function FCompanyName:String;
  published
    property UserName:String read FUserName write UN;
    property Company:String read FCompanyName write CN;
    property Host:String read FHostName write HN;
    property Domain:String read FDomainName write DN;
  end;

procedure Register;

implementation

procedure Register;
begin
  RegisterComponents('System', [TAboutUser]);
end;

function TAboutUser.FUserName:String;
begin
     try
         SysReg:=TRegIniFile.Create('user.dat');
         SysReg.RootKey:=HKEY_CURRENT_USER;
         Result:=SysReg.ReadString('\Software\Microsoft\MS Setup (ACME)\User Info',
         'DefName','Unknown');
     finally
            SysReg.Free;
     end;
end;

function TAboutUser.FHostName:String;
begin
     try
         SysReg:=TRegIniFile.Create('user.dat');
         SysReg.RootKey:=HKEY_LOCAL_MACHINE;
         Result:=SysReg.ReadString('\System\CurrentControlSet\Services\VxD\MSTCP',
         'HostName','Unknown');
     finally
            SysReg.Free;
     end;
end;

function TAboutUser.FDomainName:String;
begin
     try
         SysReg:=TRegIniFile.Create('user.dat');
         SysReg.RootKey:=HKEY_LOCAL_MACHINE;
         Result:=SysReg.ReadString('\System\CurrentControlSet\Services\VxD\MSTCP',
         'Domain','Unknown');
     finally
            SysReg.Free;
     end;
end;

function TAboutUser.FCompanyName:String;
begin
     try
         SysReg:=TRegIniFile.Create('user.dat');
         SysReg.RootKey:=HKEY_CURRENT_USER;
         Result:=SysReg.ReadString('\Software\Microsoft\MS Setup (ACME)\User Info',
         'DefCompany','Unknown');
     finally
            SysReg.Free;
     end;
end;

end.
