{ Marco Cantu' (author of Master Delphi x and Delphi Developers Handbook has   }
{ released an excellent run-time object inspector tool as freeware.  It can be }
{ found in the Delphi Developers Handbook (highly recommended) and on his web  }
{ site at http://www.marcocantu.com.  If you have this installed, you can      }
{ enable the following define (remove the period) to use it in the demo.       }
{ It is for Delphi 3 only, but I think he has a beta for Delphi 2.             }
{.$DEFINE DFS_RUN_TIME_DEBUGGER}
unit Demomain;

interface

uses
  SysUtils, WinTypes, WinProcs, Messages, Classes, Graphics, Controls,
  {$IFDEF DFS_RUN_TIME_DEBUGGER}
  DdhObjDb,
  {$ENDIF}
  Forms, Dialogs, ElpsPanl, ExtCtrls, StdCtrls;

type
  TForm1 = class(TForm)
    EllipsisPanel1: TEllipsisPanel;
    Button1: TButton;
    Edit1: TEdit;
    CheckBox1: TCheckBox;
    Button2: TButton;
    FontDialog1: TFontDialog;
    SaveDialog1: TSaveDialog;
    procedure Button1Click(Sender: TObject);
    procedure FormCreate(Sender: TObject);
    procedure CheckBox1Click(Sender: TObject);
    procedure Button2Click(Sender: TObject);
  private
    { Private declarations }
  public
    { Public declarations }
  end;

var
  Form1: TForm1;

implementation

{$R *.DFM}

procedure TForm1.Button1Click(Sender: TObject);
begin
  EllipsisPanel1.Caption := Edit1.Text;
end;

procedure TForm1.FormCreate(Sender: TObject);
begin
  {$IFDEF DFS_RUN_TIME_DEBUGGER}
  TDdhObjectDebugger.Create(Self);
  {$ENDIF}
  Edit1.Text := EllipsisPanel1.Caption;
  Checkbox1.Checked := EllipsisPanel1.IsPath;
end;

procedure TForm1.CheckBox1Click(Sender: TObject);
begin
  EllipsisPanel1.IsPath := CheckBox1.Checked;
end;

procedure TForm1.Button2Click(Sender: TObject);
begin
  FontDialog1.Font.Assign(EllipsisPanel1.Font);
  if FontDialog1.Execute then
    EllipsisPanel1.Font.Assign(FontDialog1.Font);
end;

end.

