// Demo for TMinMax control
//
// Shows how the minimum drag width of a form can be controlled.  This
// demo shows enable/disable for this behaviour and has an edit box to enable
// the miniumum width to be adjusted on the fly.  Perhaps rather a false
// demo, in that, the main use is to prevent resizing above or below a
// form size known at design time.  In this case, the values are put in
// the Object Inspector and no coding of any description is needed.
//
// Try putting a value in which exceeds your screen width, eg 1300 on a 1024
// width display.  Not too sure what use this has!
//
// Version 1.00 Grahame Marsh 1997

unit MMDemo1;

interface

uses
  Windows, Messages, SysUtils, Classes, Graphics, Controls, Forms, Dialogs,
  ExtCtrls, Minmax, StdCtrls;

type
  TForm1 = class(TForm)
    MinMax1: TMinMax;
    Panel1: TPanel;
    MinDragXCheckBox: TCheckBox;
    MinDragXEdit: TEdit;
    Memo1: TMemo;
    procedure MinDragXCheckBoxClick(Sender: TObject);
    procedure MinDragXEditChange(Sender: TObject);
  private
  public
  end;

var
  Form1: TForm1;

implementation

{$R *.DFM}

// on/off check box is clicked
procedure TForm1.MinDragXCheckBoxClick(Sender: TObject);
begin
  if MinDragXCheckBox.Checked then
  begin
// turn the MinTrackWidth control  on
    MinMax1.Changes := MinMax1.Changes + [mmMinTrackWidth];
// get the current edit box value
    MinMax1.MinTrackWidth := StrToInt(MinDragXEdit.Text);
  end else
// remove control
    MinMax1.Changes := MinMax1.Changes - [mmMinTrackWidth];

// if current width is too small then widen the form
  if Width < MinMax1.MinTrackWidth then
    Width := MinMax1.MinTrackWidth
end;

// number in the edit box is changed
procedure TForm1.MinDragXEditChange(Sender: TObject);
begin
  if MinDragXCheckBox.Checked then
  begin
    MinMax1.MinTrackWidth := StrToInt (MinDragXEdit.Text);
    if Width < MinMax1.MinTrackWidth then
      Width := MinMax1.MinTrackWidth
  end
end;

end.
