unit LedReg;

Interface
uses
  Classes,
  LedBtn,
  {$IFDEF VER130}
  DsgnIntf,
  {$ELSE}
  DesignIntf,
  DesignEditors,
  {$ENDIF}
  Forms,
  Dialogs;

type

  TSoundFileProperty = class(TStringProperty)
  public
    procedure Edit; override;
    function GetAttributes: TPropertyAttributes; override;
  end;

procedure Register;


implementation

procedure Register;
begin
  RegisterComponents('Additional', [TLedButton]);
  RegisterPropertyEditor(TypeInfo(String), TLedButton, 'SoundFile', TSoundFileProperty);
end;

procedure TSoundFileProperty.Edit;
var
  MPFileOpen: TOpenDialog;
begin
  MPFileOpen := TOpenDialog.Create(Application);
  MPFileOpen.Filename := GetValue;
  MPFileOpen.Filter := 'Sound File (*.wav)|*.wav';
  MPFileOpen.Options := MPFileOpen.Options + [ofPathMustExist,
    ofFileMustExist];
  try
    if MPFileOpen.Execute then SetValue(MPFileOpen.Filename);
  finally
    MPFileOpen.Free;
  end;
end;

function TSoundFileProperty.GetAttributes: TPropertyAttributes;
begin
  Result := [paDialog];
end;

end.