{
--------------------------------------------------------------------------------

Component Name: TStepper
Author: Mats Asplund
Creation: 2000-04-23
Version: 1.0
Description: A step control component.
Credit:
E-mail: mats.asplund@telia.com
Site: http://w1.545.telia.com/~u54503556/delphi/mdp.htm
Legal issues: Copyright (C) 2000 by Mats Asplund
              This software is provided 'as-is', without any express or
              implied warranty.  In no event will the author be held liable
              for any  damages arising from the use of this software.

              Permission is granted to anyone to use this software for any
              purpose, including commercial applications, and to alter it
              and redistribute it freely, subject to the following
              restrictions:

              1. The origin of this software must not be misrepresented,
                 you must not claim that you wrote the original software.
                 If you use this software in a product, an acknowledgment
                 in the product documentation would be appreciated but is
                 not required.

              2. Altered source versions must be plainly marked as such, and
                 must not be misrepresented as being the original software.

              3. This notice may not be removed or altered from any source
                 distribution.

              4. If you decide to use this software in any of your applications.
                 Send me an EMail address and tell me about it.

Quick Reference:
              TStepper is a descendant from TCompoundPanel.

              Properties:
              Min:            The minimum-value for Stepper. Reaching this value
                              disenables BitBtn1.
              Max:            The maximum-value for Stepper. Reaching this value
                              disenables BitBtn2.
              ValueOut:       Read this value to determine the Stepper-value.
              StepBy:         Sets the increase-, decrement-amount of the Stepper.
              CaptionBitBtn1: The caption for BitBtn1.
              CaptionBitBtn2: The caption for BitBtn1.

              Events:
              OnValueChanged: Event raised when Valueout is changed.

--------------------------------------------------------------------------------
}
unit stepper;

interface

uses
  SysUtils, WinTypes, WinProcs, Messages, Classes, Graphics, Controls,
  Forms, Dialogs, Compound, StdCtrls, Buttons;

type
  TStepForm = class(TForm)
    BitBtn1: TBitBtn;
    BitBtn2: TBitBtn;
end;

  TStepper = class(TCompoundPanel)
private
  FForm: TStepForm;
  FMin: integer;
  FMax: integer;
  FValueOut: integer;
  FStepBy: integer;
  FCop: string;
  VChanged: TButton;
  procedure SetMin(Value: integer);
  procedure SetMax(Value: integer);
  procedure SetValueOut(Value: integer);
  procedure SetStepBy(Value: integer);
  procedure SetCapB1(Value: string);
  function GetCapB1: string;
  procedure SetCapB2(Value: string);
  function GetCapB2: string;
  procedure SetCop(Value: string);
  procedure SetOnValueChanged(Value: TNotifyEvent);
  procedure DecValueOut(Sender: TObject);
  procedure IncValueOut(Sender: TObject);
  function GetOnValueChanged: TNotifyEvent;
  {private declarations }
public
  constructor Create(AOwner: TComponent); override;
  destructor Destroy; override;
  property Form: TStepForm read FForm;
  { Private declarations }
published
  property Min: integer read FMin write SetMin;
  property Max: integer read FMax write SetMax;
  property ValueOut: integer read FValueOut write SetValueOut;
  property StepBy: integer read FStepBy write SetStepBy;
  property CaptionBitBtn1: string read GetCapB1 write SetCapB1;
  property CaptionBitBtn2: string read GetCapB2 write SetCapB2;
  property OnValueChanged: TNotifyEvent read GetOnValueChanged write SetOnValueChanged;
  property Copyright: string read FCop write SetCop;
  { Published declarations }
end;

var
  StepForm: TStepForm;

procedure Register;

implementation
{$R *.DFM}

procedure Register;
begin
  RegisterComponents('MAs Prod.', [TStepper]);
end;

constructor TStepper.Create(AOwner: TComponent);
begin
  inherited Create(AOwner);
  FForm:= MoveControls(TStepForm.Create(nil));
  VChanged:=TButton.Create(Self);
  Form.BitBtn1.OnClick:=DecValueOut;
  Form.BitBtn2.OnClick:=IncValueOut;
  FMin:=0;
  FMax:=100;
  FStepBy:=1;
end;

procedure TStepper.DecValueOut(Sender: TObject);
begin
  FValueOut:=FValueOut-FStepBy;
  SetValueOut(FValueOut);
end;

destructor TStepper.Destroy;
begin
  VChanged.Free;
  inherited Destroy;
end;

function TStepper.GetCapB1: string;
begin
  Result:=Form.BitBtn1.Caption;
end;

function TStepper.GetCapB2: string;
begin
  Result:=Form.BitBtn2.Caption;
end;

function TStepper.GetOnValueChanged: TNotifyEvent;
begin
  Result:=VChanged.OnClick;
end;

procedure TStepper.IncValueOut(Sender: TObject);
begin
  FValueOut:=FValueOut+FStepBy;
  SetValueOut(FValueOut);
end;

procedure TStepper.SetCapB1(Value: string);
begin
  Form.BitBtn1.Caption:=Value;
end;

procedure TStepper.SetCapB2(Value: string);
begin
  Form.BitBtn2.Caption:=Value;
end;

procedure TStepper.SetCop(Value: string);
begin
  FCop:=FCop;
end;

procedure TStepper.SetMax(Value: integer);
begin
  FMax:=Value;
  SetValueOut(FValueOut);
end;

procedure TStepper.SetMin(Value: integer);
begin
  FMin:=Value;
  SetValueOut(FValueOut);
end;

procedure TStepper.SetOnValueChanged(Value: TNotifyEvent);
begin
  VChanged.OnClick:=Value;
end;

procedure TStepper.SetStepBy(Value: integer);
begin
  FStepBy:=Value;
end;

procedure TStepper.SetValueOut(Value: integer);
begin
  FValueOut:=Value;
  Form.BitBtn1.Enabled:=true;
  Form.BitBtn2.Enabled:=true;
  if FValueOut >= FMax then
  begin
    FValueOut:=FMax;
    Form.BitBtn2.Enabled:=false;
  end;
  if FValueOut <= FMin then
  begin
    FValueOut:=FMin;
    Form.BitBtn1.Enabled:=false;
  end;
    VChanged.Click;
end;

end.
