{
--------------------------------------------------------------------------------

Component Name: TPassOverBtn
Author: Mats Asplund
Creation: May 30, 2000
Version: 1.0
Description:  TPassOverBtn is a button that changes fontcolor and glyph when
              the mouse-pointer passes over it.
Credit:
EMail:        mats.asplund@telia.com
Site:         http://w1.545.telia.com/~u54503556/delphi/mdp.htm
Legal issues: Copyright (C) 2000 by Mats Asplund
              This software is provided 'as-is', without any express or
              implied warranty.  In no event will the author be held liable
              for any  damages arising from the use of this software.

              Permission is granted to anyone to use this software for any
              purpose, including commercial applications, and to alter it
              and redistribute it freely, subject to the following
              restrictions:

              1. The origin of this software must not be misrepresented,
                 you must not claim that you wrote the original software.
                 If you use this software in a product, an acknowledgment
                 in the product documentation would be appreciated but is
                 not required.

              2. Altered source versions must be plainly marked as such, and
                 must not be misrepresented as being the original software.

              3. This notice may not be removed or altered from any source
                 distribution.

              4. If you decide to use this software in any of your applications.
                 Send me an EMail and tell me about it.

Quick Reference:
              TPassOverBtn is a descendant from TBitBtn.

              Published properties:
                FontColorIn:  Fontcolor when mouse is over the control.
                FontColorOut: Fontcolor when mouse is out of the control.
                GlyphIn:      Glyph when mouse is over the control.
                GlyphOut:     Glyph when mouse is out of the control.

              All others properties, methods and events are inherited.
--------------------------------------------------------------------------------
}
unit passoverbtn;

interface

uses
  Windows, Messages, SysUtils, Classes, Graphics, Controls, Forms, Dialogs,
  StdCtrls, Buttons;

type
  TPassOverBtn = class(TBitBtn)
  private
    FMouseInPos : Boolean;
    FFColorIn: TColor;
    FFColorOut: TColor;
    FGlyphIn: TBitmap;
    FGlyphOut: TBitmap;
    FCop: string;
    procedure CMMouseEnter(var AMsg: TMessage);
      message CM_MOUSEENTER;
    procedure CMMouseLeave(var AMsg: TMessage);
      message CM_MOUSELEAVE;
    procedure Paint;
    procedure SetFontColorIn(Value: TColor);
    procedure SetFontColorOut(Value: TColor);
    function GetCop: string;
    procedure SetCop(const Value: string);
    procedure SetGlyph(Index: integer; Value : TBitmap);
  public
    constructor Create(AOwner: TComponent); override;
    destructor Destroy; override;
  published
    property FontColorIn: TColor read FFColorIn write SetFontColorIn;
    property FontColorOut: TColor read FFColorOut write SetFontColorOut;
    property GlyphIn   : TBitmap index 1 read FGlyphIn write SetGlyph;
    property GlyphOut : TBitmap index 2 read FGlyphOut write SetGlyph;
    property Copyright: string read GetCop write SetCop;
  end;

procedure Register;

implementation

procedure Register;
begin
  RegisterComponents('MAs Prod.', [TPassOverBtn]);
end;

procedure TPassOverBtn.CMMouseEnter(var AMsg: TMessage);
begin
  FMouseInPos := True;
  Paint;
end;

procedure TPassOverBtn.CMMouseLeave(var AMsg: TMessage);
begin
  FMouseInPos := False;
  Paint;
end;

constructor TPassOverBtn.Create(AOwner: TComponent);
begin
  inherited Create(AOwner);;
  FFColorIn:=clRed;
  FFColorOut:=clBlack;
  FGlyphIn:=TBitmap.Create;
  FGlyphOut:=TBitmap.Create;
  FCop:='(C) 2000, Mats Asplund / MAs Prod.';
end;

destructor TPassOverBtn.Destroy;
begin
  FGlyphIn.Free;
  FGlyphOut.Free;
  inherited Destroy;
end;

function TPassOverBtn.GetCop: string;
begin
  Result:=FCop;
end;

procedure TPassOverBtn.Paint;
begin
  if FMouseInPos then
  begin
    Font.Color := FFColorIn;
    Glyph:=FGlyphIn;
  end
  else
  begin
    Font.Color := FFColorOut;
    Glyph:=FGlyphOut;
  end;
end;

procedure TPassOverBtn.SetCop(const Value: string);
begin
  FCop:=FCop;
end;

procedure TPassOverBtn.SetFontColorIn(Value: TColor);
begin
  FFColorIn:=Value;
end;

procedure TPassOverBtn.SetFontColorOut(Value: TColor);
begin
  FFColorOut:=Value;
end;

procedure TPassOverBtn.SetGlyph(Index: integer; Value: TBitmap);
begin
  case Index of
    1: FGlyphIn.Assign(Value);
    2: FGlyphOut.Assign(Value);
  end;
  Invalidate;
end;

end.
