{
--------------------------------------------------------------------------------

Component Name: TPCar
Author: Mats Asplund
Creation: March 15, 2000
Version: 1.0
Description:  TPCar is a kind of funny progressbar.
Credit:
EMail:        mats.asplund@telia.com
Site:         http://w1.545.telia.com/~u54503556/delphi/mdp.htm
Legal issues: Copyright (C) 1999 by Mats Asplund
              This software is provided 'as-is', without any express or
              implied warranty.  In no event will the author be held liable
              for any  damages arising from the use of this software.

              Permission is granted to anyone to use this software for any
              purpose, including commercial applications, and to alter it
              and redistribute it freely, subject to the following
              restrictions:

              1. The origin of this software must not be misrepresented,
                 you must not claim that you wrote the original software.
                 If you use this software in a product, an acknowledgment
                 in the product documentation would be appreciated but is
                 not required.

              2. Altered source versions must be plainly marked as such, and
                 must not be misrepresented as being the original software.

              3. This notice may not be removed or altered from any source
                 distribution.

              4. If you decide to use this software in any of your applications.
                 Send me an EMail address and tell me about it.

Quick Reference:
              TPCar is a descendant from TCompoundPanel.

              Published properties:
              ProgressPercent: Sets the amount (0-100) of progress for Image1(BitMap1);
              Bitmap1:         Sets BitMap1.
              Bitmap2:         Sets Bitmap2.

--------------------------------------------------------------------------------
}
unit PCar;

interface

uses
  SysUtils, WinTypes, WinProcs, Messages, Classes, Graphics, Controls,
  Forms, Dialogs, Compound, StdCtrls, ExtCtrls;

type
  TPCForm = class(TForm)
    Panel1: TPanel;
    Image1: TImage;
    Image2: TImage;
    Shape1: TShape;
end;

  TPCar = class(TCompoundPanel)
private
  FForm: TPCForm;
  FPP: integer;
  FScale: integer;
  FCopyright: string;
  procedure SetBitmap1(Value: TBitmap);
  procedure SetBitmap2(Value: TBitmap);
  function GetBitmap1: TBitmap;
  function GetBitmap2: TBitmap;
  procedure SetPP(Value: integer);
  procedure SetCopyright(Value: string);
//  procedure Changed(Sender: TObject);
public
  constructor Create(AOwner: TComponent); override;
  destructor Destroy; override;
  property Form: TPCForm read FForm;
published
  property ProgressPercent: integer read FPP write SetPP;
  property Bitmap1: TBitmap read GetBitmap1 write SetBitmap1;
  property Bitmap2: TBitmap read GetBitmap2 write SetBitmap2;
  property Copyright: string read FCopyright write SetCopyright;
end;

var
  PCForm: TPCForm;

procedure Register;

implementation
{$R *.DFM}

procedure Register;
begin
  RegisterComponents('MAs Prod.', [TPCar]);
end;

constructor TPCar.Create(AOwner: TComponent);
begin
  inherited Create(AOwner);
  FForm:= MoveControls(TPCForm.Create(nil));
  FCopyright:='2000 (C) Mats Asplund, MAs Prod.';
  FScale:=242;
//  Form.Panel1.OnResize:=Changed;
end;

destructor TPCar.Destroy;
begin
  inherited Destroy;
end;

function TPCar.GetBitmap1: TBitmap;
begin
  Result:=Form.Image1.Picture.Bitmap;
end;

function TPCar.GetBitmap2: TBitmap;
begin
  Result:=Form.Image2.Picture.Bitmap;
end;

procedure TPCar.SetBitmap1(Value: TBitmap);
begin
  Form.Image1.Picture.Bitmap:= Value;
end;

procedure TPCar.SetBitmap2(Value: TBitmap);
begin
  Form.Image1.Picture.Bitmap:= Value;
end;

procedure TPCar.SetCopyright(Value: string);
begin
  FCopyright:=FCopyright;
end;

procedure TPCar.SetPP(Value: integer);
begin
  if Value > 100 then Value:=100;
  FPP:= Value;
  Form.Image1.Left:=8+(FPP*FScale div 100);
  Invalidate;
end;

{
procedure TPCar.Changed(Sender: TObject);
begin
  if Form.Panel1.Width < 100 then
  begin
    Form.Image2.Left:=108;
    Form.Shape1.Width:=135;
  end;
  FScale:=Form.Panel1.Width;
  SetPP(FPP);
end;
}

end.
