{
--------------------------------------------------------------------------------

Component Name: TMGauge
Author: Mats Asplund
Creation: 2000-04-10
Version: 1.0
Description: A nice-looking progressbar.
Credit:
E-mail: mats.asplund@telia.com
Site: http://w1.545.telia.com/~u54503556/delphi/mdp.htm
Legal issues: Copyright (C) 2000 by Mats Asplund
              This software is provided 'as-is', without any express or
              implied warranty.  In no event will the author be held liable
              for any  damages arising from the use of this software.

              Permission is granted to anyone to use this software for any
              purpose, including commercial applications, and to alter it
              and redistribute it freely, subject to the following
              restrictions:

              1. The origin of this software must not be misrepresented,
                 you must not claim that you wrote the original software.
                 If you use this software in a product, an acknowledgment
                 in the product documentation would be appreciated but is
                 not required.

              2. Altered source versions must be plainly marked as such, and
                 must not be misrepresented as being the original software.

              3. This notice may not be removed or altered from any source
                 distribution.

              4. If you decide to use this software in any of your applications.
                 Send me an EMail address and tell me about it.

Quick Reference:
              TMGauge is a descendant from TCompoundPanel.

              Properties:
              ProgressPercent: Sets the bar-progress.
              ColourBar: Sets the barcolour.

--------------------------------------------------------------------------------
}
unit MG;

interface

uses
  SysUtils, WinTypes, WinProcs, Messages, Classes, Graphics, Controls,
  Forms, Dialogs, Compound, StdCtrls, ExtCtrls;

type
  TMGForm = class(TForm)
    Image2: TImage;
    Image3: TImage;
    Image4: TImage;
    Image1: TImage;
end;

type TMColour = (mcBlue,mcLime,mcRed,mcYellow);

TMGauge = class(TCompoundPanel)
private
  FForm: TMGForm;
  FPP: integer;
  FCop: string;
  FMColour: TMColour;
  procedure SetPP(Value: integer);
  function  GetPP: integer;
  procedure SetCop(Value: string);
  function  GetMColour: TMColour;
  procedure SetMColour(Value: TMColour);
public
  constructor Create(AOwner: TComponent); override;
  destructor Destroy; override;
  property Form: TMGForm read FForm;
published
  property ProgressPercent: integer read GetPP write SetPP;
  property ColourBar: TMColour read GetMColour write SetMColour;
  property Copyright: string read FCop write SetCop;
end;

var
  MGForm: TMGForm;

procedure Register;

implementation
{$R *.DFM}

procedure Register;
begin
  RegisterComponents('MAs Prod.', [TMGauge]);
end;

constructor TMGauge.Create(AOwner: TComponent);
begin
  inherited Create(AOwner);
  FForm:= MoveControls(TMGForm.Create(nil));
  SetMColour(mcBlue);
  SetPP(100);
  FCop:='Copyright(C) 2000, Mats Asplund/MAs Prod.';
end;

destructor TMGauge.Destroy;
begin
  inherited Destroy;
end;

function TMGauge.GetMColour: TMColour;
begin
  Result:=FMColour;
end;

function TMGauge.GetPP: integer;
begin
  Result:=FPP;
end;

procedure TMGauge.SetCop(Value: string);
begin
  FCop:=FCop;
end;

procedure TMGauge.SetMColour(Value: TMColour);
begin
  Form.Image1.Visible:=false;
  Form.Image2.Visible:=false;
  Form.Image3.Visible:=false;
  Form.Image4.Visible:=false;
  FMColour:=Value;
  case FMColour of
    mcBlue:   begin
                Form.Image1.Visible:=true;
                Form.Image1.BringToFront;
              end;
    mcLime:   begin
                Form.Image2.Visible:=true;
                Form.Image2.BringToFront;
              end;
    mcRed:    begin
                Form.Image3.Visible:=true;
                Form.Image3.BringToFront;
              end;
    mcYellow: begin
                Form.Image4.Visible:=true;
                Form.Image4.BringToFront;
              end;
  end;
  SetPP(100);
end;

procedure TMGauge.SetPP(Value: integer);
begin
  FPP:=Value;
  if FMColour = mcBlue then Form.Image1.Width:=202*FPP div 100;
  if FMColour = mcLime then Form.Image2.Width:=202*FPP div 100;
  if FMColour = mcRed then Form.Image3.Width:=202*FPP div 100;
  if FMColour = mcYellow then Form.Image4.Width:=202*FPP div 100;
end;

end.
