{
--------------------------------------------------------------------------------

Component Name: TMDate
Author: Mats Asplund
Creation: Sep 15, 1999
Version: 1.2
Description:  TMDate is a component for displaying date and time in various ways.
              It updates every 30seconds.
Credit:
EMail:        mats.asplund@telia.com
Site:         http://w1.545.telia.com/~u54503556/delphi/mdp.htm
Legal issues: Copyright (C) 1999 by Mats Asplund
              This software is provided 'as-is', without any express or
              implied warranty.  In no event will the author be held liable
              for any  damages arising from the use of this software.

              Permission is granted to anyone to use this software for any
              purpose, including commercial applications, and to alter it
              and redistribute it freely, subject to the following
              restrictions:

              1. The origin of this software must not be misrepresented,
                 you must not claim that you wrote the original software.
                 If you use this software in a product, an acknowledgment
                 in the product documentation would be appreciated but is
                 not required.

              2. Altered source versions must be plainly marked as such, and
                 must not be misrepresented as being the original software.

              3. This notice may not be removed or altered from any source
                 distribution.

              4. If you decide to use this software in any of your applications.
                 Send me an EMail address and tell me about it.

Quick Reference:
              TDLBox is a descendant from TCustomLabel.

              Published properties:

              Events:

              Methods:

--------------------------------------------------------------------------------
}
unit mdate;

interface

uses Classes, Controls, ExtCtrls, Forms, Graphics, Messages,
     Stdctrls, SysUtils, WinProcs, WinTypes;

type
  TMDate = class(TCustomLabel)
  private
    FDateFmtUSA : Boolean;
    FDateStr : String;
    FShowDate : Boolean;
    FShowTime : Boolean;
    FTimeFmt24hr : Boolean;
    FNumeric1 : Boolean;
    FNumeric2 : Boolean;
    FSwedish : Boolean;
    FTimeSep : String;
    FTimeStr : String;
    FOm: string;
    Timer : TTimer;
    procedure AutoInitialize;
    procedure AutoDestroy;
    procedure SetDateFmtUSA(Value : Boolean);
    function GetDateStr : String;
    procedure SetShowDate(Value : Boolean);
    procedure SetShowTime(Value : Boolean);
    procedure SetTimeFmt24hr(Value : Boolean);
    procedure SetNumeric1(Value : Boolean);
    procedure SetNumeric2(Value : Boolean);
    procedure SetTimeSep(Value : String);
    procedure SetSwedish(Value : Boolean);
    function GetTimeStr : String;
    function NewCaption : String;
    procedure UpdateComp(Sender : TObject);
    procedure SetOm(Value: string);
  protected
    procedure Paint; override;
  public
    property DateStr : String read GetDateStr;
    property TimeStr : String read GetTimeStr;
    constructor Create(AOwner: TComponent); override;
    destructor Destroy; override;
  published
    property DateFmtUSA : Boolean read FDateFmtUSA write SetDateFmtUSA default False;
    property Numeric1 : Boolean read FNumeric1 write SetNumeric1 default False;
    property Numeric2 : Boolean read FNumeric2 write SetNumeric2 default False;
    property Swedish : Boolean read FSwedish write SetSwedish default False;
    property Font;
    property ShowDate : Boolean read FShowDate write SetShowDate default True;
    property ShowTime : Boolean read FShowTime write SetShowTime default True;
    property TimeFmt24hr : Boolean read FTimeFmt24hr write SetTimeFmt24hr default True;
    property TimeSep : String read FTimeSep write SetTimeSep;
    property Visible default True;
    property Copyright: string read FOm write SetOm;
  end;

procedure Register;

implementation

procedure Register;
begin
  RegisterComponents('MAs Prod.', [TMDate]);
end;

procedure TMDate.AutoInitialize;
begin
  Timer := TTimer.Create(Self);
  with Timer do
  begin
    Interval := 30000;
    OnTimer := UpdateComp;
  end;
  FDateFmtUSA := False;
  FShowDate := True;
  FShowTime := True;
  FTimeFmt24hr := True;
  FTimeSep := ':';
  Visible := True;
  FOm:='1999(C) Mats Asplund / MAs Prod.';
end;

procedure TMDate.AutoDestroy;
begin
  Timer.Free;
end;

procedure TMDate.SetDateFmtUSA(Value : Boolean);
begin
  FDateFmtUSA := Value;
  Invalidate;
end;

function TMDate.GetDateStr : String;
const
  Months : array[1..12] of String[10] = ('January','February','March','April',
           'May','June','July','August','September','October','November','December');
  MonthsSwe : array[1..12] of String[10] = ('Januari','Februari','Mars','April',
           'Maj','Juni','Juli','Augusti','September','Oktober','November','December');
var Year, Month, Day : Word;
    DayStr, DayStr2, MonthStr, YearStr : String[10];
begin
  DecodeDate(Now, Year, Month, Day);
  Str(Day, DayStr);
  Str(Month, MonthStr);
  Str(Year, YearStr);
  if StrToInt(MonthStr) < 10 then MonthStr:='0'+MonthStr;
  if StrToInt(DayStr) < 10 then DayStr2:='0'+DayStr
  else DayStr2:=DayStr;

  if FNumeric1 then
  begin
    FDateStr := YearStr + '-' + MonthStr + '-' + DayStr2;
    GetDateStr := FDateStr;
    Exit;
  end;

  if FNumeric2 then
  begin
    FDateStr := Copy(YearStr,3,2) + '-' + MonthStr + '-' + DayStr2;
    GetDateStr := FDateStr;
    Exit;
  end;

  if FSwedish then
  begin
    FDateStr :=  DayStr + ' ' + MonthsSwe[Month] + ', ' + YearStr;
    GetDateStr := FDateStr;
  end
  else
  begin
  if FDateFmtUSA then
    begin
      FDateStr := Months[Month] + ' ' + DayStr + ', ' + YearStr;
      GetDateStr := FDateStr;
      Exit;
    end;
    FDateStr := DayStr + ' ' + Months[Month] + ', ' + YearStr;
    GetDateStr := FDateStr
  end;
end;

procedure TMDate.SetShowDate(Value : Boolean);
begin
  FShowDate := Value;
  Invalidate;
end;

procedure TMDate.SetShowTime(Value : Boolean);
begin
  FShowTime := Value;
  Invalidate;
end;

procedure TMDate.SetTimeFmt24hr(Value : Boolean);
begin
  FTimeFmt24hr := Value;
  Invalidate
end;

procedure TMDate.SetTimeSep(Value : String);
begin
  FTimeSep := Value;
  Invalidate;
end;

function TMDate.GetTimeStr : String;
var Hour, Minute, Seconds, Hundreds : Word;
    HourStr, MinuteStr, AmPm : String[10];
begin
  DecodeTime(Now, Hour, Minute, Seconds, Hundreds);
  if FTimeFmt24hr then
    AmPm := ''
  else
    if Hour > 12 then
    begin
      Hour := Hour - 12;
      AmPm := ' pm'
    end
    else
      AmPm := ' am';
   Str(Hour, HourStr);
   Str(Minute, MinuteStr);
   if Minute < 10 then
     MinuteStr := '0' + MinuteStr;
   FTimeStr := HourStr + FTimeSep + MinuteStr + AmPm;
   GetTimeStr := FTimeStr
end;

constructor TMDate.Create(AOwner: TComponent);
begin
  inherited Create(AOwner);
  AutoInitialize;
  Timer.Enabled := True
end;

destructor TMDate.Destroy;
begin
  AutoDestroy;
  inherited Destroy;
end;

function TMDate.NewCaption : String;
var DisplayLine : String;
begin
  if FShowDate then DisplayLine := GetDateStr
  else DisplayLine := '';
  if FShowDate and FShowTime then DisplayLine := DisplayLine + '  ';
  if FShowTime then DisplayLine := DisplayLine + GetTimeStr;
  NewCaption := DisplayLine;
end;

procedure TMDate.Paint;
begin
  Caption := NewCaption;
  inherited Paint;
end;

procedure TMDate.UpdateComp(Sender : TObject);
begin
  if NewCaption <> Caption then
    Invalidate;
end;


procedure TMDate.SetOm(Value: string);
begin
  FOm:=FOm;
end;

procedure TMDate.SetNumeric1(Value: Boolean);
begin
  SetDateFmtUSA(false);
  FNumeric1:=Value;
  Invalidate;
end;

procedure TMDate.SetNumeric2(Value: Boolean);
begin
  SetDateFmtUSA(false);
  FNumeric2:=Value;
  Invalidate;
end;

procedure TMDate.SetSwedish(Value: Boolean);
begin
  SetDateFmtUSA(false);
  FSwedish:=Value;
  Invalidate;
end;

end.
