{
--------------------------------------------------------------------------------

Component Name: TMBox
Author: Mats Asplund
Creation: Sep 17, 1999
Version: 1.0
Description:  TMBox displays a messagebox.
Credit:
EMail:        mats.asplund@telia.com
Site:         http://w1.545.telia.com/~u54503556/delphi/mdp.htm
Legal issues: Copyright (C) 1999 by Mats Asplund
              This software is provided 'as-is', without any express or
              implied warranty.  In no event will the author be held liable
              for any  damages arising from the use of this software.

              Permission is granted to anyone to use this software for any
              purpose, including commercial applications, and to alter it
              and redistribute it freely, subject to the following
              restrictions:

              1. The origin of this software must not be misrepresented,
                 you must not claim that you wrote the original software.
                 If you use this software in a product, an acknowledgment
                 in the product documentation would be appreciated but is
                 not required.

              2. Altered source versions must be plainly marked as such, and
                 must not be misrepresented as being the original software.

              3. This notice may not be removed or altered from any source
                 distribution.

              4. If you decide to use this software in any of your applications.
                 Send me an EMail address and tell me about it.

Quick Reference:
              TMBox is a descendant from TComponent.

              Published properties:
              BoxType : Sets boxtype of TMsgDlgType.
              Buttons : Sets buttontype of TMsgDlgButtons.
              Caption : Caption-string for box.
              Text : String with message.

              Methods:
              Execute : Runs MBox.
              ButtonPressed: Holds stringvalue of button pressed after latest run.

--------------------------------------------------------------------------------
}
unit mbox;

interface

uses WinTypes, WinProcs, Messages, SysUtils, Classes, Controls,
     Forms, Graphics, Dialogs;

type
  TMBox = class(TComponent)
  private
    FBoxType : TMsgDlgType;
    FButtons : TMsgDlgButtons;
    FCaption : String;
    FText : String;
    FExecuteResult: integer;
    FButtonPressed: string;
    FCopyright: string;
    procedure AutoInitialize;
    procedure AutoDestroy;
    procedure SetCopyright(Value: string);
  protected
  public
    constructor Create(AOwner: TComponent); override;
    destructor Destroy; override;
    function Execute : Integer; virtual;
    function ButtonPressed: string;
  published
    property BoxType : TMsgDlgType read FBoxType write FBoxType default mtInformation;
    property Buttons : TMsgDlgButtons read FButtons write FButtons default [mbOK];
    property Caption : String read FCaption write FCaption;
    property Text : String read FText write FText;
    property Copyright : String read FCopyright write SetCopyright;
  end;

procedure Register;

implementation

procedure Register;
begin
  RegisterComponents('MAs Prod.', [TMBox]);
end;

procedure TMBox.AutoInitialize;
begin
  FBoxType := mtInformation;
  FButtons := [mbOK];
  FButtonPressed:='None';
  FCopyright := '1999(C) Mats Asplund/MAs Prod.';
end;

procedure TMBox.AutoDestroy;
begin
end;

constructor TMBox.Create(AOwner: TComponent);
begin
  inherited Create(AOwner);
  AutoInitialize;
end;

destructor TMBox.Destroy;
begin
  AutoDestroy;
  inherited Destroy;
end;

function TMBox.Execute : Integer;
var
  Dlg : TForm;
begin
  Result := 0;
  try
    Dlg := CreateMessageDialog(FText, FBoxType, FButtons);
    Dlg.Caption := FCaption;
    Dlg.FormStyle := fsStayOnTop;
    Dlg.ScaleBy(Screen.PixelsPerInch, 96);
    Result := Dlg.ShowModal;
  finally
    FExecuteResult:=Result;
    Dlg.Free;
  end
end;


function TMBox.ButtonPressed: string;
begin
  case FExecuteResult of
    0: FButtonPressed:='None';
    1: FButtonPressed:='OK';
    2: FButtonPressed:='Cancel';
    3: FButtonPressed:='Abort';
    4: FButtonPressed:='Retry';
    5: FButtonPressed:='Ignore';
    6: FButtonPressed:='Yes';
    7: FButtonPressed:='No';
    8: FButtonPressed:='All';
    9: FButtonPressed:='No To All';
    10: FButtonPressed:='Yes To All';
    11: FButtonPressed:='Help';
   end;
   Result:=FButtonPressed;
end;

procedure TMBox.SetCopyright(Value: string);
begin
  FCopyright:=FCopyright;
end;

end.
