unit UnitInsercao;

interface

uses
  Windows, Messages, SysUtils, Classes, Graphics, Controls, Forms, Dialogs,
  StdCtrls, Grids, Math;

type
  TFPrincipal = class(TForm)
    EditValor: TEdit;
    EditPosicao: TEdit;
    LabelValor: TLabel;
    LabelPosicao: TLabel;
    SGTabela: TStringGrid;
    ButtonInserir: TButton;
    ButtonRemover: TButton;
    ButtonInserirOrdenado: TButton;
    EditN: TEdit;
    LabelN: TLabel;
    ButtonBuscaLin: TButton;
    ButtonBuscaSentinela: TButton;
    ButtonBuscaBinaria: TButton;
    ButtonPreencher: TButton;
    EditTempo: TEdit;
    LabelTempo: TLabel;
    ButtonBuscaOrdenada: TButton;
    ButtonSelDir: TButton;
    ButtonMenor: TButton;
    procedure ButtonInserirClick(Sender: TObject);
    procedure ButtonRemoverClick(Sender: TObject);
    procedure ButtonInserirOrdenadoClick(Sender: TObject);
    procedure ButtonBuscaLinClick(Sender: TObject);
    procedure ButtonBuscaSentinelaClick(Sender: TObject);
    procedure ButtonBuscaBinariaClick(Sender: TObject);
    procedure ButtonPreencherClick(Sender: TObject);
    procedure ButtonBuscaOrdenadaClick(Sender: TObject);
    procedure ButtonMenorClick(Sender: TObject);
    procedure ButtonSelDirClick(Sender: TObject);
  private
    { Private declarations }
  public
    { Public declarations }
  end;

var
  FPrincipal: TFPrincipal;

implementation
{$R *.DFM}
const M = 10;

type VetorM = array [1..M] of integer;

var
  A : VetorM;
  N : integer;
  Tempo : cardinal;

procedure MostrarDados;
var i:integer;
begin
  with FPrincipal.SGTabela do
  begin
    Cells[0,0]:= 'Posio';
    Cells[1,0]:= 'Valor';
    // limpar o grid
    for i:= 1 to RowCount do
    begin
      Cells[0,i]:='';
      Cells[1,i]:='';
    end;
    // preencher o grid
    for i:= 1 to Min(N,RowCount)do
    begin
      Cells[0,i]:=IntToStr(i);
      Cells[1,i]:=IntToStr(A[i]);
    end;
  end;
  FPrincipal.EditN.Text := IntToStr(N);
  Tempo:= GetTickCount - Tempo;
  Fprincipal.EditTempo.Text:= IntToStr(Tempo);
end;

procedure InsereEmP(var A : VetorM; var N: integer; P, NovoValor: integer);
var i: integer;
begin
 if (P<=N+1) and (P > 0) and ((N+1)<=M) then
  begin
    for i := N downto P do
    begin
    A[i+1] := A[i];
    end;
    A[P]:=NovoValor;
    N:=N+1;
  end
  else
     ShowMessage('Insero no foi possvel');
     if (P + 1 > M) then
     Fprincipal.EditPosicao.Text:= IntToStr(M)
     else
     FPrincipal.EditPosicao.Text:= IntToStr(P+1);
     FPrincipal.EditValor.clear;
     FPrincipal.EditValor.setfocus;
end;

procedure RemoveP (Var A: VetorM; var N: integer; K: integer);
var i : integer;
begin
   if ((K<1)or(K>N)) then
    ShowMessage('Posio invlida')
  else
  begin
    for i := K to N-1 do
      begin
      A[i] := A[i+1];
      end;
    N:=N-1;
  end;
end;

procedure BuscaBinaria (N: integer;  Var A: vetorM; K: integer; Var Local: integer);
var X,F,I: integer;
    Achou : boolean;
begin
I:= 1;
F:= N;
Achou:= False;
 repeat
  X:= (I + F)div 2;
  if A[X] = K then
     Achou:= True
     else
      if K<A[X] then
        F:= X - 1
        else
        I:= X + 1;
 until Achou or(F<I);
  if Achou then
   Local:= X;
   FPrincipal.EditPosicao.Text:= IntToStr(Local);
end;

procedure InsereOrdenado (Var A: VetorM; Var N: integer; NovoValor: integer);
var P: integer;
begin
 P:= N;
 while (NovoValor<A[P]) and (P>=1) do
 begin
 A[P+1]:= A[P];
 P:= P - 1;
 end;
 A[P+1]:= NovoValor;
 N:= N+1;
 if (P + 1 > M) then
 Fprincipal.EditPosicao.Text:= IntToStr(M)
 else
 Fprincipal.EditPosicao.Text:= IntToStr(P + 1);
end;

procedure BuscaLinear (Var A: VetorM; N: integer; ValorBuscado: integer);
var J: integer;
begin
 J:= 1;
 while ( A[J]<> ValorBuscado) and (J<N) do
 begin
 J:=J+1;
 end;
 if (A[J] <> ValorBuscado)then
  ShowMessage ('Valor No Encontrado')
  else
  FPrincipal.EditPosicao.Text:= IntToStr(J);
end;

Procedure BuscaComSentinela (Var A: VetorM; ValorBuscado:integer; N: integer);
var j: integer;
begin
J:= 1;
A[N+1]:= ValorBuscado;
 while (A[J] <> ValorBuscado) do
 begin
 J:= J + 1;
 end;
 if (J = N + 1) or (N=M) then
 ShowMessage('No  Possvel Realizar Busca com Sentinela')
 else
 FPrincipal.EditPosicao.Text:= IntToStr(J);
end;

procedure preencher(Var A: VetorM; Var N: integer);
var I: integer;
begin
For I:= 1 to M do
 begin
 A[I]:= I;
 end;
 N:= M;
end;

procedure TFPrincipal.ButtonInserirClick(Sender: TObject);
var
  NovoValor,P: integer;
begin
  // entrada de dados
  NovoValor := StrToInt(EditValor.text);
  P := StrToInt(EditPosicao.Text);
  // computao dos dados
  Tempo:= GetTickCount;
  InsereEmP(A,N,P,NovoValor);
  // Saida de dados
  MostrarDados;
end;

procedure TFPrincipal.ButtonRemoverClick(Sender: TObject);
var K: integer;
begin
  // entrada de dados
  K := StrToInt(EditPosicao.Text);
  // computao dos dados
  Tempo:= GetTickCount;
  RemoveP(A,N,K);
  // Saida de dados
  MostrarDados;
end;

procedure TFPrincipal.ButtonInserirOrdenadoClick(Sender: TObject);
var NovoValor: integer;
begin
 // Entrada De Dados
 Tempo:= GetTickCount;
 NovoValor:= StrToInt(EditValor.Text);
 // Computao de Dados
 InsereOrdenado (A,N,NovoValor);
 // Saida De Dados
  MostrarDados;
  EditValor.clear;
  EditValor.setfocus;
end;

procedure TFPrincipal.ButtonBuscaLinClick(Sender: TObject);
var ValorBuscado: integer;
begin
 // Entrada de Dados
 Tempo:= GetTickCount;
 ValorBuscado:= StrToInt(EditValor.Text);
 // Computao dos Dados
 BuscaLinear(A,N,ValorBuscado);
 // Saida de Dados
 MostrarDados;
end;

procedure TFPrincipal.ButtonBuscaSentinelaClick(Sender: TObject);
var ValorBuscado: integer;
begin
 // Entrada de Dados
 Tempo:= GetTickCount;
 ValorBuscado:= StrToInt(EditValor.Text);
 // Computao de Dados
 BuscaComSentinela (A,ValorBuscado,N);
 // Saida de Dados
 MostrarDados;
end;

procedure TFPrincipal.ButtonBuscaBinariaClick(Sender: TObject);
var K,Local: integer;
begin
   // Entrada dos Dados
   K:= StrToInt(EditValor.Text);
   Local:= 0;
   // Computao dos Dados
   Tempo:= GetTickCount;
   BuscaBinaria (N,A,K,Local);
   // Saida de Dados
   MostrarDados;
end;

procedure TFPrincipal.ButtonPreencherClick(Sender: TObject);
begin
 // Entrada de Dados
 Tempo:= GetTickCount;
 // Computao de Dados
 preencher(A,N);
 // Saida de Dados
 MostrarDados;
end;

procedure TFPrincipal.ButtonBuscaOrdenadaClick(Sender: TObject);
var P, K : integer;
begin
P:= 1;
K:= StrToInt(EditValor.Text);
while P<>K do
P:= P + 1;
if (K = A[P]) then
EditPosicao.Text:= IntToStr(P)
else
ShowMessage('Valor No Encontrado.');
end;

procedure TFPrincipal.ButtonMenorClick(Sender: TObject);
var I, Menor: integer;
begin
I:=1;
Menor:= A[I];
repeat
 if(Menor>A[I+1])then
 begin
 Menor:=A[I+1];
 I:= I + 1;
 end
 else
 I:= I + 1;
until (I=N);
BuscaLinear(A,N,Menor);
EditValor.Text:= IntToStr(Menor);
end;

procedure TFPrincipal.ButtonSelDirClick(Sender: TObject);
var I, J, Aux, Menor: integer;
begin
Tempo:= GetTickCount;
For J:= 1 to N-1 do
begin
 For I:= 1 to N-1 do
 begin
 Menor:= A[I];
 if (Menor > A[I+1]) then
 begin
 Aux:= Menor;
 Menor:= A[I+1];
 A[I+1]:= Aux;
 end;
 A[I]:= Menor;
 end;
 end;
 MostrarDados;


end;

end.

