unit Unit1;

interface

uses
  Windows, Messages, SysUtils, Classes, Graphics, Controls, Forms, Dialogs,
  StdCtrls, Winsock;

type
  TForm1 = class(TForm)
    Button1: TButton;
    Label1: TLabel;
    procedure Button1Click(Sender: TObject);
  private
    { Private declarations }
    Function GetHostName(strIPAddress : String) : String;
  public
    { Public declarations }
  end;

var
  Form1: TForm1;

implementation

{$R *.DFM}

procedure TForm1.Button1Click(Sender: TObject);
begin
   Label1.Caption := GetHostName('192.168.1.1');
end;

Function TForm1.GetHostName(strIPAddress : String) : String;
// Requer a Winsock declarada na clausula uses da unit
Var
strHost          : String;
pszIPAddress     : PChar;
pReturnedHostEnt : PHostEnt;
InternetAddr     : u_long;
GInitData        : TWSADATA;
Begin
strHost := '';
If WSAStartup($101, GInitData) = 0 then
   Begin
   pszIPAddress := StrAlloc( Length( strIPAddress ) + 1 );
   StrPCopy( pszIPAddress, strIPAddress );
   InternetAddr := Inet_Addr(pszIPAddress);
   StrDispose( pszIPAddress );
   pReturnedHostEnt := GetHostByAddr( PChar(@InternetAddr),4, PF_INET );
   try
     strHost := pReturnedHostEnt^.h_name;
     WSACleanup;
     Result := strHost;
   except
     Result := 'Host invlido ou no encontrado';
   end;
   end;
end;

end.
