{                    Module Name: HCETCompClock.pas
                     Date/Time Started: 24 September 2001 / 10:20
                     Date/Time Finished: 24 September 2001 / 11:05
                     Author: Hugo Tuplin
                     Version: 1.0
                     Copyright: 2001-Hugo Tuplin
Description:
}
unit HCETCompClock;

interface

uses
  Windows, Messages, SysUtils, Classes, Graphics, Controls, Forms, Dialogs,
  StdCtrls, extctrls;

type
  THCETCompClock = class(TCustomLabel)
  private
    { Private declarations }
    {Define the Timer component}
    FTimer:TTimer;
    {Define the function and property to determine and set the Timer's status}
    function GetActive:Boolean;
    procedure SetActive(Value:Boolean);
  protected
    { Protected declarations }
    {The procedure to update the clock}
    procedure UpdateClock(Sender:TObject);
  public
    { Public declarations }
    {The constructor to create the component}
    constructor Create(AOwner:TComponent); override;
  published
    { Published declarations }
    {The properties}
    property Align;
    property Alignment;
    property Color;
    property Font;
    property ParentColor;
    property ParentFont;
    property ParentShowHint;
    property PopupMenu;
    property ShowHint;
    property Transparent;
    property Visible;
    {Our custom property}
    property Active: Boolean
      read GetActive write SetActive;
  end;

procedure Register;

implementation

procedure Register;
begin
  //Register the component to Delphi
  RegisterComponents('HCET Components', [THCETCompClock]);
end;

function THCETCompClock.GetActive: Boolean;
begin
     //Return the Timer's status
     Result:=FTimer.Enabled;
end;

procedure THCETCompClock.SetActive(Value:Boolean);
begin
     //Set the Timer's ststus
     FTimer.Enabled:=Value;
end;

constructor THCETCompClock.Create(AOwner:TComponent);
begin
     //Create all variables for the component
     inherited Create(AOwner);
     UpdateClock(Self);
     FTimer:=TTimer.Create(Self);
     FTimer.OnTimer:=UpdateClock;
     FTimer.Enabled:=True;
end;

procedure THCETCompClock.UpdateClock(Sender:TObject);
begin
     //Update the caption to display the current time (Every 1 second)
     Caption:=TimeToStr(Time);
end;

end.
