unit fmeEditorTexto;

interface

uses 
  Windows, Messages, SysUtils, Classes, Graphics, Controls, Forms, Dialogs,
  ComCtrls, StdCtrls, ExtCtrls, ToolWin, ImgList, ActnList;

type
  TEditorTexto = class(TFrame)
    ActionList1: TActionList;
    FileNewCmd: TAction;
    FileOpenCmd: TAction;
    FileSaveCmd: TAction;
    FilePrintCmd: TAction;
    FileSaveAsCmd: TAction;
    ActionList2: TActionList;
    EditUndoCmd: TAction;
    EditCutCmd: TAction;
    EditCopyCmd: TAction;
    EditPasteCmd: TAction;
    EditFontCmd: TAction;
    FontDialog1: TFontDialog;
    OpenDialog: TOpenDialog;
    SaveDialog: TSaveDialog;
    ToolbarImages: TImageList;
    PrintDialog: TPrintDialog;
    Panel7: TPanel;
    StandardToolBar: TToolBar;
    ToolButton1: TToolButton;
    OpenButton: TToolButton;
    SaveButton: TToolButton;
    PrintButton: TToolButton;
    ToolButton5: TToolButton;
    CutButton: TToolButton;
    CopyButton: TToolButton;
    PasteButton: TToolButton;
    UndoButton: TToolButton;
    ToolButton10: TToolButton;
    FontName: TComboBox;
    ToolButton11: TToolButton;
    FontSize: TEdit;
    UpDown1: TUpDown;
    ToolButton2: TToolButton;
    BoldButton: TToolButton;
    ItalicButton: TToolButton;
    UnderlineButton: TToolButton;
    ToolButton16: TToolButton;
    LeftAlign: TToolButton;
    CenterAlign: TToolButton;
    RightAlign: TToolButton;
    ToolButton20: TToolButton;
    BulletsButton: TToolButton;
    Ruler: TPanel;
    FirstInd: TLabel;
    LeftInd: TLabel;
    RulerLine: TBevel;
    RightInd: TLabel;
    Bevel1: TBevel;
    Editor: TRichEdit;
    StatusBar: TStatusBar;
    procedure ActionList2Update(Action: TBasicAction;
      var Handled: Boolean);
    procedure FileNewCmdExecute(Sender: TObject);
    procedure FileOpenCmdExecute(Sender: TObject);
    procedure FileSaveCmdExecute(Sender: TObject);
    procedure FilePrintCmdExecute(Sender: TObject);
    procedure FileSaveAsCmdExecute(Sender: TObject);
    procedure EditUndoCmdExecute(Sender: TObject);
    procedure EditCutCmdExecute(Sender: TObject);
    procedure EditCopyCmdExecute(Sender: TObject);
    procedure EditPasteCmdExecute(Sender: TObject);
    procedure EditFontCmdExecute(Sender: TObject);
    procedure FontNameChange(Sender: TObject);
    procedure FontSizeChange(Sender: TObject);
    procedure BoldButtonClick(Sender: TObject);
    procedure ItalicButtonClick(Sender: TObject);
    procedure UnderlineButtonClick(Sender: TObject);
    procedure LeftAlignClick(Sender: TObject);
    procedure CenterAlignClick(Sender: TObject);
    procedure RightAlignClick(Sender: TObject);
    procedure BulletsButtonClick(Sender: TObject);
    procedure EditorChange(Sender: TObject);
    procedure EditorSelectionChange(Sender: TObject);
    procedure FirstIndMouseDown(Sender: TObject; Button: TMouseButton;
      Shift: TShiftState; X, Y: Integer);
    procedure FirstIndMouseMove(Sender: TObject; Shift: TShiftState; X,
      Y: Integer);
    procedure FirstIndMouseUp(Sender: TObject; Button: TMouseButton;
      Shift: TShiftState; X, Y: Integer);
    procedure LeftIndMouseUp(Sender: TObject; Button: TMouseButton;
      Shift: TShiftState; X, Y: Integer);
    procedure RightIndMouseUp(Sender: TObject; Button: TMouseButton;
      Shift: TShiftState; X, Y: Integer);
  private
    { Private declarations }
  public
    { Public declarations }
  end;

implementation

{$R *.DFM}

procedure TEditorTexto.ActionList2Update(Action: TBasicAction;
  var Handled: Boolean);
begin
  EditCutCmd.Enabled := Editor.SelLength > 0;
  EditCopyCmd.Enabled := EditCutCmd.Enabled;
  if Editor.HandleAllocated then
  begin
    EditUndoCmd.Enabled := Editor.Perform(EM_CANUNDO, 0, 0) <> 0;
    EditPasteCmd.Enabled := Editor.Perform(EM_CANPASTE, 0, 0) <> 0;
  end;
end;

procedure TEditorTexto.FileNewCmdExecute(Sender: TObject);
begin
  SetFileName(sUntitled);
  Editor.Lines.Clear;
  Editor.Modified := False;
  SetModified(False);
end;

procedure TEditorTexto.FileOpenCmdExecute(Sender: TObject);
begin
  CheckFileSave;
  if OpenDialog.Execute then
  begin
    PerformFileOpen(OpenDialog.FileName);
    Editor.ReadOnly := ofReadOnly in OpenDialog.Options;
  end;
end;

procedure TEditorTexto.FileSaveCmdExecute(Sender: TObject);
begin
  if FFileName = sUntitled then
    FileSaveAsCmdExecute(Sender)
  else
  begin
    Editor.Lines.SaveToFile(FFileName);
    Editor.Modified := False;
    SetModified(False);
  end;
end;

procedure TEditorTexto.FilePrintCmdExecute(Sender: TObject);
begin
  if PrintDialog.Execute then
    Editor.Print(FFileName);
end;

procedure TEditorTexto.FileSaveAsCmdExecute(Sender: TObject);
begin
  if SaveDialog.Execute then
  begin
    if FileExists(SaveDialog.FileName) then
      if MessageDlg (Format (sOverWrite, [SaveDialog.FileName]), mtConfirmation, mbYesNoCancel, 0) <> idYes then
        Exit;
    Editor.Lines.SaveToFile(SaveDialog.FileName);
    SetFileName(SaveDialog.FileName);
    Editor.Modified := False;
    SetModified(False);
  end;
end;

procedure TEditorTexto.EditUndoCmdExecute(Sender: TObject);
begin
  with Editor do
    if HandleAllocated then
      SendMessage(Handle, EM_UNDO, 0, 0);
end;

procedure TEditorTexto.EditCutCmdExecute(Sender: TObject);
begin
  Editor.CutToClipboard;
end;

procedure TEditorTexto.EditCopyCmdExecute(Sender: TObject);
begin
  Editor.CopyToClipboard;
end;

procedure TEditorTexto.EditPasteCmdExecute(Sender: TObject);
begin
  Editor.PasteFromClipboard;
end;

procedure TEditorTexto.EditFontCmdExecute(Sender: TObject);
begin
  FontDialog1.Font.Assign(Editor.SelAttributes);
  if FontDialog1.Execute then
    CurrText.Assign(FontDialog1.Font);
  EditorSelectionChange(Self);
  Editor.SetFocus;
end;

procedure TEditorTexto.FontNameChange(Sender: TObject);
begin
  if FUpdating then
    Exit;
  CurrText.Name := FontName.Items[FontName.ItemIndex];
end;

procedure TEditorTexto.FontSizeChange(Sender: TObject);
begin
  if FUpdating then
    Exit;
  CurrText.Size := StrToInt(FontSize.Text);
end;

procedure TEditorTexto.BoldButtonClick(Sender: TObject);
begin
  if FUpdating then
    Exit;
  if BoldButton.Down then
    CurrText.Style := CurrText.Style + [fsBold]
  else
    CurrText.Style := CurrText.Style - [fsBold];
end;

procedure TEditorTexto.ItalicButtonClick(Sender: TObject);
begin
  if FUpdating then
    Exit;
  if ItalicButton.Down then
    CurrText.Style := CurrText.Style + [fsItalic]
  else
    CurrText.Style := CurrText.Style - [fsItalic];
end;

procedure TEditorTexto.UnderlineButtonClick(Sender: TObject);
begin
  if FUpdating then
    Exit;
  if UnderlineButton.Down then
    CurrText.Style := CurrText.Style + [fsUnderline]
  else
    CurrText.Style := CurrText.Style - [fsUnderline];
end;

procedure TEditorTexto.LeftAlignClick(Sender: TObject);
begin
  if FUpdating then
    Exit;
  Editor.Paragraph.Alignment := TAlignment(TControl(Sender).Tag);
end;

procedure TEditorTexto.CenterAlignClick(Sender: TObject);
begin
  if FUpdating then
    Exit;
  Editor.Paragraph.Alignment := TAlignment(TControl(Sender).Tag);
end;

procedure TEditorTexto.RightAlignClick(Sender: TObject);
begin
  if FUpdating then
    Exit;
  Editor.Paragraph.Alignment := TAlignment(TControl(Sender).Tag);
end;

procedure TEditorTexto.BulletsButtonClick(Sender: TObject);
begin
  if FUpdating then
    Exit;
  Editor.Paragraph.Numbering := TNumberingStyle(BulletsButton.Down);
end;

procedure TEditorTexto.EditorChange(Sender: TObject);
begin
  SetModified(Editor.Modified);
end;

procedure TEditorTexto.EditorSelectionChange(Sender: TObject);
begin
  with Editor.Paragraph do
    try
      FUpdating := True;
      FirstInd.Left := Trunc(FirstIndent*RulerAdj)-4+GutterWid;
      LeftInd.Left := Trunc((LeftIndent+FirstIndent)*RulerAdj)-4+GutterWid;
      RightInd.Left := Ruler.ClientWidth-6-Trunc((RightIndent+GutterWid)*RulerAdj);
      BoldButton.Down := fsBold in Editor.SelAttributes.Style;
      ItalicButton.Down := fsItalic in Editor.SelAttributes.Style;
      UnderlineButton.Down := fsUnderline in Editor.SelAttributes.Style;
      BulletsButton.Down := Boolean(Numbering);
      FontSize.Text := IntToStr(Editor.SelAttributes.Size);
      FontName.Text := Editor.SelAttributes.Name;
      case Ord(Alignment) of
        0: LeftAlign.Down := True;
        1: RightAlign.Down := True;
        2: CenterAlign.Down := True;
      end;
      UpdateCursorPos;
    finally
      FUpdating := False;
    end;
end;

procedure TEditorTexto.FirstIndMouseDown(Sender: TObject;
  Button: TMouseButton; Shift: TShiftState; X, Y: Integer);
begin
  FDragOfs := (TLabel(Sender).Width div 2);
  TLabel(Sender).Left := TLabel(Sender).Left + X - FDragOfs;
  FDragging := True;
end;

procedure TEditorTexto.FirstIndMouseMove(Sender: TObject; Shift: TShiftState;
  X, Y: Integer);
begin
  if FDragging then
    TLabel(Sender).Left :=  TLabel(Sender).Left + X - FDragOfs
end;

procedure TEditorTexto.FirstIndMouseUp(Sender: TObject; Button: TMouseButton;
  Shift: TShiftState; X, Y: Integer);
begin
  FDragging := False;
  Editor.Paragraph.FirstIndent := Trunc((FirstInd.Left + FDragOfs - GutterWid) / RulerAdj);
  LeftIndMouseUp(Sender, Button, Shift, X, Y);
end;

procedure TEditorTexto.LeftIndMouseUp(Sender: TObject; Button: TMouseButton;
  Shift: TShiftState; X, Y: Integer);
begin
  FDragging := False;
  Editor.Paragraph.LeftIndent := Trunc((LeftInd.Left + FDragOfs - GutterWid) / RulerAdj) - Editor.Paragraph.FirstIndent;
  EditorSelectionChange(Sender);
end;

procedure TEditorTexto.RightIndMouseUp(Sender: TObject; Button: TMouseButton;
  Shift: TShiftState; X, Y: Integer);
begin
  FDragging := False;
  Editor.Paragraph.RightIndent := Trunc((Ruler.ClientWidth - RightInd.Left + FDragOfs - 2) / RulerAdj) - 2 * GutterWid;
  EditorSelectionChange(Sender);
end;

end.
