unit TestMainForm;

interface

{DEFINE STATIC_LINK_LIB}
{$DEFINE DYNAMIC_LINK_LIB}

uses
  Messages, SysUtils, Classes, Graphics, Controls, Forms, Dialogs,
  StdCtrls, Windows, Menus;

type
  TTestForm = class(TForm)
    btnModalForm: TButton;
    btnTestMsg: TButton;
    btnModelessFormCreate: TButton;
    btnModelessFormDestroy: TButton;
    Button1: TButton;
    Button2: TButton;
    Button4: TButton;
    Button5: TButton;
    MainMenu1: TMainMenu;
    Main1: TMenuItem;
    cbUseTScreen: TCheckBox;
    procedure FormCreate(Sender: TObject);
    procedure FormDestroy(Sender: TObject);
    procedure FormClose(Sender: TObject; var Action: TCloseAction);
    procedure btnTestMsgClick(Sender: TObject);
    procedure btnModalFormClick(Sender: TObject);
    procedure btnModelessFormCreateClick(Sender: TObject);
    procedure btnModelessFormDestroyClick(Sender: TObject);
    procedure Button1Click(Sender: TObject);
    procedure Button2Click(Sender: TObject);
    procedure Button4Click(Sender: TObject);
    procedure Button5Click(Sender: TObject);
  private
    { Private declarations }
  public
    { Public declarations }
  end;

var
  TestForm: TTestForm;

{$IFDEF DYNAMIC_LINK_LIB}
  LibHandle: THandle;

type
  TDisplayModalForm = procedure(AHandle: THandle);
  TCreateModeLessForm = procedure(AHandle: THandle);
  TDestroyModeLessForm = procedure;
  TShowTestDllMessage = procedure;
  TDLLEntryPoint = procedure(dwReason: DWORD); stdcall; //register; //stdcall;
  TDisplayModalForm2 = procedure(App: TApplication);
  TCreateModeLessForm2 = procedure(App: TApplication);
  TRestoreAppAndScr = procedure;
  TCreateMDIChildForm2 = procedure(App: TApplication; Scr: TScreen);
  TDestroyMDIChildForm = procedure;

var
  DisplayModalForm   : TDisplayModalForm;
  CreateModeLessForm : TCreateModeLessForm;
  DestroyModeLessForm: TDestroyModeLessForm;
  ShowTestDllMessage : TShowTestDllMessage;
  DLLEntryPoint      : TDLLEntryPoint;
  DisplayModalForm2  : TDisplayModalForm2;
  CreateModeLessForm2: TCreateModeLessForm2;
  RestoreAppAndScr   : TRestoreAppAndScr;
  CreateMDIChildForm2: TCreateMDIChildForm2;
  DestroyMDIChildForm: TDestroyMDIChildForm;
{$ENDIF}

{$IFDEF STATIC_LINK_LIB}
  procedure ShowTestDllMessage;
  procedure DisplayModalForm(AHandle: THandle);
  procedure CreateModeLessForm(AHandle: THandle);
  procedure DestroyModeLessForm;
  procedure DLLEntryPoint(dwReason: DWORD); stdcall;
{$ENDIF}

//const
//  DLLFILENAME = 'DLLForm.dll';

implementation

{$R *.DFM}

{$IFDEF STATIC_LINK_LIB}
procedure ShowTestDllMessage; external 'DLLForm.dll' Name 'ShowTestDllMessage';
procedure DisplayModalForm(AHandle: THandle); external 'DLLForm.dll' Name 'DisplayModalForm';
procedure CreateModeLessForm(AHandle: THandle); external 'DLLForm.dll' Name 'CreateModeLessForm';
procedure DestroyModeLessForm; external 'DLLForm.dll' Name 'DestroyModeLessForm';
procedure DLLEntryPoint(dwReason: DWORD); external 'DLLForm.dll' Name 'DLLEntryPoint'; stdcall;
{$ENDIF}

procedure TTestForm.FormCreate(Sender: TObject);
begin
{$IFDEF DYNAMIC_LINK_LIB}
   if LibHandle <> 0 then
   begin
      ShowMessage('Library already loaded');
      Exit;
   end;
   LibHandle := LoadLibrary('DLLForm.dll');
   try
      if LibHandle = 0 then
      begin
         raise Exception.Create('Unable to load DLL');
         Exit;
      end;
      @DisplayModalForm   := GetProcAddress(LibHandle, 'DisplayModalForm');
      @CreateModeLessForm := GetProcAddress(LibHandle, 'CreateModeLessForm');
      @DestroyModeLessForm:= GetProcAddress(LibHandle, 'DestroyModeLessForm');
      @ShowTestDllMessage := GetProcAddress(LibHandle, 'ShowTestDllMessage');
      @DLLEntryPoint      := GetProcAddress(LibHandle, 'DLLEntryPoint');
      @DisplayModalForm2  := GetProcAddress(LibHandle, 'DisplayModalForm2');
      @CreateModeLessForm2:= GetProcAddress(LibHandle, 'CreateModeLessForm2');
      @RestoreAppAndScr   := GetProcAddress(LibHandle, 'RestoreAppAndScr');
      @CreateMDIChildForm2:= GetProcAddress(LibHandle, 'CreateMDIChildForm2');
      @DestroyMDIChildForm:= GetProcAddress(LibHandle, 'DestroyMDIChildForm');
   except
      FreeLibrary(LibHandle);
   end;
{$ENDIF}
end;

procedure TTestForm.FormDestroy(Sender: TObject);
begin
//
end;

procedure TTestForm.FormClose(Sender: TObject; var Action: TCloseAction);
begin
{$IFDEF DYNAMIC_LINK_LIB}
   @DisplayModalForm   := nil;
   @CreateModeLessForm := nil;
   @DestroyModeLessForm:= nil;
   @ShowTestDllMessage := nil;
   @DisplayModalForm2  := nil;
   @CreateModeLessForm2:= nil;
   @RestoreAppAndScr   := nil;
   @CreateMDIChildForm2:= nil;
   @DestroyMDIChildForm:= nil;
   if LibHandle = 0 then
   begin
      ShowMessage('Library already released');
      Exit;
   end;
//The two following procedures can be used to detach the dll
   //FreeLibrary(LibHandle);
   { or }
   DLLEntryPoint(DLL_PROCESS_DETACH); //The procedure call can be used for VB and/or Delphi
   LibHandle := 0;
{$ENDIF}
  Action := caFree;
end;

procedure TTestForm.btnTestMsgClick(Sender: TObject);
begin
   ShowTestDllMessage;
end;

procedure TTestForm.btnModalFormClick(Sender: TObject);
begin
   RestoreAppAndScr;
   DisplayModalForm(Application.Handle);
end;

procedure TTestForm.btnModelessFormCreateClick(Sender: TObject);
begin
   RestoreAppAndScr;
   CreateModeLessForm(Application.Handle);
end;

procedure TTestForm.btnModelessFormDestroyClick(Sender: TObject);
begin
   DestroyModeLessForm;
end;

procedure TTestForm.Button1Click(Sender: TObject);
begin
   DisplayModalForm2(Application);
end;

procedure TTestForm.Button2Click(Sender: TObject);
begin
   CreateModeLessForm2(Application);
end;

procedure TTestForm.Button4Click(Sender: TObject);
begin
   if cbUseTScreen.Checked then
      CreateMDIChildForm2(Application, Screen)
   else
      CreateMDIChildForm2(Application, nil);   
end;

procedure TTestForm.Button5Click(Sender: TObject);
begin
   DestroyMDIChildForm;
end;

end.


