unit DLL_Shared;

interface

uses
   Windows, Forms, Dialogs;

var
   DLLApp: TApplication;
   DLLScr: TScreen;
   DLLAppHandle: THandle;

procedure RestoreAppAndScr;
procedure ShowTestDllMessage;
procedure DisplayModalForm(AHandle: THandle);
procedure DisplayModalForm2(App: TApplication);
procedure CreateModeLessForm(AHandle: THandle);
procedure CreateModeLessForm2(App: TApplication);
procedure DestroyModeLessForm;
procedure CreateMDIChildForm2(App: TApplication; Scr: TScreen);
procedure DestroyMDIChildForm;

exports
    RestoreAppAndScr,
    ShowTestDllMessage,
    DisplayModalForm,
    DisplayModalForm2,
    CreateModeLessForm,
    CreateModeLessForm2,
    DestroyModeLessForm,
    CreateMDIChildForm2,
    DestroyMDIChildForm;

implementation

uses
   FormDLL, FormDLL2;

procedure ShowTestDllMessage;
begin
    ShowMessage('This is a test message from the DLL.');
end;

procedure RestoreAppAndScr;
begin
   Screen := DLLScr;
   Application := DLLApp;
end;

procedure DisplayModalForm(AHandle: THandle);
var
   DLLModalForm: TDLLForm;
begin
   Application.Handle := AHandle;
   DLLModalForm := TDLLForm.Create(Application);
   try
      DLLModalForm.Caption := 'Modal Form';
      DLLModalForm.ShowModal;
   finally
      DLLModalForm.Free;
      RestoreAppAndScr;
   end;
end;

procedure CreateModeLessForm(AHandle: THandle);
begin
   DestroyModeLessForm;
   if not Assigned(DLLModeLessForm) then
   begin
      Application.Handle := AHandle;
      DLLModeLessForm := TDLLForm.Create(Application);
      DLLModeLessForm.Caption := 'Modeless Form';
      DLLModeLessForm.Show;
   end
   else
   begin
      DLLModeLessForm.Show;
   end;
end;

procedure DestroyModeLessForm;
begin
   if Assigned(DLLModeLessForm) then
   begin
      DLLModeLessForm.Free;
   end
   else
   begin
      //ShowMessage('Form was already destroyed.');
   end;
   DLLModeLessForm := nil;
   RestoreAppAndScr;
end;

procedure DisplayModalForm2(App: TApplication);
var
   DLLModalForm: TDLLForm;
begin
   Application := App;
   DLLModalForm := TDLLForm.Create(Application);
   try
      DLLModalForm.Caption := 'Modal Form';
      DLLModalForm.ShowModal;
   finally
      DLLModalForm.Free;
      RestoreAppAndScr;
   end;
end;

procedure CreateModeLessForm2(App: TApplication);
begin
   DestroyModeLessForm;
   if not Assigned(DLLModeLessForm) then
   begin
      Application := App;
      DLLModeLessForm := TDLLForm.Create(Application);
      DLLModeLessForm.Caption := 'Modeless Form';
      DLLModeLessForm.Show;
   end
   else
   begin
      DLLModeLessForm.Show;
   end;
end;

procedure CreateMDIChildForm2(App: TApplication; Scr: TScreen);
begin
   if not Assigned(DLLForm2) then
   begin
      Application := App;
      //Assign Screen Object
      if Assigned(Scr) then Screen := Scr;
      //DLLForm2 := TDLLForm2.Create(Application);
      DLLForm2 := TDLLForm2.Create(Application.MainForm);
      DLLForm2.Caption := 'MDI Child Form';
      DLLForm2.Show;
   end
   else
   begin
      DLLForm2.Show;
   end;
end;

procedure DestroyMDIChildForm;
begin
   if Assigned(DLLForm2) then
   begin
      DLLForm2.Free;
   end
   else
   begin
      //ShowMessage('Form was already destroyed.');
   end;
   DLLForm2 := nil;
   RestoreAppAndScr;
end;

end.
