library DLLForm;

{ Important note about DLL memory management: ShareMem must be the
  first unit in your library's USES clause AND your project's (select
  Project-View Source) USES clause if your DLL exports any procedures or
  functions that pass strings as parameters or function results. This
  applies to all strings passed to and from your DLL--even those that
  are nested in records and classes. ShareMem is the interface unit to
  the BORLNDMM.DLL shared memory manager, which must be deployed along
  with your DLL. To avoid using BORLNDMM.DLL, pass string information
  using PChar or ShortString parameters. }

uses
  ShareMem,
  Windows,
  SysUtils,
  Classes,
  Forms,
  Dialogs,
  FormDLL in 'FormDLL.pas' {DLLForm},
  FormDLL2 in 'FormDLL2.pas' {DLLForm2},
  DLL_Shared in 'DLL_Shared.pas';

{$R *.RES}

//DLL Entry Point
procedure DLLEntryPoint(dwReason: DWORD); stdcall; //register; //stdcall;
begin
   case dwReason of
      DLL_PROCESS_ATTACH: //1
      begin
         DLLAppHandle := Application.Handle;
         DLLApp := Application;
         DLLScr := Screen;
      end;
      DLL_PROCESS_DETACH: //3
      begin
         DestroyModeLessForm;
         DestroyMDIChildForm;
         RestoreAppAndScr;
         Application.Handle := DLLAppHandle;
      end;
      DLL_THREAD_ATTACH : {ShowMessage('Thread Attach')};  //2
      DLL_THREAD_DETACH : {ShowMessage('Thread Detach')};  //0
   end;
end;

exports
    DLLEntryPoint;

begin
    //DLLEntryPoint is specifically a Win32 and C++ implementation
    //DLLProc is a pointer variable from the SYSTEM Unit (automatically included)
    //The SYSTEM Unit is responsible for executing code assinged to DLLEntryPoint
    DLLProc := @DLLEntryPoint;         //Assign the address of DLLEntryPoint to DLLProc
    DLLEntryPoint(DLL_PROCESS_ATTACH); //Indicate that the DLL is attaching to the process
end.

//In VB Call this to detach the DLL before the main process terminates
//DLLEntryPoint(DLL_PROCESS_ATTACH);


