unit Unit1;

interface

uses
  Windows, Messages, SysUtils, Classes, Graphics, Controls, Forms, Dialogs,
  ShlObj, ActiveX, ComObj, Registry, StdCtrls, ExtCtrls;

type
  TShortcutPlace = (stDesktop, stStartMenu);

  TForm1 = class(TForm)
    Edit1: TEdit;
    Button1: TButton;
    Edit2: TEdit;
    Label1: TLabel;
    Label2: TLabel;
    Edit3: TEdit;
    Label3: TLabel;
    Edit4: TEdit;
    Label4: TLabel;
    RadioGroup1: TRadioGroup;
    procedure Button1Click(Sender: TObject);
  private
    { Private declarations }
    Procedure CreateShortcut(FileName, Parameters, InitialDir, ShortcutName,
           ShortcutFolder : Pchar; Place: TShortcutPlace);
  public
    { Public declarations }
  end;

var
  Form1: TForm1;

implementation

{$R *.DFM}

procedure TForm1.Button1Click(Sender: TObject);
begin
   if RadioGroup1.ItemIndex = 0 then
      CreateShortcut(PChar(Edit1.Text), PChar(IntToStr(FileGetAttr(Edit1.Text))), PChar(Edit2.Text), PChar(Edit3.Text), PChar(Edit4.Text), stDesktop)
   else
      CreateShortcut(PChar(Edit1.Text), PChar(IntToStr(FileGetAttr(Edit1.Text))), PChar(Edit2.Text), PChar(Edit3.Text), PChar(Edit4.Text), stStartMenu);
end;

{declare uses ShlObj, ActiveX, ComObj, Registry;
 na seao public e crie o seguinte tipo:
 type
 TShortcutPlace = (stDesktop, stStartMenu);
}
Procedure TForm1.CreateShortcut(FileName, Parameters, InitialDir, ShortcutName,
  ShortcutFolder : Pchar; Place: TShortcutPlace);
var
MyObject  : IUnknown;
MySLink   : IShellLink;
MyPFile   : IPersistFile;
Directory : String;
WFileName : WideString;
MyReg     : TRegIniFile;
begin
MyObject := CreateComObject(CLSID_ShellLink);
MySLink := MyObject as IShellLink;
MyPFile := MyObject as IPersistFile;
with MySLink do
     begin
     SetArguments(Parameters);
     SetPath(PChar(FileName));
     SetWorkingDirectory(PChar(InitialDir));
     end;
     MyReg := TRegIniFile.Create('SoftwareMicroSoftWindowsCurrentVersionExplorer');
    if Place = stDesktop then
       Directory := MyReg.ReadString ('Shell Folders','Desktop','');
    if Place = stStartMenu then
       begin
       Directory := MyReg.ReadString('Shell Folders', 'Start Menu','') + '\' +ShortcutFolder;
       CreateDir(Directory);
       end;
    WFileName := 'c:\windows\desktop' {Directory} + '\' + ShortcutName + '.lnk';
    MyPFile.Save (PWChar (WFileName), False);
    MyReg.Free;
end;

end.
