unit Stat_pgm;

interface

uses
  Display,
  SysUtils, WinTypes, WinProcs, Messages, Classes, Graphics, Controls,
  Forms, Dialogs, Menus, SEE, KeyCode, StdCtrls;

type
  TStatus = class(TForm)
    MainMenu1: TMainMenu;
    mCheckMail: TMenuItem;
    mExit: TMenuItem;
    eMessage: TMemo;
    lUser: TLabel;
    lServer: TLabel;
    lPass: TLabel;
    eHost: TEdit;
    eUser: TEdit;
    ePass: TEdit;
    procedure mExitClick(Sender: TObject);
    procedure mCheckMailClick(Sender: TObject);
  private
    { Private declarations }
  public
    { Public declarations }
  end;

var
  Status: TStatus;
  D1, D2, D3 : Integer;
  Code : Integer;

implementation

{$R *.DFM}

procedure TStatus.mExitClick(Sender: TObject);
begin
  seeRelease;
  Application.Terminate;
end;

procedure TStatus.mCheckMailClick(Sender: TObject);
var
  Code : Integer;
  I, N : Integer;
  NbrMsg : Integer;
  BufferPtr : PChar;
  DatePtr : PChar;
  FromPtr : PChar;
  HostPtr : PChar;
  LogPtr  : PChar;
  PassPtr : PChar;
  SubjPtr : PChar;
  TempPtr : PChar;
  UserPtr : PChar;
  MsgSize : LongInt;
  Text    : String;
begin
  {attach SEE}
  Code := seeAttach(1, SEE_KEY_CODE);
  {show SEE version}
  Code := seeStatistics(0,SEE_GET_VERSION);
  D3 := $0F AND Code;  Code := Code SHR 4;
  D2 := $0F AND Code;  Code := Code SHR 4;
  D1 := $0F AND Code;
  Text := Format('SMTP/POP3 Email Engine Version %1d.%1d.%1d',
          [D1,D2,D3]);
  DisplayLine(Status.eMessage, Text);
  {do we have all necessary parameters ?}
  if Length(eHost.Text) = 0 then
    begin
      DisplayLine(Status.eMessage,'POP3 Host is missing');
      exit;
    end;
  if Length(eUser.Text) = 0 then
    begin
      DisplayLine(Status.eMessage,'User is missing');
      exit;
    end;
  if Length(ePass.Text) = 0 then
    begin
      DisplayLine(Status.eMessage,'Password is missing');
      exit;
    end;
  {define log file}
  GetMem(LogPtr,32); StrPCopy(LogPtr, 'STATUS.LOG');
  seeStringParam(0,SEE_LOG_FILE, LogPtr); FreeMem(LogPtr, 32);
  {allocate buffers}
  GetMem(HostPtr, 64); StrPCopy(HostPtr, eHost.Text);
  GetMem(UserPtr, 64); StrPCopy(UserPtr, eUser.Text);
  GetMem(PassPtr, 64); StrPCopy(PassPtr, ePass.Text);
  {connect to POP3 server}
  mCheckmail.Enabled := False;
  SCREEN.Cursor := crHourGlass;
  Code := seePop3Connect(0,HostPtr, UserPtr, PassPtr);
  {free buffers}
  FreeMem(HostPtr,64); FreeMem(UserPtr,64); FreeMem(PassPtr,64);
  {any errors ?}
  If Code < 0 then
    begin
      DisplayString(eMessage, 'seePop3Connect: ');
      DisplayError(eMessage, Code);
      mCheckmail.Enabled := True;
      SCREEN.Cursor := crDefault;
      seeClose(0);
      exit;
    end;
  {ready to check mail}
  DisplayLine(Status.eMessage,'Connected.');
  { get # messages waiting on server}
  DisplayLine(Status.eMessage,'Getting message count...');
  NbrMsg := seeGetEmailCount(0);
  if NbrMsg < 0 then DisplayError(Status.eMessage,NbrMsg);
  DisplayLine(Status.eMessage,Format('%d messages waiting.',[NbrMsg]));
  {construct pointers to strings}
  GetMem(BufferPtr, 1024);
  GetMem(TempPtr, 80);
  GetMem(DatePtr,8);  StrPCopy(DatePtr,'Date: ');
  GetMem(FromPtr,8);  StrPCopy(FromPtr,'From: ');
  GetMem(SubjPtr,12); StrPCopy(SubjPtr,'Subject: ');
  { read message headers }
  for I := 1 to NbrMsg do
    begin
      {read message I}
       MsgSize := seeGetEmailSize(0,I);
       DisplayLine(Status.eMessage,
         Format('---[ Message %d; %d bytes]---------------------------',
         [I,MsgSize]));
       Code := seeGetEmailLines(0,I, 0, BufferPtr, 1024);
       If Code < 0 then
         begin
           DisplayLine(eMessage, 'seeGetEmailLines: ');
           DisplayError(eMessage, Code);
           mCheckmail.Enabled := True;
           SCREEN.Cursor := crDefault;
           seeClose(0);
           exit;
         end;
       {display 'DATE: ' line}
       n := seeExtractText(BufferPtr, DatePtr, TempPtr, 80);
       if n > 0  then DisplayString(Status.eMessage,
         Format('%s', [StrPas(TempPtr)]));
       {display 'FROM: ' line}
       n := seeExtractText(BufferPtr, FromPtr, TempPtr, 80);
       if n > 0  then DisplayString(Status.eMessage,
         Format('%s', [StrPas(TempPtr)]));
       {display 'SUBJECT: ' line}
       n := seeExtractText(BufferPtr, SubjPtr, TempPtr, 80);
       if n > 0  then DisplayString(Status.eMessage,
         Format('%s', [StrPas(TempPtr)]));
    end;
  SCREEN.Cursor := crDefault;
  mCheckmail.Enabled := True;
  DisplayLine(Status.eMessage,
    '-------------------------------------------------------');
  FreeMem(BufferPtr,1024);
  FreeMem(TempPtr,80); FreeMem(DatePtr,8);
  FreeMem(FromPtr,8);  FreeMem(SubjPtr,12);
  seeClose(0);
end;

end.
