unit see;

interface

const
   SEE_MIN_RESPONSE_WAIT  = 1;
     SEE_MAX_RESPONSE_WAIT  = 2;
     SEE_CONNECT_WAIT       = 3;
     SEE_DISABLE_MIME       = 4;
     SEE_MIN_LINE_WAIT      = 5;
     SEE_MAX_LINE_WAIT      = 6;
     SEE_QUOTED_PRINTABLE   = 8;
     SEE_AUTO_CALL_DRIVER   = 9;
     SEE_FILE_PREFIX       = 10;
     SEE_MAX_SMTP_WAIT     = 11;
     SEE_MAX_POP3_WAIT     = 12;
     SEE_SLEEP_TIME        = 13;
     SEE_DECODE_UNNAMED    = 14;
     SEE_SMTP_PORT         = 15;
     SEE_POP3_PORT         = 16;
     SEE_MAX_LINE_LENGTH   = 17;
     SEE_BLOCKING_MODE     = 18;
   
     SEE_LOG_FILE          = 20;
   
     SEE_GET_ERROR_TEXT    = 1;
     SEE_GET_COUNTER       = 2;
     SEE_GET_RESPONSE      = 3;
     SEE_GET_SOCK_ERROR    = 4;
   
     SEE_GET_MESSAGE_BYTES_READ  = 10;
     SEE_GET_ATTACH_BYTES_READ   = 11;
     SEE_GET_TOTAL_BYTES_READ    = 12;
     SEE_GET_MESSAGE_BYTES_SENT  = 13;
     SEE_GET_ATTACH_BYTES_SENT   = 14;
     SEE_GET_TOTAL_BYTES_SENT    = 15;
     SEE_GET_VERSION             = 16;
     SEE_GET_MSG_COUNT           = 17;
     SEE_GET_MSG_SIZE            = 18;
     SEE_GET_BUFFER_COUNT        = 19;
     SEE_GET_CONNECT_STATUS      = 20;
     SEE_GET_REGISTRATION        = 21;
     SEE_GET_ATTACH_COUNT        = 22;
     SEE_GET_LAST_RESPONSE       = 23;
     SEE_GET_VERIFY_STATUS       = 24;
     SEE_GET_SERVER_IP           = 25;
     SEE_GET_BUILD               = 26;
     SEE_GET_SOCKET              = 27;
   
     SEE_SET_REPLY               = 50;
     SEE_SET_HEADER              = 51;
   
     QUOTED_OFF   = 0;
     QUOTED_PLAIN = 1;
     QUOTED_HTML  = 2;

function seeAttach(NbrChans : Integer; KeyCode : LongInt) : Integer;
function seeClose(Chan : Integer) : Integer;
function seeDebug(Chan : Integer; Index : Integer;  Buffer : PChar;  BufLen : Integer) : Integer;
function seeDecodeBuffer(CodedBuf : PChar; ClearBuf : PChar; BufLen : Integer) : Integer;
function seeDeleteEmail(Chan : Integer; MsgNbr : Integer) : Integer;
function seeDriver(Chan : Integer) : Integer;
function seeEncodeBuffer(ClearBuf : PChar; CodedBuf : PChar; BufLen : Integer) : Integer;
function seeErrorText(Chan : Integer; Code : Integer;  Buffer : PChar;  BufLen : Integer) : Integer;
function seeExtractText(Src, Text, Buffer : PChar; BufLen : Integer) : Integer;
function seeGetEmailCount(Chan : Integer) : Integer;
function seeGetEmailFile(Chan : Integer; MsgNbr : Integer;  FileName, EmailDir, AttachDir : PChar) : Integer;
function seeGetEmailLines(Chan : Integer; MsgNbr, Lines : Integer;  Buffer : PChar;  BufLen : Integer) : Integer;
function seeGetEmailSize(Chan : Integer; MsgNbr : Integer) : LongInt;
function seeGetEmailUID(Chan : Integer; MsgNbr : Integer; Buffer : PChar; BufLen : Integer) : Integer;
function seeIntegerParam(Chan : Integer; Index : Integer;  Value : LongInt) : Integer;
function seePop3Connect(Chan : Integer; Server, User, Password : PChar) : Integer;
function seeRelease : Integer;
function seeSendEmail(Chan : Integer; Rcpt, CC, BCC , Subj, Msg, Attach : PChar) : Integer;
function seeSmtpConnect(Chan : Integer; Server, From, Reply : PChar) : Integer;
function seeStatistics(Chan : Integer; Index : Integer) : Integer;
function seeStringParam(Chan : Integer; Index : Integer;  Value : PChar) : Integer;
function seeVerifyFormat(EmailAddr : PChar) : Integer;
function seeVerifyUser(Chan : Integer; EmailAddr : PChar) : Integer;

implementation

function seeAttach; external 'SEE16';
function seeClose; external 'SEE16';
function seeDebug; external 'SEE16';
function seeDecodeBuffer; external 'SEE16';
function seeDeleteEmail; external 'SEE16';
function seeDriver; external 'SEE16';
function seeEncodeBuffer; external 'SEE16';
function seeErrorText; external 'SEE16';
function seeExtractText; external 'SEE16';
function seeGetEmailCount; external 'SEE16';
function seeGetEmailFile; external 'SEE16';
function seeGetEmailLines; external 'SEE16';
function seeGetEmailSize; external 'SEE16';
function seeGetEmailUID; external 'SEE16';
function seeIntegerParam; external 'SEE16';
function seePop3Connect; external 'SEE16';
function seeRelease; external 'SEE16';
function seeSendEmail; external 'SEE16';
function seeSmtpConnect; external 'SEE16';
function seeStatistics; external 'SEE16';
function seeStringParam; external 'SEE16';
function seeVerifyFormat; external 'SEE16';
function seeVerifyUser; external 'SEE16';
end.
