unit Read_pgm;

interface

uses
  Display,
  SysUtils, WinTypes, WinProcs, Messages, Classes, Graphics, Controls,
  Forms, Dialogs, Menus, SEE, KeyCode, StdCtrls;

type
  TReader = class(TForm)
    MainMenu1: TMainMenu;
    mReadMail: TMenuItem;
    mExit: TMenuItem;
    eMessage: TMemo;
    lUser: TLabel;
    lServer: TLabel;
    lPass: TLabel;
    eHost: TEdit;
    eUser: TEdit;
    ePass: TEdit;
    cDelete: TCheckBox;
    procedure mExitClick(Sender: TObject);
    procedure mReadMailClick(Sender: TObject);
  private
    { Private declarations }
  public
    { Public declarations }
  end;

var
  Reader: TReader;
  D1, D2, D3 : Integer;
  Code : Integer;

implementation

{$R *.DFM}

procedure TReader.mExitClick(Sender: TObject);
begin
  seeRelease;
  Application.Terminate;
end;

procedure TReader.mReadMailClick(Sender: TObject);
var
  I    : Integer;
  Code : Integer;
  NbrMsg : Integer;
  Count : Integer;
  MsgSize : LongInt;
  BytesRead : LongInt;
  FileNamePtr : PChar;
  EmailDirPtr : PChar;
  AttachDirPtr : PChar;  
  HostPtr : PChar;
  UserPtr : PChar;
  PassPtr : PChar;
  LogPtr  : PChar;
  Text    : String;
begin
  {attach SEE}
  Code := seeAttach(1, SEE_KEY_CODE);
  {show SEE version}
  Code := seeStatistics(0,SEE_GET_VERSION);
  D3 := $0F AND Code;  Code := Code SHR 4;
  D2 := $0F AND Code;  Code := Code SHR 4;
  D1 := $0F AND Code;
  Text := Format('SMTP/POP3 Email Engine Version %1d.%1d.%1d',
          [D1,D2,D3]);
  DisplayLine(Reader.eMessage, Text);
  {do we have all necessary parameters ?}
  if Length(eHost.Text) = 0 then
    begin
      DisplayLine(Reader.eMessage,'POP3 Host is missing');
      exit;
    end;
  if Length(eUser.Text) = 0 then
    begin
      DisplayLine(Reader.eMessage,'User is missing');
      exit;
    end;
  if Length(ePass.Text) = 0 then
    begin
      DisplayLine(Reader.eMessage,'Password is missing');
      exit;
    end;
  {define log file}
  GetMem(LogPtr,32); StrPCopy(LogPtr, 'READER.LOG');
  seeStringParam(0,SEE_LOG_FILE, LogPtr); FreeMem(LogPtr, 32);
  {prefix attachment filename with "1-", "2-", etc.}
  seeIntegerParam(0,SEE_FILE_PREFIX, 1);
  {allocate buffers}
  GetMem(HostPtr, 64); StrPCopy(HostPtr, eHost.Text);
  GetMem(UserPtr, 64); StrPCopy(UserPtr, eUser.Text);
  GetMem(PassPtr, 64); StrPCopy(PassPtr, ePass.Text);
  {connect to POP3 server}
  SCREEN.Cursor := crHourGlass;
  mReadMail.Enabled := False;
  Code := seePop3Connect(0,HostPtr, UserPtr, PassPtr);
  {free buffers}
  FreeMem(HostPtr,64); FreeMem(UserPtr,64); FreeMem(PassPtr,64);
  {any errors ?}
  If Code < 0 then
    begin
      DisplayString(Reader.eMessage,'seePop3Connect: ');
      DisplayError(eMessage, Code);
      mReadMail.Enabled := True;
      SCREEN.Cursor := crDefault;
      seeClose(0);
      exit;
    end;
  {ready to check mail}
  DisplayLine(Reader.eMessage,'Connected.');
  { get # messages waiting on server}
  DisplayLine(Reader.eMessage,'Getting message count...');
  NbrMsg := seeGetEmailCount(0);
  if NbrMsg < 0 then DisplayError(Reader.eMessage,NbrMsg);
  DisplayLine(Reader.eMessage,Format('%d messages waiting.',[NbrMsg]));
  {construct pointers to strings}
  GetMem(FileNamePtr,64);
  GetMem(EmailDirPtr, 64);  StrPCopy(EmailDirPtr,'.');
  GetMem(AttachDirPtr, 64); StrPCopy(AttachDirPtr,'.');
  { read each email}
  for I := 1 to NbrMsg do
    begin
      {get email size}
      MsgSize := seeGetEmailSize(0,I);
      DisplayLine(Reader.eMessage,
        Format('Message %d has %d bytes.', [I, MsgSize]));
      {turn off AUTO CALL driver}
      seeIntegerParam(0,SEE_AUTO_CALL_DRIVER, 0);
      {construct filename for email}
      StrPCopy(FileNamePtr,Format('email%1d.mai',[I]));
      DisplayLine(Reader.eMessage,
         Format('Reading message %d to %s.', [I,StrPas(FileNamePtr)]));
      {setup to read email using seeDriver}
      Code := seeGetEmailFile(0,I, FileNamePtr, EmailDirPtr, AttachDirPtr);
      {any errors ?}
      If Code < 0 then
        begin
          DisplayString(Reader.eMessage,'seeGetEmailFile: ');
          DisplayError(eMessage, Code);
          mReadMail.Enabled := True;
          SCREEN.Cursor := crDefault;
          exit;
        end;
      Count := 0;
      {run the driver}
      Repeat
        Code := seeDriver(0);
        {any errors ?}
        If Code < 0 then
         begin
            DisplayString(Reader.eMessage,'seeDriver: ');
            DisplayError(eMessage, Code);
            mReadMail.Enabled := True;
            SCREEN.Cursor := crDefault;
            exit;
          end;
        Inc(Count);
        if (Count Mod 10 = 19) or (Code = 0) then
          begin
            {display progress on last call & every 20th call to seeDriver}
            BytesRead := seeStatistics(0,SEE_GET_TOTAL_BYTES_READ);
            DisplayLine(Reader.eMessage,
              Format('%d bytes read.', [BytesRead]));
          end
      until Code = 0;
      {turn AUTO CALL back on for seeClose}
      seeIntegerParam(0,SEE_AUTO_CALL_DRIVER, 1);
    end;
  {delete ?}
  if cDelete.Checked then
    begin
      for I := NbrMsg downto 1 do
        begin
          seeDeleteEmail(0,I);
          DisplayLine(Reader.eMessage,Format('Email # %d deleted.', [I]));
        end;
    end;
  {all done}
  DisplayLine(Reader.eMessage,'Done.');
  FreeMem(FileNamePtr,8);
  FreeMem(EmailDirPtr,8);
  FreeMem(AttachDirPtr,12);
  SCREEN.Cursor := crDefault;
  mReadMail.Enabled := True;
  seeClose(0)
end;

end.
