unit Mail_pgm;

interface

uses
  Display,
  SysUtils, WinTypes, WinProcs, Messages, Classes, Graphics, Controls,
  Forms, Dialogs, Menus, SEE, KeyCode, StdCtrls;

type
  TMailer = class(TForm)
    MainMenu1: TMainMenu;
    mSendMail: TMenuItem;
    mExit: TMenuItem;
    eMessage: TMemo;
    lUser: TLabel;
    lServer: TLabel;
    eHost: TEdit;
    eFrom: TEdit;
    lMessage: TLabel;
    lAttach: TLabel;
    lSubj: TLabel;
    eSubj: TEdit;
    eAttach: TEdit;
    eStatus: TMemo;
    lStatus: TLabel;
    lTo: TLabel;
    eTo: TEdit;
    procedure mExitClick(Sender: TObject);
    procedure mSendMailClick(Sender: TObject);
  private
    { Private declarations }
  public
    { Public declarations }
  end;

var
  Mailer: TMailer;
  D1, D2, D3 : Integer;
  Code : Integer;

implementation

{$R *.DFM}

procedure TMailer.mExitClick(Sender: TObject);
begin
  seeRelease;
  Application.Terminate;
end;

procedure TMailer.mSendMailClick(Sender: TObject);
var
  Code    : Integer;
  ToPtr   : PChar;
  MsgSize : Integer;
  SubjPtr : PChar;
  MsgPtr  : PChar;
  AttPtr  : PChar;
  NullPtr : PChar;
  HostPtr : PChar;
  FromPtr : PChar;
  LogPtr  : PChar;
  Text    : String;
begin
  {attach SEE}
  Code := seeAttach(1, SEE_KEY_CODE);
  {show SEE version}
  Code := seeStatistics(0,SEE_GET_VERSION);
  D3 := $0F AND Code;  Code := Code SHR 4;
  D2 := $0F AND Code;  Code := Code SHR 4;
  D1 := $0F AND Code;
  Text := Format('SMTP/POP3 Email Engine Version %1d.%1d.%1d',
          [D1,D2,D3]);
  DisplayLine(Mailer.eStatus, Text);
  {define log file}
  GetMem(LogPtr,32); StrPCopy(LogPtr, 'MAILER.LOG');
  seeStringParam(0,SEE_LOG_FILE, LogPtr); FreeMem(LogPtr, 32);
  {do we have all necessary parameters ?}
  if Length(eHost.Text) = 0 then
    begin
      DisplayLine(Mailer.eStatus,'SMTP Host is missing');
      exit;
    end;
  if Length(eFrom.Text) = 0 then
    begin
      DisplayLine(Mailer.eStatus,'From address is missing');
      exit;
    end;
  if Length(eTo.Text) = 0 then
    begin
      DisplayLine(Mailer.eStatus,'To address is missing');
      exit;
    end;
  {validate From email address}
  GetMem(FromPtr, 64); StrPCopy(FromPtr, eFrom.Text);
  Code := seeVerifyFormat(FromPtr);
  if Code < 0 then
    begin
      DisplayString(Mailer.eStatus,'From: ');
      DisplayError(Mailer.eStatus, Code);
      seeClose(0);
      FreeMem(FromPtr,64);
      exit;
    end;
  {validate To email address}
  GetMem(ToPtr, 64); StrPCopy(ToPtr, eTo.Text);
  Code := seeVerifyFormat(ToPtr);
  if Code = 0 then
    begin
      DisplayString(Mailer.eStatus,'To: ');
      DisplayError(eStatus, Code);
      seeClose(0);
      FreeMem(ToPtr,64);
      exit;
    end;  
  {allocate remaining buffers}
  GetMem(HostPtr, 64); StrPCopy(HostPtr, eHost.Text);
  GetMem(NullPtr, 4);  StrPCopy(NullPtr, '');
  {connect to POP3 server}
  mSendMail.Enabled := False;
  SCREEN.Cursor := crHourGlass;
  DisplayLine(Mailer.eStatus,Format('Connecting to %s',[StrPas(HostPtr)]));
  Code := seeSmtpConnect(0,HostPtr, FromPtr, NullPtr);
  {free buffers}
  FreeMem(HostPtr,64); FreeMem(FromPtr,64);
  {any errors ?}
  If Code < 0 then
    begin
      DisplayString(Mailer.eStatus,'seeSmtpConnect: ');
      DisplayError(Mailer.eStatus, Code);
      mSendMail.Enabled := True;
      SCREEN.Cursor := crDefault;
      seeClose(0);
      exit;
    end;
  {ready to send mail}
  DisplayLine(Mailer.eStatus,'Connected.');
  {allocate Message, Subject, and Attach pointers}
  GetMem(SubjPtr, 64); StrPCopy(SubjPtr, eSubj.Text);
  MsgSize := Length(eMessage.Text);
  GetMem(MsgPtr, MsgSize+1); StrPCopy(MsgPtr, eMessage.Text);
  GetMem(AttPtr, 64); StrPCopy(AttPtr, eAttach.Text);
  GetMem(NullPtr,4); StrPCopy(NullPtr, '');
  {send the email}
  DisplayLine(Mailer.eStatus,'Sending mail...');
  Code := seeSendEmail(0,ToPtr,NullPtr,NullPtr,SubjPtr,MsgPtr,AttPtr);
  {free buffers}
  FreeMem(ToPtr,64); FreeMem(SubjPtr,64); FreeMem(MsgPtr,MsgSize+1);
  FreeMem(AttPtr,64); FreeMem(NullPtr,4);
  {any errors ?}
  If Code < 0 then
    begin
      DisplayString(Mailer.eStatus,'seeSendEmail: ');
      DisplayError(eMessage, Code);
      mSendMail.Enabled := True;
      SCREEN.Cursor := crDefault;
      seeClose(0);
      exit;
    end;
  {ready to check mail}
  SCREEN.Cursor := crDefault;
  DisplayLine(Mailer.eStatus,'Email has been sent...');
  mSendMail.Enabled := True;
  seeClose(0);
end;

end.
