unit Helo_pgm;

interface

uses
  Display,
  SysUtils, WinTypes, WinProcs, Messages, Classes, Graphics, Controls,
  SEE, KeyCode,
  Forms, Dialogs, Menus, StdCtrls;

type
  THello = class(TForm)
    Menu: TMainMenu;
    mSendEmail: TMenuItem;
    eMessage: TMemo;
    mExit: TMenuItem;
    procedure mSendEmailClick(Sender: TObject);
    procedure mExitClick(Sender: TObject);
  private
    { Private declarations }
  public
    { Public declarations }
  end;

var
  Hello: THello;

implementation

{$R *.DFM}

procedure THello.mSendEmailClick(Sender: TObject);
var
  Code : Integer;
  MsgSize : Integer;
  SmtpServer : String;
  SmtpFrom : String;
  SmtpTo : String;
  SmtpSubject : String;
  SmtpMessage : String;
  ServerPtr : PChar;
  FromPtr : PChar;
  ToPtr : PChar;
  SubjPtr : PChar;
  MsgPtr : PChar;
  NullPtr : PChar;
begin
  {PROGRAMMER: Edit the following 5 lines}
  SmtpServer := '10.0.0.1';
  SmtpFrom := '<mike@10.0.0.1>';
  SmtpTo := '<mike@10.0.0.1>';
  SmtpSubject := 'Test';
  SmtpMessage := 'This is a test message';

  {attach SEE}
  seeAttach(1, SEE_KEY_CODE);
  {prepare parameters}
  GetMem(FromPtr, 64); StrPCopy(FromPtr, SmtpFrom);
  GetMem(ToPtr, 64); StrPCopy(ToPtr, SmtpTo);
  GetMem(ServerPtr, 64); StrPCopy(ServerPtr, SmtpServer);
  GetMem(NullPtr, 4);  StrPCopy(NullPtr, '');
  {connect to POP3 server}
  SCREEN.Cursor := crHourGlass;
  DisplayLine(Hello.eMessage,Format('Connecting to %s',[StrPas(ServerPtr)]));
  Code := seeSmtpConnect(0,ServerPtr, FromPtr, NullPtr);
  {free buffers}
  FreeMem(ServerPtr,64); FreeMem(FromPtr,64);
  {any errors ?}
  If Code < 0 then
    begin
      DisplayString(Hello.eMessage,'seeSmtpConnect: ');
      DisplayError(Hello.eMessage, Code);
      seeClose(0);
      exit;
    end;
  {ready to send mail}
  DisplayLine(Hello.eMessage,'Connected.');
  {allocate Message and Subject pointers}
  GetMem(SubjPtr, 64); StrPCopy(SubjPtr, SmtpSubject);
  MsgSize := Length(SmtpMessage);
  GetMem(MsgPtr, MsgSize+1); StrPCopy(MsgPtr, SmtpMessage);
  {send the email}
  DisplayLine(Hello.eMessage,'Sending mail...');
  Code := seeSendEmail(0,ToPtr,NullPtr,NullPtr,SubjPtr,MsgPtr,NullPtr);
  {free buffers}
  FreeMem(ToPtr,64); FreeMem(SubjPtr,64); FreeMem(MsgPtr,MsgSize+1);
  {any errors ?}
  If Code < 0 then
    begin
      DisplayString(Hello.eMessage, 'SendEmail: ');
      DisplayError(Hello.eMessage, Code);
      SCREEN.Cursor := crDefault;
      seeClose(0);
      exit;
    end;
  SCREEN.Cursor := crDefault;
  DisplayLine(Hello.eMessage,'Email has been sent.');
  seeClose(0);
  seeRelease;
end;

procedure THello.mExitClick(Sender: TObject);
begin
  Application.Terminate;
end;

end.
