unit Display;

interface

uses
  see,
  SysUtils, WinTypes, WinProcs, Messages, Classes, Graphics, Controls,
  Forms, Dialogs, Menus,
  ExtCtrls, StdCtrls;

procedure DisplayChar(Memo: TMemo; TheChar : Char);
procedure DisplayString(Memo: TMemo; Text : String);
procedure DisplayLine(Memo: TMemo; Text : String);
procedure DisplayError(Memo: TMemo; Code : Integer);

implementation

{Display character}

procedure DisplayChar(Memo: TMemo; TheChar : Char);
var
   Count     : Integer;
   TheString : String;
begin
   if TheChar <> Chr(13) then
     {ignore CR}
     begin
       if TheChar = Chr(10) then
         begin
           {create new line}
           Memo.Lines.Add('');
         end
       else
         begin
           {printable chars only}
           if (TheChar<' ') or (TheChar>'~') then TheChar := ' ';
           {append char}
           Count := Memo.Lines.Count;
           TheString := Memo.Lines.Strings[Count-1] + TheChar;
           Memo.Lines.Strings[Count-1] := TheString;
         end
     end
end;

{Display string}

procedure DisplayString(Memo: TMemo; Text : String);
var
  S   : String;
  I   : Integer;
  Len : Integer;
  Count : Integer;
  TheChar : Char;
begin
  Len := Length(Text);
  Count := Memo.Lines.Count;
  S := '';
  for I := 1 to Len do
    begin
      TheChar := Text[I];
      if TheChar <> Chr(13) then
      {ignore CR}
      begin
        if TheChar = Chr(10) then
          begin {is linefeed}
            {update current line}
            if Length(S) > 0 Then
              begin
                S := Memo.Lines.Strings[Count-1] + S;
                Memo.Lines.Strings[Count-1] := S;
              end;
            {create new line}
            Memo.Lines.Add('');
            Inc(Count); S := '';
          end
        else {is NOT linefeed}
          begin
            {printable chars only}
            if (TheChar<' ') or (TheChar>'~') then TheChar := ' ';
            {append char}
            S := S + TheChar;
          end
      end
    end; {end-for}
  if Length(S) > 0 Then
    begin
      {update string}
      S := Memo.Lines.Strings[Count-1] + S;
      Memo.Lines.Strings[Count-1] := S;
    end
end;

{Display String & CRLF}

procedure DisplayLine(Memo: TMemo; Text : String);
begin
  DisplayString(Memo,Text);
  DisplayChar(Memo,Chr(10))
end;

(* Display error text *)

procedure DisplayError(Memo: TMemo; Code : Integer);
var
   Text : String;
   Ptr  : PChar;
begin
  if Code < 0 then
    begin
       GetMem(Ptr, 120);
       Code := seeErrorText(0,Code, Ptr, 120) ;
       DisplayLine(Memo,StrPas(Ptr));
       Text := Format(' SEE error %d.',[Code]);
       FreeMem(Ptr,120);
       DisplayLine(Memo,Text);
    end
end;

(* initialization *)
begin
end.
