unit ULoop;

interface

uses
    Windows,
    Messages,
    SysUtils,
    Variants,
    Classes,
    Graphics,
    Controls,
    Forms,
    Dialogs,
    StdCtrls,
    ExtCtrls,
    ComCtrls,
    IniFiles;

type
    TFLoop = class(TForm)
        Timer1: TTimer;
        ListBox1: TListBox;
        Timer2: TTimer;
        LBLVel: TLabel;
        ListBox2: TListBox;
        Timer4: TTimer;
        Timer5: TTimer;
        Timer3: TTimer;
        Box: TListBox;
        Programas: TLabel;
        SEN: TTrackBar;
        Label1: TLabel;
        Label2: TLabel;
        Label3: TLabel;
        DIS: TTrackBar;
        Label4: TLabel;
        Label6: TLabel;
        Distancia: TLabel;
        Button1: TButton;
        Label7: TLabel;
        Label8: TLabel;
        Label9: TLabel;
        Label10: TLabel;
        Label11: TLabel;
        procedure Timer1Timer(Sender: TObject);
        procedure Timer2Timer(Sender: TObject);
        procedure FormCreate(Sender: TObject);
        procedure Timer4Timer(Sender: TObject);
        procedure Timer5Timer(Sender: TObject);
        procedure Timer3Timer(Sender: TObject);
        procedure SENChange(Sender: TObject);
        procedure DISChange(Sender: TObject);
        procedure Button1Click(Sender: TObject);

    private
      { Private declarations }
    public
      { Public declarations }
    end;

var
    FLoop      : TFLoop;
    Espaco     : Integer; // em pixel
    Sensi      : Integer; // em milisegundos
    JanelaAtu  : integer;
    JanelaAnt  : integer;
    POSIA      : Integer;
    POSID      : Integer;
    QuantiAtu  : Integer;
    QuantiAnt  : Integer;
    Entrou     : Boolean;

    VELOPOSI   : Integer; // VELOCIDADE DE REPOSICIONAMENTO

implementation

{$R *.dfm}

procedure TFLoop.Timer1Timer(Sender: TObject);
label
    Sai;
var
    pt         : TPoint;
    tmHandle   : THandle;
    tmHandle2  : THandle;
    tmRect     : TRect;
    tmRect2    : TRect;
    i, f, tmAltura, tmLargura, tmNovoLeft, tmNovoLeftAnt, tmNovoTop: Integer;
    tmAltura2, tmLargura2, tmNovoLeft2, tmNovoTop2: Integer;

begin
    GetCursorPos(pt);
    if pt.y > 0 then
        LBLVel.caption := IntToStr((pt.y div 10));

    if (pt.x > 0) and (pt.x < (Screen.Width - 2)) then
        Entrou := False; //

   /////// encostando em uns dos lado da tela
    if (pt.x = 0) or (pt.x >= (Screen.Width - 2)) then begin

        for f := 0 to (ListBox1.Items.Count - 1) do begin

            tmHandle := StrToInt(ListBox2.items[f]);

            if tmHandle > 0 then begin

                if pt.x = 0 then begin

                    if Entrou = False then
                        Sleep(Sensi); ///////// sensibilidade
                    begin
                        GetCursorPos(pt);
                        if (pt.x <> 0) then begin
                            goto Sai;
                        end;
                        GetCursorPos(pt);
                        if (pt.x = 0) then begin
                            Entrou := True;
                        end;
                    end; ///////////////////////////////////// sensibilidade

                    GetWindowRect(tmHandle, tmRect);
                    tmNovoTop := tmRect.Top;
                    tmNovoLeft := tmRect.Left +
                        StrToInt(LBLVel.Caption);
                    MoveWindow(tmHandle, tmNovoLeft, tmNovoTop,
                        tmRect.Right - tmRect.Left,
                        tmRect.Bottom - tmRect.Top, True);

                    if f = 0 then {// a ultima janela passou no fim da tela} begin
                        if tmNovoLeft >= 1023 then begin

                            for i := ListBox2.Items.Count
                                - 1 downto (0) do begin
                                tmHandle := StrToInt(ListBox2.items[i]);
                                GetWindowRect(tmHandle, tmRect);
                                tmLargura := tmRect.Right - tmRect.Left;
                                tmNovoTop :=
                                    tmRect.Top;
                                tmNovoLeft := (tmNovoLeftAnt - (tmLargura + Espaco));

                                if i = ListBox2.Items.Count - 1 then begin
                                    tmNovoLeft := 0 - tmLargura;
                                end;

                                MoveWindow(tmHandle,
                                    tmNovoLeft,
                                    tmNovoTop,
                                    tmRect.Right -
                                    tmRect.Left,
                                    tmRect.Bottom -
                                    tmRect.Top,
                                    true);
                                tmNovoLeftAnt := tmNovoLeft
                            end;

                        end;
                    end;
                end;

                if pt.x >= (Screen.Width - 2) then begin

                    if Entrou = False then
                        Sleep(Sensi); ///////// sensibilidade
                    begin
                        GetCursorPos(pt);
                        if (pt.x <= (Screen.Width - 2)) then begin
                            goto Sai;
                        end;
                        GetCursorPos(pt);
                        if (pt.x >= (Screen.Width - 2)) then begin
                            Entrou := True;
                        end;
                    end; ///////////////////////////////////// sensibilidade

                    GetWindowRect(tmHandle, tmRect);
                    tmLargura := tmRect.Right - tmRect.Left;
                    tmNovoTop := tmRect.Top;
                    tmNovoLeft := tmRect.Left -
                        StrToInt(LBLVel.Caption);
                    MoveWindow(tmHandle, tmNovoLeft, tmNovoTop,
                        tmRect.Right - tmRect.Left,
                        tmRect.Bottom - tmRect.Top, True);

                    if f = ListBox2.Items.Count - 1 then
                    {// a primeira janela passou no comeco da tela}begin
                        if tmNovoLeft + tmLargura <= 0 then begin

                            for i := 0 to
                                (ListBox2.Items.Count - 1) do begin
                                tmHandle :=
                                    StrToInt(ListBox2.items[i]);
                                GetWindowRect(tmHandle, tmRect);
                                tmLargura :=
                                    tmRect.Right -
                                    tmRect.Left;
                                tmNovoTop :=
                                    tmRect.Top;
                                tmNovoLeft := (tmNovoLeftAnt + (tmLargura -  Espaco));

                                if i = 0 then begin
                                   tmNovoLeft := Screen.Width;
                                end;

                                MoveWindow(tmHandle,
                                    tmNovoLeft,
                                    tmNovoTop,
                                    tmRect.Right -
                                    tmRect.Left,
                                    tmRect.Bottom -
                                    tmRect.Top,
                                    True);
                                tmNovoLeftAnt := tmNovoLeft
                            end;

                        end;
                    end;
                end;
            end;
        end;
    end;
    Sai:
end;

function EnumWindowsProc(Wnd: HWND; lb: TListbox): BOOL; stdcall;
var
    caption    : array[0..128] of Char;
    Teste      : PChar;
    Buffer     : array[0..99] of char;
    Buffer2    : array[0..99] of char;
    tmRect     : TRect;
begin
    Result := True;

    if IsWindowEnabled(wnd) and IsWindowVisible(Wnd) and ((GetWindowLong(Wnd,
        GWL_HWNDPARENT) = 0) or
        (HWND(GetWindowLong(Wnd, GWL_HWNDPARENT)) = GetDesktopWindow))
        and ((GetWindowLong(Wnd, GWL_EXSTYLE) and GWL_STYLE and WS_EX_TOOLWINDOW)
        = 0) then begin
        if not IsIconic(wnd) then begin
            GetWindowRect(wnd, tmRect);
            GetWindowText(wnd, Buffer, 100);
            GetProp(wnd, Buffer2);
            if (tmRect.Left > 0) and (tmRect.Top > 0) and (tmRect.Right
                > 0) and (tmRect.Bottom > 0)
                and (tmRect.Left < 1200) and (tmRect.Top > 800) and
                (tmRect.Right > 0) and (tmRect.Bottom > 0)
                and (Length(StrPas(Buffer2)) > 0) or
                (Length(StrPas(Buffer)) > 0) then begin

                SendMessage(Wnd, WM_GETTEXT, Sizeof(caption),
                    integer(@caption));
            //lb.Items.AddObject( caption, TObject( Wnd ));
                lb.Items.Add(inttostr(wnd))

            end;
        end;
    end;

end;

function EnumWindowsProc2(Wnd: HWND; lb: TListbox): BOOL; stdcall;
var
    caption    : array[0..128] of Char;
    Teste      : PChar;
    Buffer     : array[0..99] of char;
    Buffer2    : array[0..99] of char;
    tmRect     : TRect;
begin
    Result := True;

    if IsWindowEnabled(wnd) and IsWindowVisible(Wnd) and ((GetWindowLong(Wnd,
        GWL_HWNDPARENT) = 0) or
        (HWND(GetWindowLong(Wnd, GWL_HWNDPARENT)) = GetDesktopWindow))
        and ((GetWindowLong(Wnd, GWL_EXSTYLE) and GWL_STYLE and WS_EX_TOOLWINDOW)
        = 0) then begin
        if not IsIconic(wnd) then begin
            GetWindowRect(wnd, tmRect);
            GetWindowText(wnd, Buffer, 100);
            GetProp(wnd, Buffer2);
            if (tmRect.Left > 0) and (tmRect.Top > 0) and (tmRect.Right
                > 0) and (tmRect.Bottom > 0)
                and (tmRect.Left < 1200) and (tmRect.Top > 800) and
                (tmRect.Right > 0) and (tmRect.Bottom > 0)
                and (Length(StrPas(Buffer2)) > 0) or
                (Length(StrPas(Buffer)) > 0) then begin

                SendMessage(Wnd, WM_GETTEXT, Sizeof(caption),
                    integer(@caption));
                lb.Items.AddObject(caption, TObject(Wnd));
            //lb.Items.Add(inttostr(wnd))

            end;
        end;
    end;
end;

procedure TFLoop.Timer2Timer(Sender: TObject);
label
    Fim, Comeca, FimDelete;
var
    f, i, t    : Integer;
begin
    ListBox1.clear;
    box.Clear;
    EnumWindows(@EnumWindowsProc, integer(ListBox1));
    EnumWindows(@EnumWindowsProc2, integer(Box));
   // carrega os programas que estao rodando

    for f := 0 to (ListBox1.Items.Count - 1) do begin
        for i := 0 to (ListBox2.Items.Count - 1) do begin
            if ListBox1.items[f] = ListBox2.items[i] then begin
                t := 1;
                goto Fim;
            end;
        end;
        t := 0;
        Fim:
        if t = 0 then begin
            ListBox2.Items.add(ListBox1.items[f]);
        end;
    end;

    Comeca:
    for i := 0 to (ListBox2.Items.Count - 1) do begin
        for f := 0 to (ListBox1.Items.Count - 1) do begin
            if ListBox1.items[f] = ListBox2.items[i] then begin
                t := 1; ////achei
                goto FimDelete;
            end;
        end;
        t := 0; /// nao achei

        FimDelete:
        if t = 0 then begin
            ListBox2.Items.Delete(i);
            goto Comeca
        end;
    end;

end; //////fim timer2

procedure TFLoop.FormCreate(Sender: TObject);
var
    ret        : Integer;
    Ini        : TIniFile;
begin
    Ini := TIniFile.Create(ChangeFileExt(ExtractFilePath(ParamStr(0)) + '\' +
        ExtractFileName(ParamStr(0)), '.INI'));
    try
        Sensi := Ini.ReadInteger('CONFIG', 'SENSI', 200);
        LABEL1.Caption := IntToStr(Sensi);
        SEN.Position := Sensi;

        Espaco := Ini.ReadInteger('CONFIG', 'DISTA', 50);
        LABEL4.Caption := IntToStr(Espaco);
        DIS.Position := Espaco;

    finally
        Ini.Free;
    end;

    VELOPOSI := 80
end;

procedure TFLoop.Timer4Timer(Sender: TObject);
var
    tmHandle   : THandle;
    tmRect     : TRect;
    i, f, tmAltura, tmLargura, tmNovoLeft, tmNovoLeftAnt, tmNovoTop, LeftCC,
        TopCC  : Integer;
    cNome      : string;
begin
    if ListBox1.items.Count <> 0 then begin

        JanelaAtu := Strtoint(ListBox1.Items[0]);
        if JanelaAtu <> JanelaAnt then begin
         ///////////mudou de janela
         // aonde esta a janela atual? da metade para direita ou da
         // metade para esquerda ?
            tmHandle := JanelaAtu;
            GetWindowRect(tmHandle, tmRect);
            tmAltura := tmRect.Bottom - tmRect.Top;
            tmLargura := tmRect.Right - tmRect.Left;
            POSIA := tmRect.Left;
            POSID := (Screen.Width div 2) - (tmLargura div 2);

            if POSIA < (Screen.Height div 2) then begin
                while POSID >= POSIA do begin

                    if POSIA >= (POSID - 80) then
                        VELOPOSI := 1
                    else
                        VELOPOSI := 80;

                    for i := 0 to (ListBox2.Items.Count - 1) do begin
                        tmHandle :=
                            StrToInt(ListBox2.items[i]);
                        GetWindowRect(tmHandle, tmRect);
                        tmAltura := tmRect.Bottom - tmRect.Top;
                        tmLargura := tmRect.Right - tmRect.Left;
                        tmNovoTop := tmRect.Top;
                        tmNovoLeft := tmRect.Left + VELOPOSI;
                        MoveWindow(tmHandle, tmNovoLeft, tmNovoTop, tmRect.Right
                        - tmRect.Left, tmRect.Bottom - tmRect.Top, True);
//                     SetWindowPos(tmHandle,0,tmNovoLeft,tmNovoTop,tmRect.Right-tmRect.Left, tmRect.Bottom-tmRect.Top, 0 );
                        tmNovoLeftAnt := tmNovoLeft;
                    end;
                    POSIA := POSIA + VELOPOSI
                end;
            end;
            if POSIA > (Screen.Height div 2) then begin

                while POSID <= POSIA do begin

                    if POSIA <= (POSID + 80) then
                        VELOPOSI := 1
                    else
                        VELOPOSI := 80;

                    for i := 0 to (ListBox2.Items.Count - 1) do begin
                        tmHandle :=
                            StrToInt(ListBox2.items[i]);
                        GetWindowRect(tmHandle, tmRect);
                        tmAltura := tmRect.Bottom -
                            tmRect.Top;
                        tmLargura := tmRect.Right -
                            tmRect.Left;
                        tmNovoTop := tmRect.Top;
                        tmNovoLeft := tmRect.Left -
                            VELOPOSI;
                        MoveWindow(tmHandle, tmNovoLeft,
                            tmNovoTop, tmRect.Right -
                            tmRect.Left,
                            tmRect.Bottom - tmRect.Top,
                            True);
                        tmNovoLeftAnt := tmNovoLeft
                    end;
                    POSIA := POSIA - VELOPOSI
                end;
            end;
        end;
        JanelaAnt := JanelaAtu;
    end;
end;

procedure TFLoop.Timer5Timer(Sender: TObject);
begin
   ////////  entrou janela nova ou saiu
    QuantiAtu := ListBox1.Items.Count;
    if QuantiAtu <> QuantiAnt then begin
        Timer3.Interval := 1;
    end;
    QuantiAnt := QuantiAtu
end;

procedure TFLoop.Timer3Timer(Sender: TObject);
var
    tmHandle   : THandle;
    tmRect     : TRect;
    i, f, tmAltura, tmLargura, tmNovoLeft, tmNovoLeftAnt, tmNovoTop, LeftCC,
        TopCC  : Integer;
    cNome      : string;
begin
    Sleep(1);
   //   posicionado todas as janelas em fila centraliza a primeira
   //   da ultima aberta ate a primeira da direita para esquerda
    if ListBox2.Items.Count - 1 > -1 then begin
        for i := (ListBox2.Items.Count - 1) downto 0 do begin
            tmHandle := StrToInt(ListBox2.items[i]);
            GetWindowRect(tmHandle, tmRect);
            tmAltura := tmRect.Bottom - tmRect.Top;
            tmLargura := tmRect.Right - tmRect.Left;
            tmNovoTop := tmRect.Top;
            tmNovoLeft := (tmNovoLeftAnt - (tmLargura + Espaco));

            if i = ListBox2.Items.Count - 1 then begin
                tmNovoLeft := (Screen.Width div 2) - (tmLargura div
                    2);
            end;

            MoveWindow(tmHandle, tmNovoLeft, tmNovoTop, tmRect.Right -
                tmRect.Left,
                tmRect.Bottom - tmRect.Top, True);
            tmNovoLeftAnt := tmNovoLeft
        end;
    end;
    Timer4.interval := 300;
    Timer3.interval := 0;
end;

procedure TFLoop.SENChange(Sender: TObject);
begin
    label1.Caption := IntToStr(SEN.Position)
end;

procedure TFLoop.DISChange(Sender: TObject);
begin
    label4.Caption := IntToStr(DIS.Position)
end;

procedure TFLoop.Button1Click(Sender: TObject);
var
    ret        : Integer;
    Ini        : TIniFile;
begin
    Ini := TIniFile.Create(ChangeFileExt(ExtractFilePath(ParamStr(0)) + '\' +
        ExtractFileName(ParamStr(0)), '.INI'));
    try
        Ini.WriteInteger('CONFIG', 'SENSI', SEN.Position);
        Ini.WriteInteger('CONFIG', 'DISTA', DIS.Position);
        Sensi := Ini.ReadInteger('CONFIG', 'SENSI', 200);
        Espaco := Ini.ReadInteger('CONFIG', 'DISTA', 50);
    finally
        Ini.Free;
    end;

end;

end.

