{
--------------------------------------------------------------------------------

Component Name: TDLBox
Author: Mats Asplund
Creation: June 14, 2000
Version: 1.2
Description:  TDLBox is a component for downloading files into your computer
              from any given source.
Credit:       Thomas Quester for the Compound-class used in this component.
EMail:        mats.asplund@telia.com
Site:         http://w1.545.telia.com/~u54503556/delphi/mdp.htm
Legal issues: Copyright (C) 2000 by Mats Asplund
              This software is provided 'as-is', without any express or
              implied warranty.  In no event will the author be held liable
              for any  damages arising from the use of this software.

              Permission is granted to anyone to use this software for any
              purpose, including commercial applications, and to alter it
              and redistribute it freely, subject to the following
              restrictions:

              1. The origin of this software must not be misrepresented,
                 you must not claim that you wrote the original software.
                 If you use this software in a product, an acknowledgment
                 in the product documentation would be appreciated but is
                 not required.

              2. Altered source versions must be plainly marked as such, and
                 must not be misrepresented as being the original software.

              3. This notice may not be removed or altered from any source
                 distribution.

              4. If you decide to use this software in any of your applications.
                 Send me an EMail address and tell me about it.

Quick Reference:
              TDLBox is a descendant from TCompoundGroupBox.

              Published properties:
              Caption1:        Sets string for label1.
              Caption2:        Sets string for label2.
              Caption3:        Sets string for label3.
              Image:           Sets the bitmap on top of the component.
              Glyph:           Sets the glyph on the BitBtn.
              Directory:       Read or write to this property to retrieve or
                               change selected directory.
              Drive:           Read or write to this property to retrieve or
                               change selected drive.
              DriveBoxEnabled  Enables DriveBox.
              DirBoxEnabled    Enables DirectoryListBox.
              FileBoxEnabled   Enables FileListBox.
              BitBtnEnabled:   Enables BitBtn.
              BitBtnVisible:   Makes BitBtn visible.
              DriveBoxVisible: Makes DriveBox visible.

              Event:
              BitBtnOnClick: event raised when BitBtn is clicked.

              Method:
              UpdateFileList: call this to update the FileList.
              UpdateDirList:  call this to update the DirectoryList.

--------------------------------------------------------------------------------
}
unit dlbox;

interface

uses
  Windows, Messages, SysUtils, Classes, Graphics, Controls, Forms, Dialogs,
  StdCtrls, Buttons, FileCtrl, ExtCtrls, Compound;

type
  TMForm = class(TForm)
    Image1: TImage;
    Label1: TLabel;
    DLBox: TDirectoryListBox;
    FLBox: TFileListBox;
    Edit1: TEdit;
    Label2: TLabel;
    BBtn1: TBitBtn;
    DriveBox: TDriveComboBox;
    Timer1: TTimer;
    procedure DLBoxChange(Sender: TObject);
    procedure Timer1Timer(Sender: TObject);
  private
    { Private declarations }
  public
    { Public declarations }
  end;

  TDLBox = class(TCompoundGroupBox)
  private
    FForm : TMForm;
    FCop: string;
    procedure SetCap1(Value: string);
    procedure SetCap2(Value: string);
    procedure SetCap3(Value: string);
    procedure SetImage(Value: TBitmap);
    procedure SetGlyph(Value: TBitmap);
    procedure SetDir(Value: string);
    procedure SetBBOnClick(Value: TNotifyEvent);
    procedure SetDrive(Value: Char);
    procedure SetDBEnabled(Value: boolean);
    procedure SetDLBEnabled(Value: boolean);
    procedure SetFBEnabled(Value: boolean);
    procedure SetBBEnabled(Value: boolean);
    procedure SetBBVisible(Value: boolean);
    procedure SetDriveBoxVisible(Value: boolean);
    procedure SetCop(Value: string);
    function GetCap1: string;
    function GetCap2: string;
    function GetCap3: string;
    function GetImage: TBitmap;
    function GetGlyph: TBitmap;
    function GetDir: string;
    function GetBBOnClick: TNotifyEvent;
    function GetDrive: Char;
    function GetDBEnabled: boolean;
    function GetDLBEnabled: boolean;
    function GetFBEnabled: boolean;
    function GetBBEnabled: boolean;
    function GetBBVisible: boolean;
    function GetDriveBoxVisible: boolean;
  protected
  public
    constructor Create(AOwner : TComponent ); override;
    property Form : TMForm read FForm;
    function UpdateFileList: boolean;
    function UpdateDirList: boolean;
  published
    property Caption1: string read GetCap1 write SetCap1;
    property Caption2: string read GetCap2 write SetCap2;
    property Caption3: string read GetCap3 write SetCap3;
    property Image: TBitmap read GetImage write SetImage;
    property Glyph: TBitmap read GetGlyph write SetGlyph;
    property Directory: string read GetDir write SetDir;
    property BitBtnOnClick: TNotifyEvent read GetBBOnClick write SetBBOnClick;
    property DriveBoxEnabled: boolean read GetDBEnabled write SetDBEnabled;
    property DirBoxEnabled: boolean read GetDLBEnabled write SetDLBEnabled;
    property FileBoxEnabled: boolean read GetFBEnabled write SetFBEnabled;
    property BitBtnEnabled: boolean read GetBBEnabled write SetBBEnabled;
    property BitBtnVisible: boolean read GetBBVisible write SetBBVisible default true;
    property Drive: char read GetDrive write SetDrive;
    property DriveBoxVisible: boolean read GetDriveBoxVisible write SetDriveBoxVisible default true;
    property Copyright: string read FCop write SetCop;
  end;

var
  MForm: TMForm;

procedure Register;

implementation
{$R *.DFM}

constructor TDLBox.Create(AOwner : TComponent );
begin
  inherited Create(AOwner);
  FForm := MoveControls(TMForm.Create(NIL));
  FCop:='2000 (C), Mats Asplund/MAs Prod.';
  Form.Timer1.Enabled:=true;
end;

procedure Register;
begin
   RegisterComponents('MAs Prod.',[TDLBox]);
end;

procedure TMForm.DLBoxChange(Sender: TObject);
begin
  if (DLBox.Directory = 'A:\') or (DLBox.Directory = 'B:\') or
    (DLBox.Directory = 'C:\') or (DLBox.Directory = 'D:\') or
    (DLBox.Directory = 'E:\') then
  begin
    Edit1.Text:=DlBox.Directory;
    Exit;
  end;
  Edit1.Text:=DlBox.Directory+'\';
end;

function TDLBox.GetBBEnabled: boolean;
begin
  Result:=Form.BBtn1.Enabled;
end;

function TDLBox.GetBBOnClick: TNotifyEvent;
begin
  Result:=Form.BBtn1.OnClick;
end;

function TDLBox.GetBBVisible: boolean;
begin
  Result:=Form.BBtn1.Visible;
end;

function TDLBox.GetCap1: string;
begin
  Result:=Form.Label1.caption;
end;

function TDLBox.GetCap2: string;
begin
  Result:=Form.Label2.caption;
end;

function TDLBox.GetCap3: string;
begin
  Result:=Form.BBtn1.Caption;
end;

function TDLBox.GetDBEnabled: boolean;
begin
  Result:=Form.DriveBox.Enabled;
end;

function TDLBox.GetDir: string;
begin
  if Form.DLBox.Directory = 'A:\' then
  begin
    Result:='A:\';
    Exit;
  end;
  if Form.DLBox.Directory = 'B:\' then
  begin
    Result:='B:\';
    Exit;
  end;
  if Form.DLBox.Directory = 'C:\' then
  begin
    Result:='C:\';
    Exit;
  end;
  if Form.DLBox.Directory = 'D:\' then
  begin
    Result:='D:\';
    Exit;
  end;
  if Form.DLBox.Directory = 'E:\' then
  begin
    Result:='E:\';
    Exit;
  end;

  Result:= Form.DLBox.Directory+'\';
end;

function TDLBox.GetDLBEnabled: boolean;
begin
  Result:=Form.DLBox.Enabled;
end;

function TDLBox.GetDrive: Char;
begin
  Result:=Form.DriveBox.Drive;
end;

function TDLBox.GetDriveBoxVisible: boolean;
begin
  Result:=Form.DriveBox.Visible;
end;

function TDLBox.GetFBEnabled: boolean;
begin
  Result:=Form.FLBox.Enabled;
end;

function TDLBox.GetGlyph: TBitmap;
begin
  Result:=Form.BBtn1.Glyph;
end;

function TDLBox.GetImage: TBitmap;
begin
  Result:=Form.Image1.Picture.Bitmap;
end;

procedure TDLBox.SetBBEnabled(Value: boolean);
begin
  Form.BBtn1.Enabled:= Value;
end;

procedure TDLBox.SetBBOnClick(Value: TNotifyEvent);
begin
  Form.BBtn1.OnClick:= Value;
end;

procedure TDLBox.SetBBVisible(Value: boolean);
begin
  Form.BBtn1.Visible:= Value;
end;

procedure TDLBox.SetCap1(Value: string);
begin
  Form.Label1.Caption:= Value;
end;

procedure TDLBox.SetCap2(Value: string);
begin
  Form.Label2.Caption:= Value;
end;

procedure TDLBox.SetCap3(Value: string);
begin
  Form.BBtn1.Caption:= Value;
end;

procedure TDLBox.SetCop(Value: string);
begin
  FCop:=FCop;
end;

procedure TDLBox.SetDBEnabled(Value: boolean);
begin
  Form.DriveBox.Enabled:=Value;
end;

procedure TDLBox.SetDir(Value: string);
begin
  Form.DLBox.Directory:= Value;
end;

procedure TDLBox.SetDLBEnabled(Value: boolean);
begin
  Form.DLBox.Enabled:=Value;
end;

procedure TDLBox.SetDrive(Value: Char);
begin
  Form.DriveBox.Drive:= Value;
end;

procedure TDLBox.SetDriveBoxVisible(Value: boolean);
begin
  Form.DriveBox.Visible:= Value;
end;

procedure TDLBox.SetFBEnabled(Value: boolean);
begin
  Form.FLBox.Enabled:=Value;
end;

procedure TDLBox.SetGlyph(Value: TBitmap);
begin
  Form.BBtn1.Glyph:= Value;
end;

procedure TDLBox.SetImage(Value: TBitmap);
begin
  Form.Image1.Picture.Bitmap:= Value;
end;

function TDLBox.UpdateDirList: boolean;
begin
  Form.DLBox.Update;
  Result:=true;
end;

function TDLBox.UpdateFileList: boolean;
begin
  Form.FLBox.Update;
  Result:=true;
end;

procedure TMForm.Timer1Timer(Sender: TObject);
begin
  Timer1.Enabled:=false;
  DLBox.Directory:='C:\';
  Edit1.Text:='C:\';
end;

end.
