unit Compound;

(*
   Created 21.7.1998 by:Thomas Quester

       Email : thomas.quester@hamburg.netsurf.de
       Homepage: http://members.tripod.com/~Arabella_fairy

   This component is put to the public domain. Professional use allowed.

   Compound.pas is tested with Delphi 1 and 3, but I do not see any ping
   this with Delphi 2, Delphi 4 or C++ Builder.

   To create a new compound component, simply create a new component with baseclass
   TCompoundPanel (alternativly TCompoundScrollBox, TCompoundGroupBox)
   and inherit the creator to call MoveControls.

   If you want to see any child properties that are declared in the form, you can
   write a property for in the unit where you inherited TCompoundPanel.

   For Example

   TMyComponent = class(TCompoundPanel)
   public
     FForm : TMyForm;
     function GetTableActive : boolen;
     procedure SetTableActive(value : boolean);
     constructor Create(AOwner : TComponent);
   published
     property TableActive : boolean read GetTableActive write SetTableActive;
   end;

   implementation

   constructor TMyComponent.Create(AOwner : TComponent);
   begin
      inherited Create(AOwner);
      form := MoveControls(TMyForm.Create(NIL));
   end;

   function TMyComponent.GetTableActive : boolean;
   begin
     result := form.Table1.Active;
   end;

   procedure MyComponent.SetTableActive(value : boolean);
   begin
     form.Table1.Active := value;
   end;

   If you do not want your component to run inside the IDE, simply change the
   line
     TMyForm = class(TForm)
   to
     TMyForm = class(TCompoundForm)



   To automatically create properties, I recommand using Arabella, wich also adds
   a lot of useful features to Delphi 3.

   You find Arabella and the latest version of this component at:
   http://members.tripod.com/~Arabella_fairy

*)

interface
uses  extctrls, forms, classes, controls, messages, stdctrls;


type

 TCompoundForm = class(TForm)
    Procedure SetDesignMode(value : boolean );
   end;

 TCompoundPanel = class(TPanel)
   private
       FForm : TForm;
      FfirstRun:boolean;
   public
       Destructor Destroy; override;
       Function MoveControls(form : TForm):pointer ;
       {$IFNDEF VER80}
       Procedure OnWMPaint(var message : TWMPaint); message WM_PAINT;
       Procedure OnWMDestroy(var message : TMessage); message WM_DESTROY;
       {$ENDIF}
 end;

 TCompoundGroupBox = class(TGroupBox)
   private
       FForm : TForm;
      FfirstRun:boolean;
   public
       Destructor Destroy; override;
       Function MoveControls(form : TForm):pointer ;
       {$IFNDEF VER80}
       Procedure OnWMPaint(var message : TWMPaint); message WM_PAINT;
       Procedure OnWMDestroy(var message : TMessage); message WM_DESTROY;
       {$ENDIF}
 end;

 TCompoundScrollBox = class(TScrollBox)
    Private
       FForm : TForm;
       FfirstRun:boolean;
   public
       Destructor Destroy; override;
       Function   MoveControls(form : TForm):pointer ;
       {$IFNDEF VER80}
       Procedure  OnWMPaint(var message : TWMPaint); message WM_PAINT;
       Procedure  OnWMDestroy(var message : TMessage); message WM_DESTROY;
       {$ENDIF}
   end;

implementation

(*
// ------------------------------------------------------------------------
// procedure TCompoundForm SetDesignMode(value : boolean )
// Created : sadfsadfsdafsadf 18.07.98 23:26:51
//
// Parameters:
// value :
//
// Description:
// Sets the csDesigning
// ------------------------------------------------------------------------
*)

Procedure TCompoundForm.SetDesignMode(value : boolean );
begin
  SetDesigning(value);
end;


(*
// ------------------------------------------------------------------------
// procedure TMyFormTestComponent Destroy
// Created : Thomas Quester  05.07.98
//
// Description:
// If the component dies, we have to kill the form as well
// ------------------------------------------------------------------------
*)

Destructor TCompoundPanel.Destroy;
begin
  inherited Destroy;
  FForm.Destroy;
end;



(*
// ------------------------------------------------------------------------
// function TCompoundPanel MoveControls(form : TForm)
// Created : sadfsadfsdafsadf 18.07.98 23:30:49
//
// Parameters:
// form : The form that holds the components that will be displayed in the component
//
// Description:
// The trick is: We create a the form just as normal with a Create(NIL).
// The form and all its components are created by Delphi, but they are
// invisible.
// To make them visible in our compound component, we go through the
// component array, and set all parents that point to the form itself
// to our self (eg the panel that makes the compound component).
// We do not set the parent from controls that are in a panel or something,
// because if we "moved" the panel, the childs are moved as well.
// ------------------------------------------------------------------------
*)
function TCompoundPanel.MoveControls(form : TForm) : pointer;
Var i : integer;
Begin
     If form is TcompoundForm then TcompoundForm(form).SetDesignMode(csDesigning in ComponentState);
     result := form;
     FForm := form;
     Width := form.width;
     Height :=  form.height;
     caption := '';
     for i := 0 to FForm.ComponentCount-1 do
          if (FForm.Components[i] is TControl) and (TControl(FForm.Components[i]).parent = FForm) then
               TControl(FForm.Components[i]).parent := self;
End;


{$IFNDEF VER80}
Procedure TCompoundPanel.OnWMPaint(var message : TWMPaint);
begin
  inherited;
  if FfirstRun then begin
     if Assigned(FForm.OnShow) then FForm.OnShow(self);
     FFirstRun := FALSE;
  end;
end;


Procedure TCompoundPanel.OnWMDestroy(var message : TMessage);
var r : TCloseAction;
begin
  inherited;
  if Assigned(FForm.OnClose) then FForm.OnClose(self,r);
end;
{$ENDIF}

(*
// The same code without comments and with TScrollBox as a base class
// To create your own compound container, simply copy the 37 lines here and modify the class name
*)

Destructor TCompoundScrollBox.Destroy;
begin
  inherited Destroy;
  FForm.Destroy;
end;

function TCompoundScrollBox.MoveControls(form : TForm) : pointer;
Var i : integer;
Begin
     If form is TcompoundForm then TcompoundForm(form).SetDesignMode(csDesigning in ComponentState);
     result := form;
     FForm := form;
     Width := form.width;
     Height :=  form.height;
     caption := '';
     for i := 0 to FForm.ComponentCount-1 do
          if (FForm.Components[i] is TControl) and (TControl(FForm.Components[i]).parent = FForm) then
               TControl(FForm.Components[i]).parent := self;
End;

{$IFNDEF VER80}
Procedure TCompoundScrollBox.OnWMPaint(var message : TWMPaint);
begin
  inherited;
  if FfirstRun then begin
     if Assigned(FForm.OnShow) then FForm.OnShow(self);
     FFirstRun := FALSE;
  end;
end;


Procedure TCompoundScrollBox.OnWMDestroy(var message : TMessage);
var r : TCloseAction;
begin
  inherited;
  if Assigned(FForm.OnClose) then FForm.OnClose(self,r);
end;
{$ENDIF}
Destructor TCompoundGroupBox.Destroy;
begin
  inherited Destroy;
  FForm.Destroy;
end;

function TCompoundGroupBox.MoveControls(form : TForm) : pointer;
Var i : integer;
Begin
     If form is TcompoundForm then TcompoundForm(form).SetDesignMode(csDesigning in ComponentState);
     result := form;
     FForm := form;
     Width := form.width;
     Height :=  form.height;
     for i := 0 to FForm.ComponentCount-1 do
          if (FForm.Components[i] is TControl) and (TControl(FForm.Components[i]).parent = FForm) then
               TControl(FForm.Components[i]).parent := self;
End;

{$IFNDEF VER80}
Procedure TCompoundGroupBox.OnWMPaint(var message : TWMPaint);
begin
  inherited;
  if FfirstRun then begin
     if Assigned(FForm.OnShow) then FForm.OnShow(self);
     FFirstRun := FALSE;
  end;
end;


Procedure TCompoundGroupBox.OnWMDestroy(var message : TMessage);
var r : TCloseAction;
begin
  inherited;
  if Assigned(FForm.OnClose) then FForm.OnClose(self,r);
end;
{$ENDIF}


end.

















