unit UCopia;

interface

uses
  Windows, Messages, SysUtils, Classes, Graphics, Controls, Forms, Dialogs,
  StdCtrls, Buttons, FileCtrl, ExtCtrls, ShellApi, ComCtrls;

type
  TForm1 = class(TForm)
    Label1: TLabel;
    FileListBox1: TFileListBox;
    Label2: TLabel;
    Edit1: TEdit;
    BitBtn1: TBitBtn;
    BitBtn2: TBitBtn;
    Op: TOpenDialog;
    Label3: TLabel;
    BitBtn3: TBitBtn;
    Bevel1: TBevel;
    ProgressBar1: TProgressBar;
    procedure BitBtn1Click(Sender: TObject);
    procedure BitBtn3Click(Sender: TObject);
    procedure FormShow(Sender: TObject);
    procedure BitBtn2Click(Sender: TObject);
    procedure CopiarArquivo(const NomeArquivo, NovoDiretorio : string);
  private
    { Private declarations }
  public
    { Public declarations }
  end;

var
  Form1: TForm1;
  cont:integer;
  cam: string;

implementation

{$R *.DFM}

procedure TForm1.BitBtn1Click(Sender: TObject);
begin
if op.execute then
begin
  cam:=ExtractFilePath(op.FileName);
  Label3.Caption:=cam;
  FileListBox1.Directory:=cam;
  Edit1.Enabled:=true;
  BitBtn2.Enabled:=true;
end;
end;

procedure TForm1.BitBtn3Click(Sender: TObject);
begin
FileListBox1.Clear;
Edit1.Enabled:=false;
BitBtn2.Enabled:=false;
Label3.Caption:='';
end;

procedure TForm1.FormShow(Sender: TObject);
begin
FileListBox1.Clear;
Edit1.Enabled:=false;
BitBtn2.Enabled:=false;
end;

procedure TForm1.BitBtn2Click(Sender: TObject);
var
dest:String;
begin
  if DirectoryExists(Edit1.Text)=false then
  begin
   if messagedlg('Pasta no existe, deseja criar?',mtInformation,[mbYes,mbNo],0)=mrYes then
   begin
    CreateDir(Edit1.Text);
    Showmessage('Pasta '+Edit1.text+' foi criada!');
    exit;
   end;
  end
  else
   begin
   Dest:=Edit1.Text;
   if dest[length(dest)] <> '\' then   // Cdigo que alterei
     dest := dest+'\';                 // Cdigo que alterei
   ProgressBar1.Max:=FileListBox1.Items.Count-1;
   ProgressBar1.Position := 0;
   for cont := 0 to FileListBox1.Items.Count-1 do begin
   CopyFile(PChar(Cam+FileListBox1.Items[cont]),
            PChar(Dest+FileListBox1.Items[cont]), false);   // Cdigo que alterei
   ProgressBar1.Position := ProgressBar1.Position+1;
   end;
   end;
end;

procedure TForm1.CopiarArquivo(const NomeArquivo, NovoDiretorio : string);
var shfo : TSHFileOpStruct;
begin
  FillChar(shfo,SizeOf(shfo),$0);
  with shfo do
  begin
     (* funcao a ser executada: COPIAR *)
     wFunc:= FO_COPY;
     (* quem e de onde: nome do arquivo e diretorio *)
     pFrom:= @NomeArquivo[1];
     (* para onde: diretorio *)
     pTo  := @NovoDiretorio[1];
     (* como a operacao deve ser realizada: modo silencioso *)
     fFlags:= FOF_SILENT;
  end;
  SHFileOperation(shfo)
end;


end.



