unit Unit1;

interface

uses
  Windows, Messages, SysUtils, Classes, Graphics, Controls, Forms, Dialogs,
  ComCtrls, Db, DBTables, Grids, DBGrids;

type
  TForm1 = class(TForm)
    TreeView1: TTreeView;
    TBcLIENTES: TTable;
    tbPedidos: TTable;
    dsClientes: TDataSource;
    DBGrid1: TDBGrid;
    tbProdutos: TTable;
    tbItens: TTable;
    dsPedidos: TDataSource;
    dsItens: TDataSource;
    tbItensCODPEDIDO: TIntegerField;
    tbItensCODPRODUTO: TIntegerField;
    tbItensQTD: TIntegerField;
    tbItensPRECOUNIT: TCurrencyField;
    tbItensproduto: TStringField;
    procedure FormShow(Sender: TObject);
    procedure TreeView1Click(Sender: TObject);
    procedure dsClientesDataChange(Sender: TObject; Field: TField);
  private
    { Private declarations }
  public
    { Public declarations }
    procedure PreencheArvore(Tabela:TTable);
    procedure PreencheGalho(Tabela:TTable);
  end;

  Tpont = ^Integer;

var
  Form1: TForm1;

implementation

{$R *.DFM}

procedure Tform1.PreencheArvore(Tabela:TTable);
var
 pont: Tpont;
begin
  tabela.first;
  while not Tabela.Eof do begin
    new(pont);
    pont^ := tabela.Fieldbyname('Codigo').asInteger;
    TreeView1.Items.AddObject(nil, Tabela.Fieldbyname('Nome').asString,pont);

    tabela.next;
  end;
end;

procedure Tform1.PreencheGalho(Tabela:TTable);
var
  pont:Tpont;
begin
  if TreeView1.Selected.HasChildren then exit;

  while not tabela.eof do begin
    new(pont);
    pont^:= Tabela.FieldByName('Codigo').asInteger;
    TreeView1.Items.AddChildObject(treeView1.Selected,'Pedido: '+Tabela.Fieldbyname('Codigo').asString+' - '+
           Tabela.Fieldbyname('Data').asString,pont);
    Tabela.Next;
  End;
End;

procedure TForm1.FormShow(Sender: TObject);
begin
  tbClientes.Open;
  tbPedidos.Open;
  tbItens.Open;

  PreencheArVore(TbClientes);
end;

procedure TForm1.TreeView1Click(Sender: TObject);
begin
  if TreeView1.Selected.Level<1 then
    if TbClientes.FindKey([Tpont(TreeView1.Selected.Data)^]) then
      PreencheGalho(TbPedidos)
    Else
  Else
    tbPedidos.FindKey([Tpont(TreeView1.Selected.Data)^]);
end;

procedure TForm1.dsClientesDataChange(Sender: TObject; Field: TField);
begin
  TbPedidos.Filter:='cliente = '+TbClientes.Fieldbyname('Codigo').asString;
end;

end.
