unit relmabout;

interface

uses SysUtils, WinTypes, WinProcs, Classes, Graphics, Forms,
     Dialogs, Controls, StdCtrls, Buttons, ExtCtrls, DsgnIntf, WebLink;


type
  Taboutbox = class(TForm)
    OKbtn: TBitBtn;
    ProgramIcon: TImage;
    ProductName: TLabel;
    Bevel1: TBevel;
    ProgramIcon2: TImage;
    Image: TImage;
    Label1: TLabel;
    Link: TWebLink;
    Label2: TLabel;
    Bevel2: TBevel;
    StaticText1: TStaticText;
    name: TLabel;
    Address: TLabel;
    Status: TLabel;
    Label3: TLabel;
    Label4: TLabel;
    Label5: TLabel;
    procedure LinkExecute(Sender: TObject);
    procedure Label2Click(Sender: TObject);
  end;

type
  Tabout2 = class(TComponent)
  private
    FAbout: string;
    FProductName, FVersionInfo, FName, FAddress, FWebAddress, FStatus: string;
  public
    procedure ShowAbout;Virtual;
    function Execute: Boolean;
  published
    property About: string read FAbout write FAbout stored False;
    property Product: string read FProductName write FProductName;
    property Version: string read FVersionInfo Write FVersionInfo;
    property name: string read Fname write Fname;
    property Status: string read FStatus write FStatus;
    property Address: string read FAddress write FAddress;
    property WebAddress: string read FWebAddress write FWebAddress;
  end;

procedure Register;

var
  aboutbox: Taboutbox;

implementation

{$R *.DFM}


type
  TAboutProperty = class(TPropertyEditor)
  public
    procedure Edit; override;
    function GetAttributes: TPropertyAttributes; override;
    function GetValue:string; override;
  end;

{/////////////////////////////////////////////////////////////////////////////}
{/////////////////////////////////////////////////////////////////////////////}
{/////////////////////////////////////////////////////////////////////////////}
{/////////////////////////////////////////////////////////////////////////////}


procedure TAboutProperty.Edit;
{call the 'About' dialog window when clicking on in the Object Inspector}
begin
  Tabout2 (GetComponent(0)).ShowAbout;
end;
function TAboutProperty.GetAttributes: TPropertyAttributes;
{set up to display a string in the Object Inspector}
begin
  GetAttributes := [paDialog, paReadOnly];
end;
function TAboutProperty.GetValue: String;
{set string to appear in the Object Inspector}
begin
  GetValue := '(About This Component)';
end;
procedure Tabout2.ShowAbout;
var
	msg: string;
const
  cr = chr(13);
begin

  msg := msg + 'Relm Software AbotBox:' + ' a 16/32-Bit Component for Delphi' + cr;
  {$IFDEF WIN32}
  msg := msg + '(This is the 32 bit version)' + cr + cr;
  {$ELSE}
  msg := msg + '(This is the 16 bit version)' + cr + cr;
  {$ENDIF}
  msg := msg + 'Copyright  1999/2002 www.Dbayliss.com' + cr;
    MessageDlg(msg,mtInformation,[MBOK],0);
end;

{/////////////////////////////////////////////////////////////////////////////}
{/////////////////////////////////////////////////////////////////////////////}
{/////////////////////////////////////////////////////////////////////////////}
{/////////////////////////////////////////////////////////////////////////////}

  procedure Register;
  begin
    RegisterComponents( 'David Bayliss.', [ TAbout2] );
    {register the 'About' property editor}
     RegisterPropertyEditor(TypeInfo(String), Tabout2, 'About',
     TAboutProperty);

  end;
{########################################################################}
{########################################################################}
{########################################################################}
{########################################################################}
{########################################################################}



function Tabout2.Execute: Boolean;
begin
  aboutbox := Taboutbox.Create(Application);
  try
    if Product = '' then Product := Application.Title;
    aboutbox.ProductName.Caption := Product+' '+Version;
      aboutbox.Caption := 'About ' + Product;
    
    aboutbox.ProgramIcon2.Picture.Graphic := Application.Icon;
    aboutbox.address.caption:=Address;
    aboutbox.status.caption:=Status;
    aboutbox.name.caption:=Name;
    aboutbox.Label2.caption:='HTTP://'+WebAddress;
    if aboutbox.ShowModal = idOK then Result := True;
  finally
    aboutbox.Free;
  end;
end;





procedure Taboutbox.LinkExecute(Sender: TObject);
begin
 link.url:=aboutbox.label2.caption;
end;

procedure Taboutbox.Label2Click(Sender: TObject);
begin
link.execute;
end;





end.

