{ TAMEdit version 1.0 copyright  1997 by Alexander Meeder (ameeder@dds.nl)

  This is descendant of TEdit component. I've added only but two advanced properties. You may use
  it for free but I do not guarantee anything

  properties:
  * Alignment -> default taLeftJustify, (taLeftJustify, taRightJustify, taCenter);
  * Keys      -> default ksReturn and ksEscape, you can toggle these on/off. When 'on' you can
                 navigate through these Edit-boxes by using the Return and Escape-keys (Return is
                 next control, Escape is previous control).

  If you have suggestions about TAMEdit or make changes, please mail me: ameeder@dds.nl

}

unit AMEdit;

interface

uses
  Windows, Messages, SysUtils, Classes, Graphics, Controls, Forms, Dialogs,
  StdCtrls;

type
  TKeySet = (ksReturn, ksEscape);
  TKeySets = set of TKeySet;

  TAMEdit = class(TEdit)
  private
    { Private declarations }
    FAlignment: TAlignment;
    FKeys: TKeySets;

    procedure SetAlignment(value: TAlignment);
  protected
    { Protected declarations }
    procedure CreateParams(var Params: TCreateParams); override;
    procedure KeyPress(var Key: Char); override;
  public
    { Public declarations }
    constructor Create(AOwner: TComponent); override;
    destructor Destroy; override;
  published
    { Published declarations }
    property Alignment: TAlignment read FAlignment write SetAlignment default taLeftJustify;
    property Keys: TKeySets read FKeys write FKeys;
  end;

procedure Register;

implementation

procedure TAMEdit.SetAlignment(value: TAlignment);
begin
  if value <> FAlignment then
  begin
    FAlignment := value;
    RecreateWnd;
  end;
end;

procedure TAMEdit.KeyPress(var Key: Char);
begin
  if ksReturn in Keys then
  begin
    if Key = Chr(Vk_Return) then
    begin
      Key := Chr(0);
      (Owner as TControl).Perform(wm_NextDlgCtl,0,0);
    end;
  end;
  if ksEscape in Keys then
  begin
    if Key = Chr(Vk_Escape) then
    begin
      Key := Chr(0);
     (Owner as TControl).Perform(wm_NextDlgCtl,1,0);
    end;
  end;
  inherited KeyPress(Key);
end;

procedure TAMEdit.CreateParams(var Params: TCreateParams);
begin
  inherited CreateParams(Params);
  case Alignment of
    taLeftJustify  : Params.Style := Params.Style or (ES_LEFT or Es_MULTILINE);
    taRightJustify : Params.Style := Params.Style or (ES_RIGHT or ES_MULTILINE);
    taCenter       : Params.Style := Params.Style or (ES_CENTER or Es_MULTILINE);
  end;
end;

constructor TAMEdit.Create(AOwner: TComponent);
begin
  inherited Create(AOwner);
  FAlignment := taLeftJustify;
end;

destructor TAMEdit.Destroy;
begin
  inherited Destroy;
end;

procedure Register;
begin
  RegisterComponents('Standard', [TAMEdit]);
end;

end.
