(* Est dica mostra como copiar ou mover diretrios e subdiretrios.

   Felicio Bastos - dinn@uol.com.br
 *)

unit Unit1;

interface

// Declare a Unit ShellApi na clausula Uses
uses
  Windows, Messages, SysUtils, Classes, Graphics, Controls, Forms, Dialogs,
  StdCtrls, FileCtrl, ShellApi;

type
  TForm1 = class(TForm)
    GroupBox1: TGroupBox;
    DirectoryListBox1: TDirectoryListBox;
    DriveComboBox1: TDriveComboBox;
    GroupBox2: TGroupBox;
    DirectoryListBox2: TDirectoryListBox;
    DriveComboBox2: TDriveComboBox;
    Label1: TLabel;
    Label2: TLabel;
    Label3: TLabel;
    Label4: TLabel;
    Label5: TLabel;
    Button1: TButton;
    Button2: TButton;
    function CopiaDir(Fonte,Destino: String): boolean;
    function MoveDir(Fonte,Destino: String): boolean;
    procedure Button1Click(Sender: TObject);
    procedure Button2Click(Sender: TObject);

  private
    { Private declarations }
  public
    { Public declarations }
  end;

var
  Form1: TForm1;

implementation

{$R *.DFM}

function TForm1.CopiaDir(Fonte,Destino: String): boolean;
var
  fos: TSHFileOpStruct;
begin
  ZeroMemory(@fos, SizeOf(fos));
  with fos do
  begin
    wFunc := FO_COPY;
    fFlags := FOF_FILESONLY;
    pFrom := PChar(Fonte+#0);
    pTo := PChar(Destino)
  end;
  Result:=(0=ShFileOperation(fos));
end;


function TForm1.MoveDir(Fonte,Destino: String): boolean;
var
  fos: TSHFileOpStruct;
begin
  ZeroMemory(@fos, SizeOf(fos));
  with fos do
  begin
    wFunc := FO_MOVE;
    fFlags := FOF_FILESONLY;
    pFrom := PChar(Fonte+#0);
    pTo := PChar(Destino)
  end;
  Result:=(0=ShFileOperation(fos));
end;

// Executa a cpia do diretrio.
procedure TForm1.Button1Click(Sender: TObject);
begin
  if CopiaDir(Label4.Caption,Label5.Caption) then
     ShowMessage('Diretrio Copiado.');
end;

// Move o diretrio e subdiretrios.
procedure TForm1.Button2Click(Sender: TObject);
begin
  if MoveDir(Label4.Caption,Label5.Caption) then
     ShowMessage('Diretrio Movido.');
end;


end.
