<!--- This tag developed by Mary Jo Sminkey maryjo@cfwebstore.com --->
<!--- This tag was developed using the Internet Shipping API provided by the USPS --->
<!--- Originally developed for use with CFWebstore e-commerce (www.cfwebstore.com) --->

<!--- Due to problems with the CF_HTTP tag in Cold Fusion 4.5, you must have the 
    service pack installed for this tag to work --->

<!--- To use this tag, you will need to register with USPS at www.uspsprioritymail.com 
	and receive a userid and password --->

<!--- This tag only handles domestic rates --->

<!--- This tag is free software; you can redistribute it and/or
    modify it under the terms of the GNU Lesser General Public
    License as published by the Free Software Foundation; either
    version 2.1 of the License, or (at your option) any later version.

    This library is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    Lesser General Public License for more details. --->
	
<!--- Example of use --->
<!--- <cf_USPSSHIP server="http://sampleserver.usps.com" userid="userid" password="password" debug="No" origzip="22306" destzip="20715" pounds="5" ounces="0" service="Priority"> --->

<!--- Required Attributes 
	Username
	Password
	Server
	Origzip
	Destzip  --->
	
<!--- Optional Attributes
	Service (can be Parcel, Priority, or Express)
	Package_ID
	Pounds
	Ounces
	Container (see USPS API documentation for valid entries)
	Size (Regular, Large, Oversize)
	Machinable (True or False)
	Timeout (max timeout for CF_HTTP request)
	Debug (set to Yes or True to see output of request sent and full response received)
 --->

<!--- Returned Values --->
<!--- Success = 1 if postage rate returned, otherwise 0 --->
<!--- If Success, returns Postage --->
<!--- If Error, returns ErrorMessage --->

<!--- Initialize Parameters --->

<CFPARAM NAME="attributes.userid">
<CFPARAM NAME="attributes.password">
<CFPARAM NAME="attributes.server">

<CFPARAM NAME="attributes.service" default="PARCEL">

<CFPARAM NAME="attributes.origzip" DEFAULT="">
<CFPARAM NAME="attributes.destzip" DEFAULT="">

<CFPARAM NAME="attributes.package_ID" DEFAULT="0">

<CFPARAM NAME="attributes.pounds" DEFAULT="0">
<CFPARAM NAME="attributes.ounces" DEFAULT="0">

<CFPARAM NAME="attributes.container" DEFAULT="None">
<CFPARAM NAME="attributes.size" DEFAULT="Regular">
<CFPARAM NAME="attributes.machinable" DEFAULT="False">

<CFPARAM NAME="attributes.timeout" DEFAULT="45">
<CFPARAM NAME="attributes.debug" DEFAULT="FALSE">

<cfparam name="caller.postage" default="0">
<cfparam name="caller.success" default="0">
<cfparam name="caller.errormessage" default="">

<CFSCRIPT>

if(val(attributes.timeout) LTE 0)
{
	attributes.timeout = 45;
}
// begin the request document
request = '<RateRequest USERID="#attributes.userid#" PASSWORD="#attributes.password#">';
	
attributes.service = ucase(attributes.service);

// build the request
	request = request & '<Package ID="#attributes.package_ID#">';
	request = request & '<Service>#attributes.service#</Service>';
	request = request & '<ZipOrigination>#attributes.origzip#</ZipOrigination>';
	request = request & '<ZipDestination>#attributes.destzip#</ZipDestination>';
	request = request & '<Pounds>#attributes.pounds#</Pounds>';
	request = request & '<Ounces>#attributes.ounces#</Ounces>';
	request = request & '<Container>#attributes.Container#</Container>';
	request = request & '<Size>#attributes.Size#</Size>';
	request = request & '<Machinable>#attributes.Machinable#</Machinable>';
	request = request & '</Package></RateRequest>';

</CFSCRIPT>

<!---d:\html\users\cfxa423\journeyinternetcom\html\ Send the Request --->
	<cfhttp url="#attributes.server#?API=Rate&XML=#urlencodedformat(request)#" method="GET" path="#attributes.pathtourl#" file="uspstemp.txt" resolveurl="false" timeout="#attributes.timeout#"></CFHTTP>


<!--- Debugging Output #attributes.pathtourl#--->
<CFIF attributes.debug>
	<CFOUTPUT><H4>Request</H4>#htmleditformat(request)#<BR>
	<H4>Response</H4>#htmleditformat(temp)#</CFOUTPUT>
</CFIF>

<cffile action="READ" file="#attributes.pathtourl#uspstemp.txt" variable="tempvar">

<cfoutput>#tempvar#</cfoutput><br><br>

<CFSCRIPT>

if (find("<Postage", tempvar))
{
	tempval = find("<Postage", tempvar);
	tempval = tempval + 9;
	tempval2 = find("</Postage", tempvar);
	
	lentoget = tempval2 - tempval;
	
	postage = mid(tempvar, tempval, lentoget);
	
	caller.postage = postage;
	caller.success = 1;
}

else
{
	tempval = find("<Description", tempvar);
	tempval = tempval + 13;
	tempval2 = find("</Description", tempvar);
	
	lentoget = tempval2 - tempval;
	
	caller.errormessage = mid(tempvar, tempval, lentoget);
	caller.success = 0;
}
	
</CFSCRIPT>
