<!---
NAME:
CF_UPSPrice

DESCRIPTION:
Cold Fusion custom tag obtain UPS shipping costs from ups.com.

ATTRIBUTES:
CALLTAG   - (optional) Electronic or basic call tag issued, valid options
                       are NONE BASIC or ELECTRONIC, defaults to NONE.
COD       - (optional) Package is being sent C.O.D., valid options are YES
                       and NO, defaults to NO.
FROM      - (required) Source (ship from) postal code.
HANDLING  - (optional) Requires special handling (eg. - any article that
                       is not fully encased in an outside shipping container,
					   or any package that exceeds 60 inches in length).
HAZARD    - (optional) Package contains hazardous material, valid options are YES
                       and NO, defaults to NO.
HEIGHT    - (optional) Height (in inches) of oversized package.
LENGTH    - (optional) Length (in inches) of oversized package.
OVERSIZED - (optional) Package is oversized, valid options are YES and NO,
                       defaults to NO.
RESPONSE  - (optional) Delivery confirmation service, valid options are
                       NONE BASIC SIGNATURE ALTERNATE or ALL, defaults to
					   NONE.
SATDELIV  - (optional) Saturday delivery, valid options are YES and NO,
                       defaults to NO.
SATPICKUP - (optional) Saturday pickup, valid options are YES and NO,
                       defaults to NO.
SERVICE   - (required) UPS Service ID, valid service IDs are:
                       1DM    - Next Day Air Early AM
                       1DML   - Next Day Air Early AM Letter
                       1DA    - Next Day Air
                       1DAL   - Next Day Air Letter
                       1DP    - Next Day Air Saver
                       1DPL   - Next Day Air Saver Letter
                       2DM    - 2nd Day Air A.M.
                       2DA    - 2nd Day Air
                       2DML   - 2nd Day Air A.M. Letter
                       2DAL   - 2nd Day Air Letter
                       3DS    - 3 Day Select
                       GNDCOM - Ground Commercial
                       GNDRES - Ground Residential
SHIPNOT1  - (optional) First ship notification, valid options are NONE
                       DOMESTIC or INTERNATIONAL, defaults to NONE.
SHIPNOT2  - (optional) Second ship notification, valid options are NONE
                       DOMESTIC or INTERNATIONAL, defaults to NONE.
TOCOUNTRY - (optional) Destination country code, defaults to US if not
                       specified. Visit the UPS site for a complete list of
					   valid two letter country codes.
TO        - (required) Destination (ship to) postal code.
VALUE     - (optional) Declared value for carrier liability, carrier assumes
                       $100 by default.
VERBCONF  - (optional) Verbal confirmation of delivery, valid options are YES
                       and NO, defaults to NO.
WEIGHT    - (required) Weight (in pounds) of package, fractions may be used.
WIDTH     - (optional) Width (in inches) of oversized package.

NOTES:
This tag submits a shipping cost request to UPS for processing, and returns
price and shipping information. CF_UPSPrice sets the following variables that
you may use within your template after the call to CF_UPSPrice:
 UPS_BaseCharge     - Base shipping charge.
 UPS_Charge         - Total charge.
 UPS_Error          - Error message, if there was one.
 UPS_ErrorCode      - Error code, if there was one.
 UPS_FromCountry    - Source country code.
 UPS_FromPostal     - Source postal code.
 UPS_GuaranteedBy   - Guranteed delivery time.
 UPS_OptionalCharge - Total of optional charges.
 UPS_Service        - UPS service ID.
 UPS_Success        - YES if request was successful, NO if not.
 UPS_ToCountry      - Destination country code.
 UPS_ToPostal       - Destination postal code.
 UPS_ToZone         - Destination zone.
 UPS_Weight         - Billed weight.

USAGE:
To use just call <CF_UPSPrice> from within your Cold Fusion template,
passing at least the required attributes TO FROM SERVICE and WEIGHT.

EXAMPLES:
 Obtain price for next day package from NY to CA:
  <CF_UPSPrice SERVICE="1DA" FROM="11213" TO="90046" WEIGHT="1.5">
  <CFOUTPUT>Cost is #DollarFormat(UPS_Charge)#</CFOUTPUT>
  
 Sending a oversized package C.O.D. via second day air:
  <CF_UPSPrice SERVICE="2DA" FROM="11213" TO="90046"
   WEIGHT="1.5" HEIGHT="13" WIDTH="12" LENGTH="20" COD="Yes">
   
 Using form fields:
  <CF_UPSPrice SERVICE="#service#" FROM="#from#" TO="#to#" WEIGHT="#weight#">
  
AUTHOR:
Ben Forta (ben@stoneage.com) 10/14/97
With help from Dave Beckstrom (dbeck@atving.com)
--->

<!--- Initialize variables --->
<CFSET proceed = "Yes">
<CFSET error_message = "">

<!--- Get UPS service --->
<CFIF proceed>
 <CFIF IsDefined("ATTRIBUTES.service")>
  <CFSET product = ATTRIBUTES.service>
 <CFELSE>
  <CFSET proceed = "No">
  <CFSET error_message = "SERVICE must be specified!">
 </CFIF>
</CFIF>

<!--- Get destination postal code --->
<CFIF proceed>
 <CFIF IsDefined("ATTRIBUTES.to")>
  <CFSET destPostal = ATTRIBUTES.to>
 <CFELSE>
  <CFSET proceed = "No">
  <CFSET error_message = "TO postal code must be specified!">
 </CFIF>
</CFIF>

<!--- Get source postal code --->
<CFIF proceed>
 <CFIF IsDefined("ATTRIBUTES.from")>
  <CFSET origPostal = ATTRIBUTES.from>
 <CFELSE>
  <CFSET proceed = "No">
  <CFSET error_message = "FROM postal code must be specified!">
 </CFIF>
</CFIF>

<!--- Get weight --->
<CFIF proceed>
 <CFIF IsDefined("ATTRIBUTES.weight")>
  <CFSET weight = ATTRIBUTES.weight>
 <CFELSE>
  <CFSET proceed = "No">
  <CFSET error_message = "WEIGHT postal code must be specified!">
 </CFIF>
</CFIF>

<!--- If all okay, process other options --->
<CFIF proceed>

 <!--- Get destination country --->
 <CFSET destCountry = "US">
 <CFIF IsDefined("ATTRIBUTES.tocountry")>
  <CFSET destCountry = ATTRIBUTES.tocountry>
 </CFIF>

 <!--- Get oversized --->
 <CFSET oversized = "0">
 <CFIF IsDefined("ATTRIBUTES.oversized")>
  <CFIF ATTRIBUTES.oversized>
   <CFSET oversized = "1">
  </CFIF>
 </CFIF>

 <!--- Get COD --->
 <CFSET cod = "0">
 <CFIF IsDefined("ATTRIBUTES.cod")>
  <CFIF ATTRIBUTES.cod>
   <CFSET cod = "1">
  </CFIF>
 </CFIF>

 <!--- Get hazard --->
 <CFSET hazard = "0">
 <CFIF IsDefined("ATTRIBUTES.hazard")>
  <CFIF ATTRIBUTES.hazard>
   <CFSET hazard = "1">
  </CFIF>
 </CFIF>

 <!--- Get handling --->
 <CFSET handling = "0">
 <CFIF IsDefined("ATTRIBUTES.handling")>
  <CFIF ATTRIBUTES.handling>
   <CFSET handling = "1">
  </CFIF>
 </CFIF>

 <!--- Get calltag --->
 <CFSET calltag = "0">
 <CFIF IsDefined("ATTRIBUTES.calltag")>
  <CFIF ATTRIBUTES.calltag IS "BASIC">
   <CFSET calltag = "1">
  <CFELSEIF ATTRIBUTES.calltag IS "ELECTRONIC">
   <CFSET calltag = "2">
  </CFIF>
 </CFIF>

 <!--- Get Saturday delivery --->
 <CFSET saturdaydelivery = "0">
 <CFIF IsDefined("ATTRIBUTES.satdeliv")>
  <CFIF ATTRIBUTES.satdeliv>
   <CFSET saturdaydelivery = "1">
  </CFIF>
 </CFIF>

 <!--- Get Saturday pickup --->
 <CFSET saturdaypickup = "0">
 <CFIF IsDefined("ATTRIBUTES.satpickup")>
  <CFIF ATTRIBUTES.satpickup>
   <CFSET saturdaypickup = "1">
  </CFIF>
 </CFIF>

 <!--- Get response --->
 <CFSET response = "0">
 <CFIF IsDefined("ATTRIBUTES.response")>
  <CFIF ATTRIBUTES.response IS "BASIC">
   <CFSET response = "1">
  <CFELSEIF ATTRIBUTES.response IS "SIGNATURE">
   <CFSET response = "2">
  <CFELSEIF ATTRIBUTES.response IS "ALTERNATE">
   <CFSET response = "3">
  <CFELSEIF ATTRIBUTES.response IS "ALL">
   <CFSET response = "4">
  </CFIF>
 </CFIF>

 <!--- Get vcd --->
 <CFSET vcd = "0">
 <CFIF IsDefined("ATTRIBUTES.verbconf")>
  <CFIF ATTRIBUTES.verbconf>
   <CFSET vcd = "1">
  </CFIF>
 </CFIF>

 <!--- Get first ship notify --->
 <CFSET firstshipnotify = "0">
 <CFIF IsDefined("ATTRIBUTES.shipnot1")>
  <CFIF ATTRIBUTES.shipnot1 IS "DOMESTIC">
   <CFSET firstshipnotify = "1">
  <CFELSEIF ATTRIBUTES.shipnot1 IS "INTERNATIONAL">
   <CFSET firstshipnotify = "2">
  </CFIF>
 </CFIF>

 <!--- Get second ship notify --->
 <CFSET secondshipnotify = "0">
 <CFIF IsDefined("ATTRIBUTES.shipnot2")>
  <CFIF ATTRIBUTES.shipnot2 IS "DOMESTIC">
   <CFSET secondshipnotify = "1">
  <CFELSEIF ATTRIBUTES.shipnot2 IS "INTERNATIONAL">
   <CFSET secondshipnotify = "2">
  </CFIF>
 </CFIF>
 
</CFIF> <!--- End process params --->

<!--- If have all params, process request --->
<CFIF proceed>

<cfquery name="getadminpath" datasource="#request.dsn#" dbtype="ODBC">
SELECT MerchantGraphicPath
FROM tblAdmin
</cfquery>

 <cfhttp url="http://www.ups.com/using/services/rave/qcostcgi.cgi" method="POST" path="#getadminpath.MerchantGraphicPath#" file="upstemp.txt" resolveurl="false">
  <CFHTTPPARAM TYPE="FORMFIELD" NAME="accept_UPS_license_agreement" VALUE="yes">
  <CFHTTPPARAM TYPE="FORMFIELD" NAME="10_action" VALUE="3">
  <CFHTTPPARAM TYPE="FORMFIELD" NAME="13_product" VALUE="#product#">
  <CFHTTPPARAM TYPE="FORMFIELD" NAME="15_origPostal" VALUE="#origPostal#">
  <CFHTTPPARAM TYPE="FORMFIELD" NAME="19_destPostal" VALUE="#destPostal#">
  <CFHTTPPARAM TYPE="FORMFIELD" NAME="22_destCountry" VALUE="#destCountry#">
  <CFHTTPPARAM TYPE="FORMFIELD" NAME="23_weight" VALUE="#weight#">
  <CFIF IsDefined("ATTRIBUTES.value")><CFHTTPPARAM TYPE="FORMFIELD" NAME="24_value" VALUE="#ATTRIBUTES.value#"></CFIF>
  <CFIF IsDefined("ATTRIBUTES.length")><CFHTTPPARAM TYPE="FORMFIELD" NAME="25_length" VALUE="#ATTRIBUTES.length#"></CFIF>
  <CFIF IsDefined("ATTRIBUTES.width")><CFHTTPPARAM TYPE="FORMFIELD" NAME="26_width" VALUE="#ATTRIBUTES.width#"></CFIF>
  <CFIF IsDefined("ATTRIBUTES.height")><CFHTTPPARAM TYPE="FORMFIELD" NAME="27_height" VALUE="#ATTRIBUTES.height#"></CFIF>
  <CFHTTPPARAM TYPE="FORMFIELD" NAME="29_oversized" VALUE="#oversized#">
  <CFHTTPPARAM TYPE="FORMFIELD" NAME="30_cod" VALUE="#cod#">
  <CFHTTPPARAM TYPE="FORMFIELD" NAME="33_hazard" VALUE="#hazard#">
  <CFHTTPPARAM TYPE="FORMFIELD" NAME="34_handling" VALUE="#handling#">
  <CFHTTPPARAM TYPE="FORMFIELD" NAME="35_calltag" VALUE="#calltag#">
  <CFHTTPPARAM TYPE="FORMFIELD" NAME="37_saturdaydelivery" VALUE="#saturdaydelivery#">
  <CFHTTPPARAM TYPE="FORMFIELD" NAME="38_saturdaypickup" VALUE="#saturdaypickup#">
  <CFHTTPPARAM TYPE="FORMFIELD" NAME="39_response" VALUE="#response#">
  <CFHTTPPARAM TYPE="FORMFIELD" NAME="43_vcd" VALUE="#vcd#">
  <CFHTTPPARAM TYPE="FORMFIELD" NAME="44_firstshipnotify" VALUE="#firstshipnotify#">
  <CFHTTPPARAM TYPE="FORMFIELD" NAME="45_secondshipnotify" VALUE="#firstshipnotify#">
 </CFHTTP>
 
<cffile action="READ" file="#getadminpath.MerchantGraphicPath#upstemp.txt" variable="temp">

<CFIF ListFirst(temp, "%") IS "UPSOnLine3">
  <!--- Success, set variables --->
  <CFSET CALLER.UPS_Success = "Yes">
  <CFSET CALLER.UPS_Service = ListGetAt(temp, 2, "%")>
  <CFSET CALLER.UPS_FromPostal = ListGetAt(temp, 3, "%")>
  <CFSET CALLER.UPS_FromCountry = ListGetAt(temp, 4, "%")>
  <CFSET CALLER.UPS_ToPostal = ListGetAt(temp, 5, "%")>
  <CFSET CALLER.UPS_ToCountry = ListGetAt(temp, 6, "%")>
  <CFSET CALLER.UPS_ToZone = ListGetAt(temp, 7, "%")>
  <CFSET CALLER.UPS_Weight = ListGetAt(temp, 8, "%")>
  <CFSET CALLER.UPS_BaseCharge = ListGetAt(temp, 9, "%")>
  <CFSET CALLER.UPS_OptionalCharge = ListGetAt(temp, 10, "%")>
  <CFSET CALLER.UPS_Charge = ListGetAt(temp, 11, "%")>
  <CFSET CALLER.UPS_GuaranteedBy = ListGetAt(temp, 12, "%")>
  <CFSET CALLER.UPS_Error = "">
  <CFSET CALLER.UPS_ErrorCode = "">
 <CFELSE>
  <!--- Failed, set variables and error message --->
  <CFSET CALLER.UPS_Success = "No">
  <CFSET CALLER.UPS_Service = "">
  <CFSET CALLER.UPS_FromPostal = "">
  <CFSET CALLER.UPS_FromCountry = "">
  <CFSET CALLER.UPS_ToPostal = "">
  <CFSET CALLER.UPS_ToCountry = "">
  <CFSET CALLER.UPS_ToZone = "">
  <CFSET CALLER.UPS_Weight = "">
  <CFSET CALLER.UPS_BaseCharge = "">
  <CFSET CALLER.UPS_OptionalCharge = "">
  <CFSET CALLER.UPS_Charge = "">
  <CFSET CALLER.UPS_GuaranteedBy = "">
  <CFSET CALLER.UPS_Error = ListGetAt(temp, 2, "%")>
  <CFSET CALLER.UPS_ErrorCode = ListGetAt(temp, 3, "%")>
 </CFIF>

<CFELSE>

 <!--- Failed, display error message, and abort --->
 <CFOUTPUT><H1>Error: #error_message#</H1></CFOUTPUT>
 <CFABORT>

</CFIF>

