#!/usr/bin/perl
##################################################################
#                                                                #
#    Classifieds.pl - Perl Script for Posting Classified Ads     #
#                                                                #
#      Modified by Greg Mathews - greg@notts.net                 #
#        Based on the orriginal Classifieds.pl 	  		     #
#                                                                         #
#            Written by Michael Hall - mikeh@isaac.biola.edu              #
#      Written for Virtual Marketing Technologies - vmt@airmail.net       #
# Copyright 1996 by Virtual Marketing Technologies, All Rights Reserved. #
#                                                                         #
###########################################################################

&UnWeb;
$return_name=$in{'return'}; #who the mail is from.
$mailprog=$in{'mailprog'};

$in{'Description'} =~ s/&&/<br><br>/g;
$AdNumber = 0;
# Get the Date for Entry
$date = `date +"%A, %B %d, %Y"`;
        chop($date);
$shortdate = `date +"%D"`;
        chop($shortdate);

if ($in{'Selection'} eq "ViewAds") {
	if ($in{'Department'} eq "") {
		# User did not choose a department to view so return the error message and quit
		&PrintHeader;
		print "<html>\n";
		print "<head>\n";
		print "<title>Error Message</title>\n";
		print "</head>\n";
		print "<body bgcolor=\"FFFFFF\">\n";
		print "\n";
		print "<h1>An Error Has Occurred:</h1><p>\n";
		print "You did not choose a department to view ads in.  Please choose one by selecting the button next to the appropriate department.<p>\n";
		print "<hr><p><center><a href=$in{'ErrorReturn'}>Return to the Form</a><p><hr>\n";
		print " 1997 and Designed and Programmed by <a href=\"mailto:greg\@notts.net\">Greg Mathews</a>.  All Rights Reserved.<br>\n";
		print "</body>\n";
		print "</html>\n";
		
		# make a call to exit to end the script now, we had an error
		exit;
		}
	print "Location: $in{'ViewDir'}$in{'Department'}.html\n\n";
	exit;
	}
        if (!&check_email($in{'E-MailAddress'})) {
                &error('missing_fields','Email');
		}
if ($in{'RealName'} eq "") {
		# something was blank, return the error message
                &error('missing_fields','Name');
}
if ($in{'Address1'} eq "") {
		# something was blank, return the error message
                &error('missing_fields','Address');
}
if ($in{'City'} eq "") {
		# something was blank, return the error message
                &error('missing_fields','City');
}
if ($in{'State'} eq "") {
		# something was blank, return the error message
                &error('missing_fields','State');
}
if ($in{'ZipCode'} eq "") {
		# something was blank, return the error message
                &error('missing_fields','Address');
}
if ($in{'Phone'} eq "") {
		# something was blank, return the error message
                &error('missing_fields','Phone');
}
if ($in{'Department'} eq "") {
		# something was blank, return the error message
                &error('missing_fields','Category');
}
if ($in{'Description'} eq "") {
		# something was blank, return the error message
                &error('missing_fields','Description');
}

# Lock the file for security so the file is not damaged if more than one user tries to access it at the same time.
&PrintHeader;
		
$quit = 0;
while ($quit != 1) {
	if (-e "$in{'ClassifiedsDir'}.$in{'Department'}lock") {
		# The file exists, time to take a nap
		sleep(1);
	}
	else {
	
	# Create the lock file, thereby locking the Classified Ad file
	open (LOCK,">$in{'ClassifiedsDir'}.$in{'Department'}lock");
	close LOCK;
	}
	
	# Open the data file to read the number of the last post
	open (ADFILE, "$in{'ClassifiedsDir'}AdNumber.dta");
	$AdNumber = <ADFILE>;
	# chop $AdNumber;

	# Update the Ad Number by one
	$AdNumber = $AdNumber + 1;
	
	# Rewrite the data file
	open (ADFILE, ">$in{'ClassifiedsDir'}AdNumber.dta");
	print ADFILE $AdNumber;
	close(ADFILE);

	# Append the user's ad and description to the ad file
	open(ADFILE,"$in{'ClassifiedsDir'}$in{'Department'}.html") || die $!;
		@main = <ADFILE>;
		close(ADFILE);
	open(ADFILE,">$in{'ClassifiedsDir'}$in{'Department'}.html") || die $!;
	      foreach $main_line (@main) {
	         if ($main_line =~ /<!--Do not edit past this line-->/) {
	            	print ADFILE "<!--Do not edit past this line-->\n";
			print ADFILE "<!-- $AdNumber $in{'RealName'} $in{'E-MailAddress'} $shortdate -->\n";
			print ADFILE "<b>Ad No.: </b>$AdNumber - <b>Subject: </b>$in{'AdSubject'} - <b>Posted on: </b>$shortdate<br>\n";
			print ADFILE "<b>Reply to: </b>$in{'RealName'} at <a href=\"mailto: $in{'E-MailAddress'}\">$in{'E-MailAddress'}</a><br>\n";
			print ADFILE "$in{'Description'}<p>\n";
			print ADFILE "<A href=\"$in{'Linkurl'}\">$in{'Linktitle'}</a>";
			print ADFILE "<p><hr><p>\n";
			print ADFILE "<!-- end $AdNumber -->\n";

	         }
	         else {
	            print ADFILE "$main_line";
	         }
	      }

	

	# Appen the user's personal data to the data file
	open (DATAFILE,">>$in{'ClassifiedsDir'}UserDataFile.html");
	print DATAFILE "<!-- $AdNumber $in{'Department'} $in{'E-MailAddress'} $shortdate -->\n";
print DATAFILE "<b>$in{'RealName'} - <a href=mailto:$in{'E-MailAddress'}>$in{'E-MailAddress'}</a><br>\n";
	print DATAFILE "$in{'Address1'}<br>\n";
	if ($in{'Address2'} ne "") {
		print DATAFILE "$in{'Address2'}<br>\n";
	}
	print DATAFILE "$in{'City'}, $in{'State'}  $in{'ZipCode'} - $in{'Phone'}</b><br>\n";
	print DATAFILE "<b>Ad No.: </b>$AdNumber - <b>Department: </b>$in{'Department'} on $shortdate<br>\n";
	if ($in{'DesiredDepartment'} ne "") {
		print DATAFILE "<b>Desired Department: </b>$in{'DesiredDepartment'}<br>\n";
	}
			print DATAFILE "<b>Description : </b>$in{'Description'}\n";
			print DATAFILE "<b>Link : </b><A href=\"$in{'Linkurl'}\">$in{'Linktitle'}</a>";
			print DATAFILE "<p><hr><p>\n";
	print DATAFILE "<!-- end $AdNumber -->\n";
	close(DATAFILE);
	
	# unlock the lock file
	unlink("$in{'ClassifiedsDir'}.$in{'Department'}lock");

      open( MAIL, "|$mailprog $in{'E-MailAddress'}" )
         || die "can't open sendmail: $email: $!\n";
      print MAIL "To: $in{'E-MailAddress'}\n";
      print MAIL "Subject: Classified Add Response\n";
      print MAIL "From: $return_name\n";
      print MAIL "Reply-to: $return_name\n\n";

      print MAIL "   Thank you for the entery to the\n";
     print MAIL "   Classifieds on our site. Your entry to $in{'Department'} looks like:\n\n";

	print MAIL "Ad No.: $AdNumber - Subject: $in{'AdSubject'} - Posted on: $shortdate\n";
	print MAIL "Reply to: $in{'RealName'} at <a href=\"mailto: $in{'E-MailAddress'}\">$in{'E-MailAddress'}</a>\n";
	print MAIL "$in{'Description'}\n";
	print MAIL "Link <A href=\"$in{'Linkurl'}\">$in{'Linktitle'}</a>\n";
      print MAIL "Webmaster.\n";
close(MAIL);

#--------------------------------
#
#Send your keeper's notification out.
#

if( $return_name ne "" )
{
      open( MAIL, "|$mailprog $return_name" )
         || die "can't open sendmail notify: $return_name: $!\n";
      print MAIL "To: $return_name\n";
      print MAIL "Subject:Classified Add Notification\n";
      print MAIL "From: $in{ 'RealName' } <$in{ 'E-MailAddress' }>\n\n";
      print MAIL "I have just made the following entry to $in{'Department'}:\n\n";

	print MAIL "Ad No.: $AdNumber - Subject: $in{'AdSubject'} - Posted on: $shortdate<br>\n";
	print MAIL "Reply to: $in{'RealName'} at <a href=\"mailto: $in{'E-MailAddress'}\">$in{'E-MailAddress'}</a><br>\n";
	print MAIL "$in{'Description'}\n";
	print MAIL "<A href=\"$in{'Linkurl'}\">$in{'Linktitle'}</a>";

}
	
	# Return the user to the Return URL
	print "<meta http-equiv=\"refresh\" content=\"1; url=$in{'ReturnURL'}\">\n";
	$quit = 1;
close(MAIL);
}

sub UnWeb {

   # Get the input
   read(STDIN, $buffer, $ENV{'CONTENT_LENGTH'});

   # Split the name-value pairs
   @pairs = split(/&/, $buffer);

   foreach $pair (@pairs) {
      ($name, $value) = split(/=/, $pair);

      # Un-Webify plus signs and %-encoding
      $value =~ tr/+/ /;
      $value =~ s/%([a-fA-F0-9][a-fA-F0-9])/pack("C", hex($1))/eg;
      $value =~ s/<!--(.|\n)*-->//g;

      if ($allow_html != 1) {
         $value =~ s/<([^>]|\n)*>//g;
      }
      else {
         unless ($name eq 'body') {
	    $value =~ s/<([^>]|\n)*>//g;
         }
      }

      $in{$name} = $value;
   }

}


#######################
# Print HTML Header

sub PrintHeader {

	print "Content-type: text/html\n\n";
}



sub check_email {
    # Initialize local email variable with input to subroutine.              #
    $email = $_[0];

    # If the e-mail address contains:                                        #
    if ($email =~ /(@.*@)|(\.\.)|(@\.)|(\.@)|(^\.)/ ||

        # the e-mail address contains an invalid syntax.  Or, if the         #
        # syntax does not match the following regular expression pattern     #
        # it fails basic syntax verification.                                #

        $email !~ /^.+\@(\[?)[a-zA-Z0-9\-\.]+\.([a-zA-Z]{2,3}|[0-9]{1,3})(\]?)$/) {

        # Basic syntax requires:  one or more characters before the @ sign,  #
        # followed by an optional '[', then any number of letters, numbers,  #
        # dashes or periods (valid domain/IP characters) ending in a period  #
        # and then 2 or 3 letters (for domain suffixes) or 1 to 3 numbers    #
        # (for IP addresses).  An ending bracket is also allowed as it is    #
        # valid syntax to have an email address like: user@[255.255.255.0]   #

        # Return a false value, since the e-mail address did not pass valid  #
        # syntax.                                                            #
        return 0;
    }

    else {

        # Return a true value, e-mail verification passed.                   #
        return 1;
    }
}
sub error { 
    # Localize variables and assign subroutine input.                        #
    local($error,@error_fields) = @_;
    local($host,$missing_field,$missing_field_list);
&PrintHeader;
    if ($error eq 'bad_referer') {
        if ($ENV{'HTTP_REFERER'} =~ m|^https?://([\w\.]+)|i) {
            $host = $1;
            print <<"(END ERROR HTML)";

<html>
 <head>
  <title>Bad Referrer - Access Denied</title>
 </head>
 <body bgcolor=#FFFFFF text=#000000>
  <center>
   <table border=0 width=600 bgcolor=#9C9C9C>
    <tr><th><font size=+2>Bad Referrer - Access Denied</font></th></tr>
   </table>
   <table border=0 width=600 bgcolor=#CFCFCF>
    <tr><td>The form attempting to use Classifieds
     resides at <tt>$ENV{'HTTP_REFERER'}</tt>, which is not allowed to access
     this cgi script.<p>

     If you are attempting to configure Classifieds to run with this form, you need
     to add the following to \@referers, explained in detail in the README file.<p>

     Add <tt>'$host'</tt> to your <tt><b>\@referers</b></tt> array.<hr size=1>
    </td></tr>
   </table>
  </center>
 </body>
</html>
(END ERROR HTML)
        }
        else {
            print <<"(END ERROR HTML)";

<html>
 <head>
  <title>Classifieds v1.6</title>
 </head>
 <body bgcolor=#FFFFFF text=#000000>
  <center>
   <table border=0 width=600 bgcolor=#9C9C9C>
    <tr><th><font size=+2>Classifieds</font></th></tr>
   </table>
  </center>
 </body>
</html>
(END ERROR HTML)
        }
    }

    elsif ($error eq 'request_method') {
            print <<"(END ERROR HTML)";

<html>
 <head>
  <title>Error: Request Method</title>
 </head>
 <body bgcolor=#FFFFFF text=#000000>
  <center>
   <table border=0 width=600 bgcolor=#9C9C9C>
    <tr><th><font size=+2>Error: Request Method</font></th></tr>
   </table>
   <table border=0 width=600 bgcolor=#CFCFCF>
    <tr><td>The Request Method of the Form you submitted did not match
     either <tt>GET</tt> or <tt>POST</tt>.  Please check the form and make sure the
     <tt>method=</tt> statement is in upper case and matches <tt>GET</tt> or <tt>POST</tt>.<p>

    </td></tr>
   </table>
  </center>
 </body>
</html>
(END ERROR HTML)
    }

    elsif ($error eq 'no_recipient') {
            print <<"(END ERROR HTML)";

<html>
 <head>
  <title>Error: No Recipient</title>
 </head>
 <body bgcolor=#FFFFFF text=#000000>
  <center>
   <table border=0 width=600 bgcolor=#9C9C9C>
    <tr><th><font size=+2>Error: No Recipient</font></th></tr>
   </table>
   <table border=0 width=600 bgcolor=#CFCFCF>
    <tr><td>No Recipient was specified in the data sent to Classifieds.  Please
     make sure you have filled in the 'recipient' form field with an e-mail
     address.  More information on filling in recipient form fields can be
     found in the README file.<hr size=1>

    </td></tr>
   </table>
  </center>
 </body>
</html>
(END ERROR HTML)
    }

    elsif ($error eq 'missing_fields') {
        if ($Config{'missing_fields_redirect'}) {
            print "Location: $Config{'missing_fields_redirect'}\n\n";
        }
        else {
            foreach $missing_field (@error_fields) {
                $missing_field_list .= "      <li>$missing_field\n";
            }

            print <<"(END ERROR HTML)";

<html>
 <head>
  <title>Error: Blank Fields</title>
 </head>
  <center>
   <table border=0 width=600 bgcolor=#9C9C9C>
    <tr><th><font size=+2>Error: Blank Fields</font></th></tr>
   </table>
   <table border=0 width=600 bgcolor=#CFCFCF>
    <tr><td>The following fields were left blank in your submission form:<p>
     <ul>
$missing_field_list
     </ul><br>

     These fields must be filled in before you can successfully submit the form.<p>
     Please use your browser's back button to return to the form and try again.<hr size=1>
    </td></tr>
   </table>
  </center>
 </body>
</html>
(END ERROR HTML)
        }
    }
    exit;
}
