#!/usr/bin/perl

#################################################################
#   __      ___     _ _             ____              _         #
#   \ \    / (_)   (_) |           |  _ \            | |        #
#    \ \  / / _ ___ _| |_ ___  _ __| |_) | ___   ___ | | __     #
#     \ \/ / | / __| | __/ _ \| '__|  _ < / _ \ / _ \| |/ /     #
#      \  /  | \__ \ | || (_) | |  | |_) | (_) | (_) |   <      #
#       \/   |_|___/_|\__\___/|_|  |____/ \___/ \___/|_|\_\     #
# VisitorBook, Version 1.1.1 of 1/3/00                          #
# Written by Mike Wakerly                                       #
# For support, write: support@command-o.com                     #
# This script is free for commercial and non-commercial use.    #
# You are permitted to modify the script, so long as all        #
# copyright notices remain intact.                              #
#                                                               #
# Redistribution of this script, in whole or part, is not       #
# permitted without the written permission of the author and    #
# FreeScripts. E-Mail license@freescripts.com for more info.    #
#                                                               #
# Neither FreeScripts nor the author shall be held responsible  #
# for sequential and/or consequential damage resulting from the #
# use of this product. Use at your own risk. No warranty. Whew. #
#                                                               #
# Updates & other CGIs found at <http://www.FreeScripts.com/>.  #
#################################################################

#################################################################
# Set up Variables                                              #
#################################################################

# Absolute path to the cgi-lib library.
$cgilib = "/usr/local/etc/httpd/htdocs/visitorbook/cgi-lib.pl";

# This user will be directed to this page after the post is sent.
$thanks = "http://www.yourdomain.xyz/visitorbook/thanks.shtml";

# $mailprog is the path to the mail program on your server.
$mailprog = "/bin/sendmail"; 

# Path to the file that will be placed at the top of the guestbook.
$top = "/usr/local/etc/httpd/htdocs/visitorbook/gb-top.html";

# Path to the file that will be placed at the bottom of the guestbook.
$bottom = "/usr/local/etc/httpd/htdocs/visitorbook/gb-bottom.html";

# Absolute path to the HTML file in which the guestbook will be
# created. 
$main_book = "/usr/local/etc/httpd/htdocs/visitorbook/book.html";

# Absolute path to the database file in which the guestbook entries
# will reside. 
$main_db = "/usr/local/etc/httpd/htdocs/visitorbook/book.db";

# Maximum number of posts allowed on the guestbook.
$max_posts = "100";

# Background color for the header of each message in the book
$head_bg = "#6699FF";

# Background color for the comments of each message in the book
$comments_bg = "#EEEEEE";

# Set each of the following fields to zero if they are not required;
# set to 1 if they are.
$name_reqd = 1;
$email_reqd = 1;
$comments_reqd = 1;
$homepage_reqd = 0;

# Where should new entries appear? Set to "bottom" if you want newest
# entries last; set to "top" if newest entries are first.
$newest = "top";

# $mailuser will e-mail the user a thank you notice when he or she
# signs the guestbook. $thankstxt is the path to the file that has
# the text of the message in it. Set $mailuser to 1 to activate this
# features.
$mailuser = 0;
$thankstxt = "/usr/local/etc/httpd/htdocs/visitorbook/mailthanks.txt";

# $mailadmin will mail this user specified in $adminaddr when a new
# post is added to the guestbook. Be sure to write the @ sign as "\@"
$mailadmin = 0;
$adminaddr = "feedback\@yourdomain.xyz";

# Want to block HTML tags? Set this to 1. Note the tags are not removed;
# the tags are simply commented out. There are a few ways to do this,
# and I thought this way is the safest.
$blockhtml = 1;

# If you'd like the script to insert the posting IP address/host after
# the user's name, set this option to 1. Otherwise, the information
# won't be displayed.
$showip = 1;

#################################################################
# Main Script                                                   #
#################################################################

# You shouldn't need to modify anything down here. If you do, that's
# fine. All I ask is that you don't redistribute modified copies of
# the CGI, and give credit where it is due. In return, I've kept the
# code nicely formatted so it should be easy for you to see what
# is going on. =)

# Make sure we have the cgi-lib library.
require $cgilib;

&ReadParse;

($sec,$min,$hour,$mday,$mon,$year,$wday,$ydat,$isdst) = localtime(time);
$mon++;
if ($min < 10) {
    $min = "0$min";
}

if ($sec < 10) {
    $sec = "0$sec";
}

$time_mode = AM if (!$use_24);

if ($hour > 12 && !$use_24) {
    $hour = $hour - 12;
    $time_mode = "PM";
}
if ($hour eq "0" && !$use_24)   {
    $hour++;
}
$year = substr(($year + 1900), 2, 2);
$date_and_time = "$mon/$mday/$year, $hour:$min $time_mode";
$date = "$mon/$mday/$year";

if  ($ENV{'QUERY_STRING'} eq "refresh") {
    &RefreshBook;
    &Thanks("normal");
}
elsif ($in{'do'} eq "" || $in{'do'} eq "post")  {
    &VerifyEntries;
    &AddPostDB;
    &MailAdmin if ($mailadmin);
    &MailUser if ($mailuser);
    &RefreshBook;
    &Thanks("normal");
}
else    {
    print &PrintHeader;
    print "Unknown Command: $in{'do'}\n";
    exit;
}

#################################################################
# Subroutines                                                   #
#################################################################

#################################################################
# VerifyEntries()                                               #
#                                                               #
# Purpose: This subroutine checks the input of the form. If any #
# required fields are blank, it figures out the name of the     #
# field and gives the user an error.                            #
#################################################################
sub VerifyEntries   {
    if ($in{'fullname'} eq "" && $name_reqd)    {
        $not_found .= "<LI>Your First Name\n";
    }
    if ($in{'email'} eq "" && $email_reqd)  {
        $not_found .= "<LI>Your E-Mail Address\n";
    }
    if ($in{'comments'} eq "" && $comments_reqd)    {
        $not_found .= "<LI>Comments\n";
    }
    if ($in{'web-link'} eq "" && $homepage_reqd)    {
        $not_found .= "<LI>Web Page URL\n";
    }
    
    if ($not_found ne "")   {
        &Error("not_found");
    }
}

#################################################################
# AddPostDB()                                                   #
#                                                               #
# Purpose: This subroutine adds the post to the database file.  #
#################################################################
sub AddPostDB   {
    if ($blockhtml) {
        # This could be better done when input is collected in
        # &ReadParse, but that is in cgi-lib, so I won't mess
        # with it.
        $in{'title'} =~ s/</&lt\;/g;
        $in{'title'} =~ s/>/&gt\;/g;
        $in{'comments'} =~ s/</&lt\;/g;
        $in{'comments'} =~ s/>/&gt\;/g;
        $in{'fullname'} =~ s/</&lt\;/g;
        $in{'fullname'} =~ s/>/&gt\;/g;
        $in{'email'} =~ s/</&lt\;/g;
        $in{'email'} =~ s/>/&gt\;/g;
        $in{'web-link'} =~ s/</&lt\;/g;
        $in{'web-link'} =~ s/>/&gt\;/g;
    }
    
    # Make line-breaks in to HTML.
    $in{'comments'} =~ s/\n/<BR>/g;
    # Get rid of wierd \r's in TEXTAREA input.
    $in{'comments'} =~ s/\r//g;
    
    # Figure out the IP and hostname (if available)
    $ip = $ENV{'REMOTE_ADDR'};
    $host = $ENV{'REMOTE_HOST'};
    
    # Store the IP in the variable user. Then, if we have the
    # hostname (like foo.bar.com), put that in $user instead.
    $user = $ip;
    $user = $host if ($host);
    
    open(MAIN, ">>$main_db");
    flock(MAIN, 2);
    print MAIN "$in{'fullname'}|$in{'email'}|$date_and_time|$in{'web-link'}|$user|$in{'comments'}\n";
    close(MAIN);
    
    open(MAIN, $main_db);
    @entries = <MAIN>;
    close(MAIN);
    
    # Delete old entries is there are more than the max.
    unless ($max_posts < 0) {
        until (@entries <= $max_posts)  {
            shift(@entries);  
        }    
    }
    open(MAIN, ">$main_db");
    print MAIN @entries;
    flock(MAIN, 8);
    close(MAIN);
    
    
}

#################################################################
# RefreshBook()                                                 #
#                                                               #
# Purpose: This subroutine updates the book HTML file           #
# ($main_book) with the current contents of the database file.  #
#################################################################
sub RefreshBook {
    open(TOP, $top);
    @top_book = <TOP>;
    close(TOP);
    
    open(BOTTOM, $bottom);
    @bottom_book = <BOTTOM>;
    close(BOTTOM);

    open(MAIN, $main_db);
    @entries = <MAIN>;
    close(MAIN);
    
    unless ($newest eq "bottom")    {
        @entries = reverse(@entries);
    }
    
    open(BOOK, ">$main_book");
    flock(BOOK, 2);  
    print BOOK @top_book;
    
    print BOOK "<P>\n";
    print BOOK "\n";
    print BOOK "<CENTER>\n\n";
    
    print BOOK "\t<TABLE WIDTH=\"90%\" CELLSPACING=0 BORDER=0>\n";

    foreach $ent (@entries) {
        $count++;
        ($name, $em, $time, $weblink, $user, $comments) = split(/\|/, $ent);
        print BOOK "\t\t<TR><TD VALIGN=\"TOP\" WIDTH=30% BGCOLOR=\"$head_bg\"><B>From:</B> ";
        
        if ($weblink =~/^http:\/\/.*|^https:\/\/.*|^ftp:\/\/.*/)    {
            print BOOK "<A HREF=\"$weblink\">$name</A></TD>";
        }
        else    {
            print BOOK "$name</TD>";
        }
        
        print BOOK "<TD VALIGN=\"TOP\" WIDTH=35% BGCOLOR=\"$head_bg\"><B>E-Mail:</B> <A HREF=\"MAILTO:$em\">$em</A></TD><TD VALIGN=\"TOP\" WIDTH=35% BGCOLOR=\"$head_bg\"><B>Date:</B> $time</TD>\n";
        print BOOK "</TR>\n";
        if ($showip)    {
            print BOOK "\t\t<TR><TD ALIGN=\"LEFT\" WIDTH=\"100%\" COLSPAN=3 BGCOLOR=\"$head_bg\">&nbsp;&nbsp;&nbsp;&nbsp;<FONT SIZE=\"1\">$user</FONT></TD></TR>\n";
        }
        print BOOK "\t\t<TR><TD WIDTH=\"100%\" COLSPAN=3 BGCOLOR=\"$comments_bg\"><BLOCKQUOTE>$comments &nbsp;</BLOCKQUOTE></TD></TR>\n";
    }

    print BOOK "\t</TABLE>\n";
    print BOOK "<BR><BR>\n";
    # Please keep the next line active. Please?
    print BOOK "<FONT SIZE=2><A HREF=\"http://www.freescripts.com/html/visitorbook_main.shtml\">VisitorBook 1.1.0</A> by <A HREF=\"http://www.freescripts.com/\">FreeScripts</A>.</FONT>\n";
    print BOOK "</CENTER>\n";
    
    print BOOK @bottom_book;
    flock (BOOK, 8);
    close(BOOK);
}

sub Thanks  {
    print "Location:$thanks\n\n";
}

sub MailAdmin   {
    open(MAIL, "|$mailprog -t");
    print MAIL "To: $adminaddr\n";
    print MAIL "From: VisitorBook $VBVersion <$adminaddr>\n";
    print MAIL "Subject: New VisitorBook Entry\n";
    print MAIL "\n";
    print MAIL "A new entry to your VisitorBook was added on $date_and_time\n";
    print MAIL "with the following information:\n";
    print MAIL "\n";
    print MAIL "From:     $in{'fullname'} <$in{'email'}>\n";
    print MAIL "Web Page: $in{'web-link'}\n";
    print MAIL "\n";
    print MAIL "Comments: $in{'comments'}\n";
    close(MAIL);
}

sub MailUser    {
    open(THANKS, $thankstxt);
    @datext = <THANKS>;
    close(THANKS);
    
    open(MAIL, "|$mailprog -t");
    print MAIL "To: $in{'email'}\n";
    print MAIL "From: VisitorBook <$adminaddr>\n";
    print MAIL "Subject: VisitorBook Posting\n";
    print MAIL "\n";
    print MAIL @datext;
    close(MAIL);
}

sub Error   {
    local ($reason);
    $reason = @_[0];
    
    print &PrintHeader;
    
    print "<HTML>\n";
    print "<HEAD>\n";
    print "<TITLE>Error!</TITLE>\n";
    print "</HEAD>\n";
    print "<BODY BGCOLOR=\"#FFFFFF\">\n";

    if ($reason eq "not_found") {
        print "<H1 ALIGN=CENTER>Incomplete Entry</H1>\n";
        print "You did not fill out the guestbook form completely. \n";
        print "You need to enter:<P><UL>$not_found</UL><P>Please press your browser's back button to make changes.\n";
    }

    else    {
        print "<H1>Error - Unknown Error (Reason Given: @_)</H1><BR>\n";
    }

    print "</BODY>\n";
    print "</HTML>\n";
    
    exit;
}
