#!/bin/perl
#
#
#
#      Quick-Quiz  1.0
#########################
#AUTHOR: David Powell
#http://www.matrixvault.com/cgi/
# Copyright 1999, David Powell and "The Matrix Vault"
# A Matrix Vault Production.
# Tested and run on a UNIX system with PERL 5
# This script is an original script by David Powell. You may use it free of charge, if you keep this header intact, 
# along with any other copyright notices found in the resulting HTML output or text files generated by this script. 
#  
#########################
require "variables.dat";


#########################
#
#  READ IN THE POSTED VARIABLES
#

read (STDIN, $input, $ENV{'CONTENT_LENGTH'});
@pairs = split(/&/, $input);

foreach $pair (@pairs) {

	($name, $value) = split(/=/, $pair);
   	$value =~ tr/+/ /;
   	$value =~ s/%([a-fA-F0-9][a-fA-F0-9])/pack("C", hex($1))/eg;
   	$value =~ s/<([^>]|\n)*>//g;
   	$value =~ s/<//g;
   	$value =~ s/>//g;
   	$value =~ s/\*/\\\*/g;
   	$value =~ s/\?/\\\?/g;
   	$value =~ s/\+/\\\+/g;
	$FORM{$name} = $value;
	}

#######################
#What to do?
#

	if ($FORM{'reset'} eq "yes")
	{
	&reset;
	&exit;
	}

	if ($ENV{'QUERY_STRING'} eq "admin")
	{
	&admin;
	&exit;
	}
	
	if ($ENV{'QUERY_STRING'} eq "vote")
	{
	&vote;
	&exit;
	}

	if ($ENV{'QUERY_STRING'} eq "build")
	{
	&build;
	&exit;
	}

	if ($ENV{'QUERY_STRING'} eq "results")
	{
	&results;
	&exit;
	}


	&quiz;

################################
#AMIN - simply prints out the admin form
################################
sub admin {
unless (-e "$WORKING_DIR/quiz.dat") {&make_files;}
&read_data;

print "Content-type: text/html\n\n";
print <<__HTML;
<!doctype html public "-//w3c//dtd html 4.0 transitional//en">
<html>
<head>
   <meta http-equiv="Content-Type" content="text/html; charset=iso-8859-1">
   <title>Quick Quiz Administration</title>
</head>
<body>
<form METHOD=POST ACTION="$WORKING_URL/QQ.cgi?build">
<center><font face="Verdana"><font size=+3>Quick-Quiz 1.0</font></font>
<br><font face="Verdana"><font size=+3>ADMIN</font></font></center>

<center><table BORDER=0 CELLSPACING=5 CELLPADDING=3 BGCOLOR="#660000" >
<tr>
<td>
<center><table BORDER=0 COLS=2 WIDTH="100%" BGCOLOR="#FFFFFF" >
<tr>
<td COLSPAN="2">
<center><font face="Verdana"><font color="#000099"><font size=+3>Current
Quiz:</font></font></font></center>
</td>
</tr>


<td>
<div align=right><font face="Verdana">Question:</font></div>
</td>

<td><font face="Verdana">$question</font></td>
</tr>

<tr>
<td VALIGN=TOP>
<div align=right><font face="Verdana">Possible answers:<BR><font face="Verdana" size=-2>(CURRENT VOTE COUNT)</font></div>
</td>

<td><font face="Verdana">$answerA($countA)</font>
<br><font face="Verdana">$answerB($countB)</font>
<br><font face="Verdana">$answerC($countC)</font>
<br><font face="Verdana">$answerD($countD)</font>
<br><font face="Verdana">$answerE($countE)</font>
<br><font face="Verdana">$answerF($countF)</font>
<br><font face="Verdana">Total Votes:$TOTAL</td>
</tr>

<tr>
<td COLSPAN="2">
<center><b><font face="Verdana">Command Line:</font></b></center>
</td>
</tr>

<tr>
<td COLSPAN="2">
<center><b><font color="#006600">&lt;!--#exec cgi="/your_cgi-bin/QQ.cgi?quiz"--></font></b></center>
</td>
</tr>

<tr>
<td COLSPAN="2">
<center><font face="Verdana"><font color="#FF0000"><font size=+3>New Quiz:</font></font></font></center>
</td>
</tr>
</table></center>

<center><table BORDER=0 CELLSPACING=3 CELLPADDING=3 WIDTH="100%" BGCOLOR="#FFFFFF" >
<tr>

<td>
<div align=right><font face="Verdana">Question:</font>
<br><font face="Verdana"><font size=-2>(The <b>Question</b> you wish to
ask users.)</font></font></div>
</td>

<td><input NAME="question" TYPE="text" SIZE="25"></td>
</tr>

<tr>
<td VALIGN=TOP>
<div align=right><font face="Verdana">Multiple choice Answers:</font></div>
</td>

<td><font face="Verdana">A.</font><input NAME="A" TYPE="text" SIZE="25" value="none">
<br><font face="Verdana">B.</font><input NAME="B" TYPE="text" SIZE="25" value="none">
<br><font face="Verdana">C.</font><input NAME="C" TYPE="text" SIZE="25" value="none">
<br><font face="Verdana">D.</font><input NAME="D" TYPE="text" SIZE="25" value="none">
<br><font face="Verdana">E.</font><input NAME="E" TYPE="text" SIZE="25" value="none">
<br><font face="Verdana">F.</font><input NAME="F" TYPE="text" SIZE="25" value="none">
<br><font face="Verdana">Reset?<input TYPE="checkbox"  NAME="reset"  VALUE="yes"></td>
</tr>

<tr>
<td><font face="Verdana">Enter Password to continue:</font></td>

<td><input NAME="password" TYPE="text" SIZE="25"></td>
</tr>
</table></center>

<center><input TYPE="submit" VALUE="Build it."></center>
</td>
</tr>
</table>
</form></center>

</body>
</html>
__HTML
exit;
}
############################
# BUILD DAT files from admin page.
############################

sub build 
{

$PW_entered = $FORM{'password'};

if ($PW_entered ne "$PW")	{
			&error ("ACCESS DENIED! INVALID PASSWORD!");
			}

$answerA=$FORM{'A'};
$answerA =~ s/\\//g;
$answerB=$FORM{'B'};
$answerB =~ s/\\//g;
$answerC=$FORM{'C'};
$answerC =~ s/\\//g;
$answerD=$FORM{'D'};
$answerD =~ s/\\//g;
$answerE=$FORM{'E'};
$answerE =~ s/\\//g;
$answerF=$FORM{'F'};
$answerF =~ s/\\//g;
$question = $FORM{'question'};
$question =~ s/\\//g;
if ($question eq"") {&error ("You did not enter a question!");}
if ($answerA eq "none"){&error ("Answer A cannot be \"none\"");}
if ($answerA eq ""){&error ("Answer A cannot be blank! You must use at least A as an answer.");}
if ($answerB eq ""){&error ("Answer B cannot be blank! If you dont want to use this letter, leave it as \"none\"");}
if ($answerC eq ""){&error ("Answer C cannot be blank! If you dont want to use this letter, leave it as \"none\"");}
if ($answerD eq ""){&error ("Answer D cannot be blank! If you dont want to use this letter, leave it as \"none\"");}
if ($answerE eq ""){&error ("Answer E cannot be blank! If you dont want to use this letter, leave it as \"none\"");}
if ($answerF eq ""){&error ("Answer F cannot be blank! If you dont want to use this letter, leave it as \"none\"");}


unlink "$WORKING_DIR/answerA.dat";

unlink "$WORKING_DIR/answerB.dat";

unlink "$WORKING_DIR/answerC.dat";

unlink "$WORKING_DIR/answerD.dat";

unlink "$WORKING_DIR/answerE.dat";

unlink "$WORKING_DIR/answerF.dat";

unlink "$WORKING_DIR/quiz.dat";

unlink "$WORKING_DIR/IP.log";

&make_files;
print "Location: $WORKING_URL/QQ.cgi?admin\n\n";
}


################
# VOTE!
################

sub vote
{
&check_ip;

	$vote = $value;
	open (FILE_VOTE, "answer$vote.dat") || &error ("Cannot open answer$vote.dat");
	$line= <FILE_VOTE>;
	close (FILE_VOTE);
	open (FILE_VOTE, ">answer$vote.dat") || &error ("Cannot open answer$vote.dat");
	($answer, $count) = split(/\|/,$line);
	$count++;
	print FILE_VOTE ("$answer|$count");
	close (FILE_VOTE);
	print "Location: $home\n\n";
}
################
# Check for ballat stuffing
################
sub check_ip {

	$addr = $ENV{'REMOTE_ADDR'};
	open (IP, "$WORKING_DIR/IP.log");
	while (<IP>) {
   		chop;
		$log_address = $_;
   		if ($log_address eq $addr) {
					close(IP);
					print "Location: $home\n\n";
					&exit;
					}
		}
		close(IP);

	open (IP, ">>$WORKING_DIR/IP.log");
	print IP "$addr\n";
	close(IP);
	    }
################
#  ERROR HANDLING
################
sub error
{
	print "Content-type: text/html\n\n";
	print "<HTML><BODY>";
	print "<BOLD><p><FONT size=+1>Quick Quiz Error:<FONT COLOR=\"#FF0000\"> <B>$_[0]</B></FONT></FONT><BR>";
	print "Press your back button and try again.</p>";
	exit;
}

sub read_data 
{
####################################
# Reads all data files and returns with text and counts.
# Returns with each $answerA,B,etc.. and each count
####################################
			$TOTAL = 0;
			open(FILE,"$WORKING_DIR/quiz.dat")|| &error ("Cannot Open $WORKING_DIR/quiz.dat!!");
			$question =<FILE>;
			close (FILE);

			open(FILEA, "answerA.dat") || &error ("Cannot Open answerA.dat");
			$line = <FILEA>;
			($answer, $count) = split(/\|/, $line);
			$answerA = "$answer";
			$countA = "$count";
			$TOTAL = $TOTAL + $count;
			close (FILEA);


			open(FILEB, "answerB.dat") || &error ("Cannot Open answerB.dat");
			$line = <FILEB>;
			($answer, $count) = split(/\|/, $line);
			$answerB = "$answer";
			$countB = "$count";
			$TOTAL = $TOTAL + $count;
			close (FILEB);

			open(FILEC, "answerC.dat") || &error ("Cannot Open answerC.dat");
			$line = <FILEC>;
			($answer, $count) = split(/\|/, $line);
			$answerC = "$answer";
			$countC = "$count";
			$TOTAL = $TOTAL + $count;
			close (FILEC);


			open(FILED, "answerD.dat") || &error ("Cannot Open answerD.dat");
			$line = <FILED>;
			($answer, $count) = split(/\|/, $line);
			$answerD = "$answer";
			$countD = "$count";
			$TOTAL = $TOTAL + $count;
			close (FILED);

			open(FILEE, "answerE.dat") || &error ("Cannot Open answerE.dat");
			$line = <FILEE>;
			($answer, $count) = split(/\|/, $line);
			$answerE = "$answer";
			$countE = "$count";
			$TOTAL = $TOTAL + $count;
			close (FILEE);


			open(FILEF, "answerF.dat") || &error ("Cannot Open answerF.dat");
			$line = <FILEF>;
			($answer, $count) = split(/\|/, $line);
			$answerF = "$answer";
			$countF = "$count";
			$TOTAL = $TOTAL + $count;
			close (FILEF);
#  Get percentages
			if ($TOTAL > 0)
			{
			$percentA = ($countA/$TOTAL) * 100;
    			$percentA = sprintf("%2.0f",$percentA);
			$percentB = ($countB/$TOTAL) * 100;
			$percentB = sprintf("%2.0f",$percentB);
			$percentC = ($countC/$TOTAL) * 100;
			$percentC = sprintf("%2.0f",$percentC);
			$percentD = ($countD/$TOTAL) * 100;
			$percentD = sprintf("%2.0f",$percentD);
			$percentE = ($countE/$TOTAL) * 100;
			$percentE = sprintf("%2.0f",$percentE);
			$percentF = ($countF/$TOTAL) * 100;	
			$percentF = sprintf("%2.0f",$percentF);	
			}
}
################
#  QUIZ BOX - makes the quizbox on your website.
################
sub quiz
{
&read_data;

print "Content-type: text/html\n\n";
print <<__HTML;
<form METHOD=POST ACTION="$WORKING_URL/QQ.cgi?vote">
<center><table WIDTH="$display_width" BORDER=0 CELLSPACING=0 CELLPADDING=2 BGCOLOR="$table_outline" >
<tr>
<td>
<center><table BORDER=0 COLS=2 CELLSPACING=2 CELLPADDING=2 WIDTH="$display_width" BGCOLOR="$BG_COLOR" >
<tr>
<td COLSPAN="2">
<center><font face="Verdana" color="$text_color"><font size=+1>$TITLE</font></font></center>
</td>
</tr>

<tr>
<td COLSPAN="2">
<center><font face="Verdana" color="$text_color"><font size=-1>$question</font></font></center>
</td>
</tr>

<tr>
<td WIDTH="75%">
<div align=right><font face="Verdana" color="$text_color"><font size=$font_size>$answerA</font></font></div>
</td>

<td WIDTH="25%"><input TYPE=radio NAME=vote VALUE="A"><font face="Verdana" color="$text_color"><font size=$font_size>$countA($percentA%)</td>
</tr>
__HTML

if ($answerB ne "none"){ print <<__HTML;
<tr>
<td WIDTH="75%">
<div align=right><font face="Verdana" color="$text_color"><font size=$font_size>$answerB</font></font></div>
</td>

<td WIDTH="25%"><input TYPE=radio NAME=vote VALUE="B"><font face="Verdana" color="$text_color"><font size=$font_size>$countB($percentB\%)</td>
</tr>
__HTML
}
if ($answerC ne "none"){ print <<__HTML;
<tr>
<td WIDTH="75%">
<div align=right><font face="Verdana" color="$text_color"><font size=$font_size>$answerC</font></font></div>
</td>

<td WIDTH="25%"><input TYPE=radio NAME=vote VALUE="C"><font face="Verdana" color="$text_color"><font size=$font_size>$countC($percentC\%)</td>
</tr>
__HTML
}
if ($answerD ne "none"){ print <<__HTML;
<tr>
<td WIDTH="75%">
<div align=right><font face="Verdana" color="$text_color"><font size=$font_size>$answerD</font></font></div>
</td>

<td WIDTH="25%"><input TYPE=radio NAME=vote VALUE="D"><font face="Verdana" color="$text_color"><font size=$font_size>$countD($percentD\%)</td>
</tr>
__HTML
}
if ($answerE ne "none"){ print <<__HTML;
<tr>
<td WIDTH="75%">
<div align=right><font face="Verdana" color="$text_color"><font size=$font_size>$answerE</font></font></div>
</td>

<td WIDTH="25%"><input TYPE=radio NAME=vote VALUE="E"><font face="Verdana" color="$text_color"><font size=$font_size>$countE($percentE\%)</td>
</tr>
__HTML
}
if ($answerF ne "none"){ print <<__HTML;
<tr>
<td WIDTH="75%">
<div align=right><font face="Verdana" color="$text_color"><font size=$font_size>$answerF</font></font></div>
</td>

<td WIDTH="25%"><input TYPE=radio NAME=vote VALUE="F"><font face="Verdana" color="$text_color"><font size=$font_size>$countF($percentF\%)</td>
</tr>
__HTML
}
print <<__HTML;
<tr>
<td>
<div align=right><font face="Verdana" color="$text_color"><font size=$font_size>Total votes in:</font></font></div>
</td>

<td><b><font face="Verdana" color="$text_color"><font size=$font_size>$TOTAL</font></font></b></td>
</tr>

<tr>
<td COLSPAN="2">
<center><input TYPE="submit" VALUE="Vote"></center>
</td>
</tr>
</table></center>
</td>
</tr>
</table></center>
</form>
__HTML
}

sub reset
{
unlink "$WORKING_DIR/answerA.dat";

unlink "$WORKING_DIR/answerB.dat";

unlink "$WORKING_DIR/answerC.dat";

unlink "$WORKING_DIR/answerD.dat";

unlink "$WORKING_DIR/answerE.dat";

unlink "$WORKING_DIR/answerF.dat";

unlink "$WORKING_DIR/quiz.dat";

unlink "$WORKING_DIR/IP.log";

&make_files;

		print "Location: $WORKING_URL/QQ.cgi?admin\n\n";
}

sub make_files
{
open(FILE,">$WORKING_DIR/quiz.dat") || &error ("Cannot Open quiz.dat!!");
print FILE "$question";
close (FILE);
			open(FILEA, ">answerA.dat") || &error ("Cannot Open answerA.dat");
			print FILEA "$answerA|0";
			close (FILEA);
	
			open(FILEB, ">answerB.dat") || &error ("Cannot Open answerB.dat");
			print FILEB "$answerB|0";
			close (FILEB);

			open(FILEC, ">answerC.dat") || &error ("Cannot Open answerC.dat");
			print FILEC "$answerC|0";
			close (FILEC);

			open(FILED, ">answerD.dat") || &error ("Cannot Open answerD.dat");
			print FILED "$answerD|0";
			close (FILED);

			open(FILEE, ">answerE.dat") || &error ("Cannot Open answerE.dat");
			print FILEE "$answerE|0";
			close (FILEE);

			open(FILEF, ">answerF.dat") || &error ("Cannot Open answerF.dat");
			print FILEF "$answerF|0";
			close (FILEF);
}

##################
# EXIT
##################
sub exit
{exit;}

