#!c:\perl\bin\perl
#########################################################################
# Estatsticas de Acesso                                                #
# Ajustada e traduzida por: Pedro Rubini (Arc4njo)                      #
#########################################################################

# url to an image file
$output = "http://127.0.0.1/cgi-bin/status/blank.gif";

# create log files in this dir (chmod to 666 if needed) - path with no trailing "/"
$base_dir = "c:/xitami/cgi-bin/status";

# log file extension
$log_file_ext = "txt";

# path to IP log file
$ip_file = "ip.txt";

# time (in min) to keep visitor IP in table (anti-reloading)
$ip_time = 30;

# Done
###########

use Net::hostent;
use Socket;

open(FILE,"$ip_file");
@lines = <FILE>;
close(FILE);
$found = 0;
$this_time = time();

open(TABLE,">$ip_file");
foreach $visitor (@lines) {
  ($ip_addr,$time_stamp) = split(/\|/,$visitor);
  if ($this_time < $time_stamp+(60*$ip_time)) {
    if ($ip_addr eq $ENV{'REMOTE_ADDR'}) {
      $found=1;
    }
    else {
      print TABLE "$ip_addr|$time_stamp";
    }
  }
}
print TABLE "$ENV{'REMOTE_ADDR'}|$this_time\n";
close(TABLE);

if ($found == 0) {
  $host = &get_host();
  &parse_ref();
  &write_log();
}

print "Location: $output\n\n";
exit (0);

sub parse_ref {
   $query = $ENV{'QUERY_STRING'};
   ($value, $referer) = split(/=/, $query);
   if ($referer) {
     if ($referer =~ /(http:\/\/.*\.[a-z]{2,4}\/)/i) {
      $referer = $1;
     }
   }
   else {
     $referer = "-";
  }
}

sub write_log {

@months = ('January','February','March','April','May','June','July','August','September','October','November','December');
@days = ('Sun','Mon','Tue','Wed','Thu','Fri','Sat');

($min,$hour,$mday,$mon,$year,$wday) = (localtime(time))[1,2,3,4,5,6];
$min = "0$min" if ($min < 10);
$hour = "0$hour" if ($hour < 10);
$mday = "0$mday" if ($mday < 10);
$year += 1900;

$month = $mon+1;
$month = "0$month" if ($month < 10);

$logdat = "$base_dir/$month-$year\.$log_file_ext";
$this_day = ("$days[$wday] $mday-$months[$mon]-$year $hour:$min");

open(DATA,">>$logdat");
print DATA ("$this_day - $ENV{'REMOTE_ADDR'} - $host - \"$ENV{'HTTP_USER_AGENT'}\" - \"$referer\"\n");
close (DATA);
}

sub get_host {
 
  my $ip_address = $ENV{'REMOTE_ADDR'};
  my $host_name = gethost($ip_address);
  my $host = $host_name->name;
  return ($host) ? $host : $ip_address;

}

