#!/usr/bin/perl

#************************************************
# sprainbook
# Created on May 23, 2001
# Manuel Reinhard, manu@sprain.ch, http://www.sprain.ch/scripts
#************************************************
# Add modifications here:
#
# Version 1.11
# 21/05/02 - sprain - updated e-mail addresses and URLs
#					- made better baderror-routine
#
# Version 1.1b
# 05/06/01 - sprain - Fixed bug that allowed spaces in e-mail address
#                   - Fixed bug concerning own oopspage
#                   - Fixed bug in date routine
#                   - Added file locking
#                   - Simplified sendmail routine
#                   - Added substitute routine (e.q. for umlaute)
#                   - Added URL check
#               
# Version 1.0b
# 25/05/01 - sprain - Finished this script
#
#************************************************
# This program is free software. It may be used and modified free   
# of charge for personal, academic or non-profit use. By using this     
# script you agree to indemnify sprain from any liability.               
# Please do not remove this copyright notice. 
#
# For information about installation please read
# readme.txt.
#
# The latest version of this script can be found
# at http://www.sprain.ch/scripts  
#************************************************


#************************************************
#************************************************
# Done! Don't change anything beyond this point #
# unless you really know what you're doing!!    #
#************************************************
#************************************************




# use modules
use CGI qw(:standard);
$query = new CGI;
#************************************************
#set variables for setup
$program_file = "sprainbook.cgi";
$program_name = "sprainbook";
$version = "v1.11";
$copyright ="(c)2001 <a href='http://www.sprain.ch/scripts'>sprain</a>";

$del1 ="-!-!-!-!-";
$del2 =":-:-:";
$setupfile = "sprainbook_setup.txt";
$passfile = "sprainbook_pass.txt";
$entryfile = "sprainbook_entries.txt";

#************************************************
#read variables for program
$REQUIRED = param('required');
$CHECKEMAIL = param('checkemail');
$CHECKURL = param('checkurl');

#read variables for setup
$action = $query->param('action');
$pass1 = $query->param('PASS1');
$pass2 = $query->param('PASS2');
$user = $query->param('USER');
$user = $query->param('USER');
$setup_template = $query->param('TEMPLATE');
$setup_email = $query->param('EMAIL');
$setup_subject = $query->param('SUBJECT');
$setup_badwords = $query->param('BADWORDS');
$setup_replace = $query->param('REPLACE');
$setup_perpage = $query->param('PERPAGE');
$setup_dateformat = $query->param('DATEFORMAT');
$sendmail = $query->param('SENDMAIL');
$setup_mail = $query->param('MAIL');
$setup_oopspage = param('OOPSPAGE');
$setup_ownoops = param('OWNOOPS');
#************************************************
#choose sub for program
if ($action eq "newentry"){newentry();}
if ($action eq "make_pass"){make_pass();}
if ($action eq "check_pass"){check_pass();}
if ($action eq "ask_pass"){ask_pass();}

#choose sub for setup
if ($ENV{'QUERY_STRING'} eq "setup"){setup();}
if ($action eq "make_setup"){make_setup();}
if ($action eq "make_pass"){make_pass();}
if ($action eq "check_pass"){check_pass();}
if ($action eq "ask_pass"){ask_pass();}
#************************************************
# start real program
check_setup();
read_setup();


#************************************************
# Here comes the real script
#************************************************

# read template
$path=$setup_template;
open(FILE, $path) || configerror("The file defined as template ($setup_template) has not been found.<br>Please contact the owner of this script: <a href='mailto:$setup_email'>$setup_email<\/a>");
    while (<FILE>) {
    $templatefile.=$_;
    } #while
close(FILE);

#search for sprainbook-part
@template=split(/\[REPEAT\]/,$templatefile);
@template2=split(/\[REPEAT_END\]/,$template[1]);
$realpart=$template2[0];

#prepare reading entries
$fromentry=$ENV{'QUERY_STRING'};
if ($fromentry=~ /\D/ || $fromentry eq "" || $fromentry == 0){$fromentry=1;}
$untilentry=($fromentry+$setup_perpage)-1;

#read entries
$counter=0;
$path=$entryfile;
#only if entry file exists
if (-e $path){
open(FILE, $path) || baderror("001");
    #prepare output
    while(<FILE>) {
    	$entryline = $_;
    	$make_output=$realpart;
    	@entry1=split(/$del1/,$entryline);
    	foreach $entryvalue(@entry1){
    		@entry2=split(/$del2/,$entryvalue);
    		$name = $entry2[0];
    		$value = $entry2[1];
    		#format date
    		if($name eq "DATE"){$value=&make_date($value,$setup_dateformat);}
    		#censor bad words
   		    @badwords=split(/,/,$setup_badwords);
   		    foreach $badword(@badwords){
   		    $value =~s /$badword/$setup_replace/gi;
   		    }#foreach   		
    		#substitute
    		$value=&ersetzen($value);
    		$make_output=~ s/\[$name\]/$value/g;
    		#does if-field exist?
    		if($make_output=~ /\[IF_$name\]/){
    			if($value eq ""){
    			push(@if_fields,$name);
    			} #if
    		}#if
    	} #foreach
    	#count
    	$counter++;
    	#delete empty if-fields
    	while (@if_fields){
    	$if_field=pop(@if_fields);
    	$make_output=~ s/\[IF\_$if_field\].*?\[IF\_$if_field\_END\]//gs;;
    	}#while
    	#delete if-fields
    	$make_output=~ s/\[IF\_.*?\]//gs;;
    	$make_output=~ s/\[IF\_.*?\_END\]//gss;
    	#is entry to be displayed?
    	if ($counter >= $fromentry && $counter <= $untilentry){
    	$outputline.=$make_output;
    	} #if
    } #while
close(FILE);
} #if

#count pages
$pages = int($counter/$setup_perpage);
if ($counter>($setup_perpage*$pages)){$pages++;}

#make pages line
$total = $counter;
$counter=1;
while ($counter<=$pages){
$pagevalue=(($counter-1)*$setup_perpage)+1;
if ((($counter-1)*$setup_perpage)<$fromentry && (($counter)*$setup_perpage)+1>$fromentry){
$pageline .= "<b>$counter<\/b>&nbsp;&nbsp;";
}else{
$pageline .= "<a href='$program_file?$pagevalue'>$counter<\/a>&nbsp;&nbsp;";
} #if
$counter++;
}

#finish output
$output = $template[0].$outputline.$template2[1];
$output =~ s/\[PAGES\]/$pageline/g;
$output =~ s/\[TOTAL\]/$total/g;

#output
start_html();
print header();
print <<START_HTML;
<body bgcolor="white">
$output
START_HTML
end_html();
exit;


#************************************************
sub newentry{
#prepare
check_setup();
read_setup();

@names = $query->param;


# split required-fields
$REQUIRED=~s/\012//g;
$REQUIRED=~s/\015//g;
$REQUIRED=~s/ //g;
@required=split(/,/,$REQUIRED);

# check required-fields
foreach $test_required(@required)
{
$test_now=param($test_required);

	#does field exist?
    $checker = 2;
    foreach $checkit(@names){
    if ($checkit eq  $test_required){$checker = 1;} 
    } #foreach
    
    # if field has not been found give warning
    if ($checker == 2){configerror("<b>Error 102:<\/b><br>The required field '$test_required' has not been found.<br>Please contact the owner of this script: <a href='mailto:$setup_email'>$setup_email<\/a>");}

	# if field exists check it
	if ($test_now eq "")
	{
		if ($setup_oopspage ne "" && $setup_ownoops eq "yes"){
		print $query->redirect($setup_oopspage);
		exit;
		} else {
		oopspage("Make sure you filled in all the required fields!");
		} #if
	} #if
} #foreach


#checkemail
if ($CHECKEMAIL ne ""){
	
	#does field exist?
    my $checker = 2;
    foreach $checkit(@names){
    if ($checkit eq  $CHECKEMAIL){$checker = 1;} 
    } #foreach
    
    # if field has not been found give warning
    if ($checker == 2){configerror("<b>Error 101:<\/b><br>The field defined for e-mail check ($CHECKEMAIL) has not been found.<br>Please contact the owner of this script: <a href='mailto:$setup_email'>$setup_email<\/a>");}
        
    # if exists check email
	if (&checkemail(param($CHECKEMAIL)) == 0){
		if ($setup_oopspage ne "" && $setup_ownoops eq "yes"){
		print $query->redirect($setup_oopspage);
		exit;
		} else {
		oopspage("The email address you entered is not valid!");
		} #if
	}#if
} #if


#read all values
foreach(@names)
        {
        $name = $_;
        
        if ($name ne "action" && $name ne "required" && $name ne "checkemail" && $name ne "checkurl"){
    	# read all fields except some special fields
    	$value = $query->param($name);    	   	
       	
       	#URL-Check if necessary
       	if ($CHECKURL ne ""){
       	if ($name eq $CHECKURL && $value ne ""){$value=&checkurl($value);}
       	}#if

        
   		     #do some silly stuff with values
   		     chomp($value);
   		     #prepare mail
 		     $mail_content .= "$name: $value\n\n";
 		     #kill newlines
   		     $value =~s /\015\012|\015|\012/<br>/g;
 		     #prepare entry
   		     $newentryline .= $name.$del2.$value.$del1;
        } #if
                             
    	} #foreach

#get date
$date = time();
$newentryline .= "DATE".$del2.$date."\n";

#make entry

$path=$entryfile;
if (-e $path){
open(FILE, $path) || baderror("002");
    while (<FILE>) {
    $oldentries .= $_
    } #while
close(FILE);
} #if

open(DAT, ">$path") || baderror("003");
flock(DAT, 1);
print DAT $newentryline;
print DAT $oldentries;
flock(DAT, 8);
close(DAT);

#send mail
if($setup_mail eq "yes"){
mail();
} #if
} #sub

#************************************************
sub oopspage{
my $oops_message=$_[0];

start_html();
print header();
print <<START_HTML;
<body bgcolor="white"><h1>Oops!</h1>
An error has occured:<br><br>
<b>$oops_message</b>
<br><br>
<a href="javascript:history.back()">to previous page</a><br><br>
<br><br>
<font size="2">$program_name $version, $copyright</font>
START_HTML
end_html();
exit;

} #sub

#************************************************
sub configerror{
my $oops_message=$_[0];

start_html();
print header();
print <<START_HTML;
<body bgcolor="white"><h1>Config Error</h1>
An error has occured:<br><br>
$oops_message
<br><br>
<a href="javascript:history.back()">to previous page</a><br><br>
<br><br>
<font size="2">$program_name $version, $copyright</font>
START_HTML
end_html();
exit;

} #sub


#************************************************
# Setup Stuff
#************************************************
sub setup{
#if making setup is allowed
get_pass();
} #sub

#************************************************
sub ask_setup{
$setup_file_exist=$_[0];
#Does setup file exist? 1=no, 2=yes
if ($setup_file_exist != 1){
#if yes, read variables
read_setup();
}
print_setup_page();
} #sub

#************************************************
sub make_setup{

#check setup (1=not valid; 2=valid)
$setup_valid=2;
$setup_message="";
if (($setup_template !~ /^\// && $setup_template !~ /^\$ENV/)|| $setup_template =~ /\s/){$setup_valid=1; $setup_message.="<font color='red'><li>The 'Path to Template' you specified is not valid</font>";}
if ($setup_perpage =~ /\D/){$setup_valid=1; $setup_message.="<font color='red'><li>The 'Number of entries per page' you specified is not valid</font>";}
if ($setup_ownoops eq "yes"){
if ($setup_oopspage !~ /^http:\/\//){$setup_valid=1; $setup_message.="<font color='red'><li>The 'URL to your error page' you specified is not valid</font>";}
}else{
$setup_ownoops = "no";
} #if
if ($setup_dateformat eq ""){$setup_valid=1; $setup_message.="<font color='red'><li>The 'date format' you specified is not valid</font>";}
if ($setup_mail eq "yes"){
if ($sendmail !~ /^\// || $sendmail =~ /\s/){$setup_valid=1; $setup_message.="<font color='red'><li>The 'Path to sendmail' you specified is not valid</font>";}
if (&checkemail($setup_email) == 0){$setup_valid=1; $setup_message.="<font color='red'><li>The E-mail address you specified is not valid</font>";}
if ($setup_subject eq ""){$setup_valid=1; $setup_message.="<font color='red'><li>The 'Subject' you specified is not valid</font>";}
}else{
$setup_mail = "no";
} #if

$setup_badwords=~s/\012//g;
$setup_badwords=~s/\015//g;
$setup_badwords=~s/ //g;

if ($setup_valid==1){
#if setup is not valid
print_setup_page();
} else {
#if setup is valid
#write setup file
$path=$setupfile;
open(DAT, ">$path") || baderror("004");
print DAT $setup_template.$del1.$setup_email.$del1.$setup_subject.$del1.$setup_badwords.$del1.$setup_replace.$del1.$setup_perpage.$del1.$setup_dateformat.$del1.$sendmail.$del1.$setup_mail.$del1.$setup_ownoops.$del1.$setup_oopspage;
close(DAT);
$setup_message.="<li>Your setup has been updated!";
print_setup_page();
} #if

} #sub

#************************************************
sub print_setup_page{

#Date-Variations
$date1=&make_date(time(),1);
$date2=&make_date(time(),2);
$date3=&make_date(time(),3);
$date4=&make_date(time(),4);
$date5=&make_date(time(),5);
$date6=&make_date(time(),6);
$date7=&make_date(time(),7);
$date8=&make_date(time(),8);
$date9=&make_date(time(),9);
$date10=&make_date(time(),10);
if($setup_dateformat!=0){
$setup_date=&make_date(time(),$setup_dateformat);
}#if

if($setup_mail eq "yes"){$mailchecked="checked";}
if($setup_ownoops eq "yes"){$oopschecked="checked";}

# print setup page
start_html();
print header();
print <<START_HTML;
<body bgcolor="white"><h1>$program_name Setup</h1>
$setup_message
<br><br>You need to setup your $program_name first! If you don't know some of the information ask your hoster!<br>
<form name="form1" method="post" action="$program_file">
<input type="hidden" name="action" value="make_setup">
<b>Paths</b><br>
    Path to your template:<br>
    <input type="text" name="TEMPLATE" value="$setup_template" size="50">
    <br>
    <br>
    <br>
    <b>sprainbook</b><br>
    Number of entries on one page:<br>
    <input type="text" name="PERPAGE" value="$setup_perpage" size="50">
    <br>
    <br>
    Select how you want the date to be formatted:<br>   
    <select name="DATEFORMAT">
    <option value="$setup_dateformat">$setup_date</option>
    <option value="1">$date1</option>
    <option value="2">$date2</option>
    <option value="3">$date3</option>
    <option value="4">$date4</option>
    <option value="5">$date5</option>
    <option value="6">$date6</option>
    <option value="7">$date7</option>
    <option value="8">$date8</option>
    <option value="9">$date9</option>
    <option value="10">$date10</option>
    </select>
    <br>
    <br>
    Bad words which will be censored (separate with comma)<br>
    <input type="text" name="BADWORDS" value="$setup_badwords" size="50">
    <br>
    <br>
    Expression to replace bad words with:<br>
	<input type="text" name="REPLACE" value="$setup_replace" size="50">
    <br>
    <br>
   	<input type="checkbox" name="OWNOOPS" value="yes" $oopschecked> Check if you want to use your own error page
    <br>
    <br>
    URL to error page (incl. 'http://'):<br>
    <input type="text" name="OOPSPAGE" value="$setup_oopspage" size="50">
    <br>
    <br>
    <br>
    <b>E-Mail</b><br>
    <input type="checkbox" name="MAIL" value="yes" $mailchecked> Check if you want to get an e-mail after each new entry<br><br>
    E-mail address which gets information when there is a new guestbook entry:<br>
    <input type="text" name="EMAIL" value="$setup_email" size="50">
    <br>
    <br>
    Subject of message which tells you about a new guestbook entry:<br>
	<input type="text" name="SUBJECT" value="$setup_subject" size="50">
    <br>
    <br>
     Path to sendmail:<br>
    <input type="text" name="SENDMAIL" size="50" value="$sendmail">
    <br>
    <br>
  <input type="submit" value="Do Setup!">
</form>
<form name="form1" method="post" action="$program_file">
<input type="hidden" name="action" value="ask_pass">
<input type="submit" value="I want to change my Username and Password!">
</form>
<font size="2">$program_name $version, $copyright</font>
START_HTML
end_html();
exit;
} #sub
#************************************************
sub check_setup{
if(-e $setupfile){}else{
start_html();
print header();
print <<START_HTML;
<body bgcolor="white"><h1>Oops!</h1>
Before running this program run setup.<br>
Read readme.txt for more information.<br><br>
<b>If you're not the owner of this program please inform the owner.</b><br><br>
<a href="javascript:history.back()">to previous page</a><br><br>
<font size="2">$program_name $version, $copyright</font>
START_HTML
end_html();
exit;
} #if
} #sub

#************************************************
sub read_setup{
$path=$setupfile;
open(FILE, $path) || setup();
    while (<FILE>) {
    @variables = split(/$del1/);
    } #while
close(FILE);

$setup_template = $variables[0];
$setup_email = $variables[1];
$setup_subject = $variables[2];
$setup_badwords = $variables[3];
$setup_replace = $variables[4];
$setup_perpage = $variables[5];
$setup_dateformat = $variables[6];
$sendmail = $variables[7];
$setup_mail = $variables[8];
$setup_ownoops = $variables[9];
$setup_oopspage = $variables[10];
} #sub


#************************************************
# Password Stuff
#************************************************
sub ask_pass{

# print make password page
start_html();
print header();
print <<START_HTML;
<body bgcolor="white"><h1>$program_name Password</h1>
You need to create a password first!<br>
<br>
<form name="form1" method="post" action="$program_file">
<input type="hidden" name="action" value="make_pass">
  Username:<br>  
  <input type="text" name="USER" size="50" maxlength="12">
    <br>
    <br>
  Password (4 to 8 characters, case-sensitive):<br>    
  <input type="password" name="PASS1" size="50" maxlength="8">
    <br>
  <br>
  Re-type Password (just to make sure you didn't misspell it):<br>
  <input type="password" name="PASS2" size="50" maxlength="8">
  <br>
  <br>
  <input type="submit" value="Create Password!">
</form>
<br><br>
<font size="2">$program_name $version, $copyright</font>
START_HTML
end_html();
exit;

} #sub

#************************************************
sub make_pass{

#check Password (1=not valid; 2=valid)
$pass_valid=2;
if (length($pass1)<4){$pass_valid=1;}
if ($pass1=~ /\W/){$pass_valid=1;}
if ($pass1 ne $pass2){$pass_valid=1;}

#check Username
if (length($user)<4){$pass_valid=1;}
if ($user=~ /\W/){$pass_valid=1;}

# if password not valid
if ($pass_valid==1){
start_html();
print header();
print <<START_HTML;
<body bgcolor="white"><h1>$program_name Password</h1>
<b>Oops! Something wrent wrong! Try again.</b><br><br>
<li>Make sure your username and password only contains a-z, A-Z and 0-9
<li>Both username and password must have at least 4 characters
<li>The two passwords you type in must be the same!<br>
<form name="form1" method="post" action="$program_file">
<input type="hidden" name="action" value="make_pass">
  Username:<br>  
  <input type="text" name="USER" size="50" maxlength="12">
    <br>
    <br>
  Password (4 to 8 characters, case-sensitive):<br>    
  <input type="password" name="PASS1" size="50" maxlength="8">
    <br>
  <br>
  Re-type Password (just to make sure you didn't misspell it):<br>
  <input type="password" name="PASS2" size="50" maxlength="8">
  <br>
  <br>
  <input type="submit" value="Create Password!">
</form>
<br><br>
<font size="2">$program_name $version, $copyright</font>
START_HTML
end_html();
exit;
} #if

#write passwd file
$path=$passfile;
open(DAT, ">$path") || baderror("005");
print DAT $user.$del1.crypt($pass1,$pass1);
close(DAT);

#do setup
$setup_message="<b>Your password has been created!<\/b><br><br>";
if(-e $setupfile){ask_setup(2);}else{ask_setup(1);}

} #sub

#************************************************
sub get_pass{

read_pass();
# print password page
start_html();
print header();
print <<START_HTML;
<body bgcolor="white"><h1>$program_name Password</h1>
Enter your password!<br>
<br>
<form name="form1" method="post" action="$program_file">
<input type="hidden" name="action" value="check_pass">
  Username:<br>  
  <input type="text" name="USER" size="50" maxlength="12">
    <br>
    <br>
  Password:<br>    
  <input type="password" name="PASS1" size="50" maxlength="8">
    <br><br>
  <input type="submit" value="Log in!">
</form>
<br><br>
<font size="2">$program_name $version, $copyright</font>
START_HTML
end_html();
exit;

} #sub

#************************************************
sub check_pass{

#check password
read_pass();
if (crypt($pass1,$pass1) ne $PASS || $user ne $USER){
# if password is wrong
start_html();
print header();
print <<START_HTML;
<body bgcolor="white"><h1>$program_name Password</h1>
<b>The password you entered was wrong! Try again.</b><br>
<br>
<form name="form1" method="post" action="$program_file">
<input type="hidden" name="action" value="check_pass">
  Username:<br>  
  <input type="text" name="USER" size="50" maxlength="12">
    <br>
    <br>
  Password:<br>    
  <input type="password" name="PASS1" size="50" maxlength="8">
    <br><br>
  <input type="submit" value="Log in!">
</form>
<br><br>
<font size="2">$program_name $version, $copyright</font>
START_HTML
end_html();
exit;
} else {
# if password is right
if(-e $setupfile){ask_setup(2);}else{ask_setup(1);}
}#if

} #sub

#************************************************
sub read_pass{
$path=$passfile;
open(FILE, $path) || ask_pass(1);
    while (<FILE>) {
    @variables = split(/$del1/);
    } #while
close(FILE);

$USER = $variables[0];
$PASS = $variables[1];
} #sub



#************************************************
# Misc Stuff
#************************************************
sub checkemail

 {
 my $testmail = $_[0];
  if ($testmail =~ /(@.*@)|(\.\.)|(@\.)|(\.@)|(^\.)/ ||
  $testmail !~ /^.+\@(\[?)[a-zA-Z0-9\-\.]+\.([a-zA-Z]{2,3}|[0-9]{1,3})(\]?)$/ ||
  $testmail =~ / /)
   {
     return 0;
   }
   else 
    {
      return 1;
    }
}#sub

#************************************************
sub checkurl{
my $checkurl=$_[0];

if ($checkurl !~ /^http/ && $checkurl !~ /^ftp/){$checkurl="http://".$checkurl;}

return $checkurl;

}#sub

#************************************************
sub make_date{
my $datevalue = $_[0];
my $datestyle = $_[1];

$Jetztzeit = localtime($datevalue);
if ($datestyle<7){&change_date_no;}
if ($datestyle==7||$datestyle==8||$datestyle==9||$datestyle==10){&change_date_words;}
@Zeit = split(/ +/,$Jetztzeit);
if ($datestyle==2||$datestyle==4||$datestyle==6||$datestyle==8||$datestyle==10){$Zeit[4]=substr($Zeit[4],2,2);};
if ($datestyle==1) {$datum=$Zeit[2]."/".$Zeit[1]."/".$Zeit[4];}
if ($datestyle==2) {$datum=$Zeit[2]."/".$Zeit[1]."/".$Zeit[4];}
if ($datestyle==3) {$datum=$Zeit[1]."/".$Zeit[2]."/".$Zeit[4];}
if ($datestyle==4) {$datum=$Zeit[1]."/".$Zeit[2]."/".$Zeit[4];}
if ($datestyle==5) {$datum=$Zeit[2].".".$Zeit[1].".".$Zeit[4];}
if ($datestyle==6) {$datum=$Zeit[2].".".$Zeit[1].".".$Zeit[4];}
if ($datestyle==7) {$datum=$Zeit[2]." ".$Zeit[1]." ".$Zeit[4];}
if ($datestyle==8) {$datum=$Zeit[2]." ".$Zeit[1]." ".$Zeit[4];}
if ($datestyle==9) {$datum=$Zeit[4]." ".$Zeit[1]." ".$Zeit[2];}
if ($datestyle==10){$datum=$Zeit[4]." ".$Zeit[1]." ".$Zeit[2];}
return $datum;
}#sub


#************************************************
sub change_date_no{
 $Jetztzeit =~ s/Jan/01/;
 $Jetztzeit =~ s/Feb/02/;
 $Jetztzeit =~ s/Mar/03/;
 $Jetztzeit =~ s/Apr/04/;
 $Jetztzeit =~ s/May/05/;
 $Jetztzeit =~ s/Jun/06/;
 $Jetztzeit =~ s/Jul/07/;
 $Jetztzeit =~ s/Aug/08/;
 $Jetztzeit =~ s/Sep/09/;
 $Jetztzeit =~ s/Oct/10/;
 $Jetztzeit =~ s/Nov/11/;
 $Jetztzeit =~ s/Dec/12/;
}
sub change_date_words{
 $Jetztzeit =~ s/Jan/January/;
 $Jetztzeit =~ s/Feb/February/;
 $Jetztzeit =~ s/Mar/March/;
 $Jetztzeit =~ s/Apr/April/;
 $Jetztzeit =~ s/May/May/;
 $Jetztzeit =~ s/Jun/June/;
 $Jetztzeit =~ s/Jul/July/;
 $Jetztzeit =~ s/Aug/August/;
 $Jetztzeit =~ s/Sep/September/;
 $Jetztzeit =~ s/Oct/October/;
 $Jetztzeit =~ s/Nov/November/;
 $Jetztzeit =~ s/Dec/December/;
}

#************************************************
sub ersetzen{
my $ersetzen=$_[0];

$ersetzen=~s//&#161;/gs;
$ersetzen=~s//&#162;/gs;
$ersetzen=~s//&#163;/gs;
$ersetzen=~s//&#165;/gs;
$ersetzen=~s//&#167;/gs;
$ersetzen=~s//&#168;/gs;
$ersetzen=~s//&#169;/gs;
$ersetzen=~s//&#170;/gs;
$ersetzen=~s//&#171;/gs;
$ersetzen=~s//&#172;/gs;
$ersetzen=~s//&#174;/gs;
$ersetzen=~s//&#175;/gs;
$ersetzen=~s//&#176;/gs;
$ersetzen=~s//&#177;/gs;
$ersetzen=~s//&#180;/gs;
$ersetzen=~s//&#181;/gs;
$ersetzen=~s//&#182;/gs;
$ersetzen=~s//&#183;/gs;
$ersetzen=~s//&#184;/gs;
$ersetzen=~s//&#186;/gs;
$ersetzen=~s//&#187;/gs;
$ersetzen=~s//&#191;/gs;
$ersetzen=~s//&#192;/gs;
$ersetzen=~s//&#193;/gs;
$ersetzen=~s//&#194;/gs;
$ersetzen=~s//&#195;/gs;
$ersetzen=~s//&#196;/gs;
$ersetzen=~s//&#197;/gs;
$ersetzen=~s//&#198;/gs;
$ersetzen=~s//&#199;/gs;
$ersetzen=~s//&#200;/gs;
$ersetzen=~s//&#201;/gs;
$ersetzen=~s//&#202;/gs;
$ersetzen=~s//&#203;/gs;
$ersetzen=~s//&#204;/gs;
$ersetzen=~s//&#205;/gs;
$ersetzen=~s//&#206;/gs;
$ersetzen=~s//&#207;/gs;
$ersetzen=~s//&#209;/gs;
$ersetzen=~s//&#210;/gs;
$ersetzen=~s//&#211;/gs;
$ersetzen=~s//&#212;/gs;
$ersetzen=~s//&#213;/gs;
$ersetzen=~s//&#214;/gs;
$ersetzen=~s//&#215;/gs;
$ersetzen=~s//&#216;/gs;
$ersetzen=~s//&#217;/gs;
$ersetzen=~s//&#218;/gs;
$ersetzen=~s//&#219;/gs;
$ersetzen=~s//&#220;/gs;
$ersetzen=~s//&#223;/gs;
$ersetzen=~s//&#224;/gs;
$ersetzen=~s//&#225;/gs;
$ersetzen=~s//&#226;/gs;
$ersetzen=~s//&#227;/gs;
$ersetzen=~s//&#228;/gs;
$ersetzen=~s//&#229;/gs;
$ersetzen=~s//&#230;/gs;
$ersetzen=~s//&#231;/gs;
$ersetzen=~s//&#232;/gs;
$ersetzen=~s//&#233;/gs;
$ersetzen=~s//&#234;/gs;
$ersetzen=~s//&#235;/gs;
$ersetzen=~s//&#236;/gs;
$ersetzen=~s//&#237;/gs;
$ersetzen=~s//&#238;/gs;
$ersetzen=~s//&#239;/gs;
$ersetzen=~s//&#241;/gs;
$ersetzen=~s//&#242;/gs;
$ersetzen=~s//&#243;/gs;
$ersetzen=~s//&#244;/gs;
$ersetzen=~s//&#245;/gs;
$ersetzen=~s//&#246;/gs;
$ersetzen=~s//&#247;/gs;
$ersetzen=~s//&#248;/gs;
$ersetzen=~s//&#249;/gs;
$ersetzen=~s//&#250;/gs;
$ersetzen=~s//&#251;/gs;
$ersetzen=~s//&#252;/gs;
$ersetzen=~s//&#255;/gs;
return $ersetzen
}


#************************************************
sub baderror{
start_html();
my $error_no = $_[0];
print header();
print <<START_HTML;
<body bgcolor="white"><h1>Baaaad Error!!</h1>
Oh boy! A real bad error has occured!<br>
I don't even know what it is.<br>
I think you should contact <a href="mailto:manu\@sprain.ch?subject?Baderror: $program_name/$version/$error_no">sprain</a>.
<br><br>
<font size="2">$program_name $version, $copyright</font>
START_HTML
end_html();
exit;

} #sub

#************************************************
sub mail{

open(MAIL,"|$sendmail -t") || die;
print MAIL "To: $setup_email\n";
print MAIL "From: $setup_email\n";
print MAIL "Subject: $setup_subject\n";
print MAIL "Content-Type: text/plain; charset=\"iso-8859-1\"\; format=\"flowed\"\n<x-flowed iso-8859-1>\nContent-Transfer-Encoding: quoted-printable\n\n";
print MAIL "$mail_content\n";
close(MAIL);

}#sub

