#!/usr/bin/perl

#################################################################
# DO NOT EDIT THIS FILE - SEE README.TXT FOR SETUP INSTRUCTIONS #
#################################################################

print "Content-type: text/html\n\n";

$len  = $ENV{'CONTENT_LENGTH'};

if ($ENV{'REQUEST_METHOD'} eq "POST") {
   read(STDIN, $query, $len);

} else {
   $query = $ENV{'QUERY_STRING'};

}

for (split(/\&/, $query)) {
   next if (!$_);
   tr/+/ /;
   s/%([a-fA-F0-9][a-fA-F0-9])/pack("C", hex($1))/eg;
   s/\r//g;
   ($a, $b) = split(/=/);
   $FORM{$a} = $b;

}

open (FILE, "searchindex.dat") or &medie ("Can't open searchindex.dat - reason: $!");
@index = <FILE>;
close (FILE);

$searchwords = $FORM{'Q'};

$searchwords =~ s/[\|\\\/\!\@\#\$\%\^\&\*\(\)\[\]\{\}\;\:\'\"\+\=\-\_\?\.\,]//isg;

if (!$FORM{'X'}) {
   $searchwords =~ s/\s+/\|/sg;
}

for ($i = 0; $i < @index; $i++) {

   next if (!$index[$i]);
   $ok = 0;
   ($URL, $title, $description, $keywords) = split (/\|\%\%\|/, $index[$i]);

   if ($searchwords) {
      if ($FORM{'E'}) {
         $ok = 1 if ($keywords =~ /\b(?:$searchwords)\b/i);
      }

      $ok = 1 if ($title =~ /\b(?:$searchwords)\b/i);

   }

   if ($ok) {
      $found++;

      if (($FORM{'S'} < $found) and ($found <= $FORM{'S'} + 10)) {
         $description =~ s/\b($searchwords)\b/<b>$1<\/b>/isg;
         $title =~ s/\b($searchwords)\b/<b>$1<\/b>/isg;
         $result .= "<b>$found</b> - <a href=\"$URL\">$title</a> - $description\n<br><br>\n";

      }

   }

   if ($found == $FORM{'S'} + 11) {
      $next = $FORM{'S'} + 10;
      $found--;
      last;
   }

}

$start = $FORM{'S'} + 1;

if (!$found) {
   $result = "No results found.\n<br><br>\n";

} else {
   $result = "Showing results $start through $found\n<br><br>\n$result";

}

if ($FORM{'S'}) {
   $prev = $FORM{'S'} - 10;
   $prev = 0 if ($prev < 0);
   $link = qq(<a href="search.cgi?Q=$FORM{'Q'}&E=$FORM{'E'}&X=$FORM{'X'}&S=$prev">&lt; &lt; Prev</a>);

}

$link .= " | " if (($FORM{'S'}) and ($next));

$link .= qq(<a href="search.cgi?Q=$FORM{'Q'}&E=$FORM{'E'}&X=$FORM{'X'}&S=$next">Next &gt; &gt;</a>\n) if ($next);

open (TEMP, "results.html") or &medie ("Can't open results.html - reason: $!");
$template = join ('', <TEMP>);
close (TEMP);

$copy = qq(<font size=1>Search powered by SFE Search. &copy; 1999 <a href="http://www.hostfacts.com/scripts/">SFE Software</a>. All Rights Reserved.</font>\n<br>\n);

$template =~ s#<!-- KEYWORDS -->#$FORM{'Q'}#sg;
$template =~ s#<!-- RESULTS -->#$result$copy#sg;
$template =~ s#<!-- LINK -->#$link#sg;

print "$template";

sub medie {

my $message = shift;
print <<DEATH;
<html>
<head>
<title>Script Error</title>
</head>
<body>
<ul><b>Script Error</b>
<br><br>
$message
<br><br>
Make sure the required files are in the same directory as this script and are accessible by
the script.
</ul>
</body>
</html>
DEATH

}

exit 1;
